/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.users.SpaceAllocation;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class SpaceUsage {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final long used;
    protected final SpaceAllocation allocation;

    public SpaceUsage(long used, SpaceAllocation allocation) {
        this.used = used;
        if (allocation == null) {
            throw new IllegalArgumentException("Required value for 'allocation' is null");
        }
        this.allocation = allocation;
    }

    public long getUsed() {
        return this.used;
    }

    public SpaceAllocation getAllocation() {
        return this.allocation;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.used, this.allocation});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            SpaceUsage other = (SpaceUsage)obj;
            return this.used == other.used && (this.allocation == other.allocation || this.allocation.equals(other.allocation));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<SpaceUsage> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(SpaceUsage.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(SpaceUsage.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<SpaceUsage> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public SpaceUsage deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            Long used = null;
            SpaceAllocation allocation = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("used".equals(_field)) {
                    used = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, used);
                    _p.nextToken();
                    continue;
                }
                if ("allocation".equals(_field)) {
                    allocation = _p.readValueAs(SpaceAllocation.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (used == null) {
                throw new JsonParseException(_p, "Required field \"used\" is missing.");
            }
            if (allocation == null) {
                throw new JsonParseException(_p, "Required field \"allocation\" is missing.");
            }
            return new SpaceUsage(used, allocation);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<SpaceUsage> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(SpaceUsage.class);
        }

        public Serializer(boolean unwrapping) {
            super(SpaceUsage.class, unwrapping);
        }

        @Override
        protected JsonSerializer<SpaceUsage> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(SpaceUsage value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("used", value.used);
            g.writeObjectField("allocation", value.allocation);
        }
    }
}

