/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import org.fest.assertions.api.AbstractComparableAssert;
import org.fest.assertions.core.NumberAssert;
import org.fest.assertions.internal.Bytes;
import org.fest.assertions.internal.ComparatorBasedComparisonStrategy;
import org.fest.util.VisibleForTesting;

public class ByteAssert
extends AbstractComparableAssert<ByteAssert, Byte>
implements NumberAssert<Byte> {
    @VisibleForTesting
    Bytes bytes = Bytes.instance();

    protected ByteAssert(Byte actual) {
        super(actual, ByteAssert.class);
    }

    @Override
    public ByteAssert isEqualTo(byte expected) {
        this.bytes.assertEqual(this.info, this.actual, expected);
        return this;
    }

    @Override
    public ByteAssert isNotEqualTo(byte other) {
        this.bytes.assertNotEqual(this.info, this.actual, other);
        return this;
    }

    public ByteAssert isZero() {
        this.bytes.assertIsZero(this.info, (Comparable)this.actual);
        return this;
    }

    public ByteAssert isNotZero() {
        this.bytes.assertIsNotZero(this.info, (Comparable)this.actual);
        return this;
    }

    public ByteAssert isPositive() {
        this.bytes.assertIsPositive(this.info, (Comparable)this.actual);
        return this;
    }

    public ByteAssert isNegative() {
        this.bytes.assertIsNegative(this.info, (Comparable)this.actual);
        return this;
    }

    public ByteAssert isNotNegative() {
        this.bytes.assertIsNotNegative(this.info, (Comparable)this.actual);
        return this;
    }

    public ByteAssert isNotPositive() {
        this.bytes.assertIsNotPositive(this.info, (Comparable)this.actual);
        return this;
    }

    @Override
    public ByteAssert isLessThan(byte other) {
        this.bytes.assertLessThan(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public ByteAssert isLessThanOrEqualTo(byte other) {
        this.bytes.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public ByteAssert isGreaterThan(byte other) {
        this.bytes.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public ByteAssert isGreaterThanOrEqualTo(byte other) {
        this.bytes.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return this;
    }

    @Override
    public ByteAssert usingComparator(Comparator<? super Byte> customComparator) {
        super.usingComparator(customComparator);
        this.bytes = new Bytes(new ComparatorBasedComparisonStrategy(customComparator));
        return (ByteAssert)this.myself;
    }

    @Override
    public ByteAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.bytes = Bytes.instance();
        return (ByteAssert)this.myself;
    }
}

