/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.error;

import java.util.Date;
import org.fest.assertions.error.BasicErrorMessageFactory;
import org.fest.assertions.error.ErrorMessageFactory;
import org.fest.assertions.internal.ComparisonStrategy;
import org.fest.assertions.internal.StandardComparisonStrategy;
import org.fest.util.Dates;

public class ShouldBeAfter
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldBeAfter(Date actual, Date other, ComparisonStrategy comparisonStrategy) {
        return new ShouldBeAfter(actual, other, comparisonStrategy);
    }

    public static ErrorMessageFactory shouldBeAfter(Date actual, Date other) {
        return new ShouldBeAfter(actual, other, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory shouldBeAfter(Date actual, int year) {
        Date januaryTheFirstOfGivenYear = Dates.parse(year + "-01-01");
        return new ShouldBeAfter(actual, januaryTheFirstOfGivenYear, StandardComparisonStrategy.instance());
    }

    private ShouldBeAfter(Date actual, Date other, ComparisonStrategy comparisonStrategy) {
        super("expected:<%s> to be strictly after:<%s>%s", actual, other, comparisonStrategy);
    }
}

