/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.error;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.fest.assertions.error.AbstractShouldHaveTextContent;
import org.fest.assertions.error.ErrorMessageFactory;

public class ShouldHaveEqualContent
extends AbstractShouldHaveTextContent {
    public static ErrorMessageFactory shouldHaveEqualContent(File actual, File expected, List<String> diffs) {
        return new ShouldHaveEqualContent(actual, expected, ShouldHaveEqualContent.diffsAsString(diffs));
    }

    public static ErrorMessageFactory shouldHaveEqualContent(InputStream actual, InputStream expected, List<String> diffs) {
        return new ShouldHaveEqualContent(actual, expected, ShouldHaveEqualContent.diffsAsString(diffs));
    }

    private ShouldHaveEqualContent(File actual, File expected, String diffs) {
        super("file:<%s> and file:<%s> do not have equal content:", actual, expected);
        this.diffs = diffs;
    }

    private ShouldHaveEqualContent(InputStream actual, InputStream expected, String diffs) {
        super("InputStreams do not have equal content:", actual, expected);
        this.diffs = diffs;
    }
}

