/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeinghelper.exception;

import com.github.codeinghelper.configuration.ExceptionCodeConfiguration;
import com.github.codeinghelper.exception.http.ForbiddenException;
import com.github.codeinghelper.exception.http.HttpException;
import com.github.codeinghelper.exception.http.ParameterException;
import com.github.codeinghelper.exception.http.UnAuthenticatedException;
import com.github.codeinghelper.response.UnifyResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class GlobalExceptionAdvice {
    @Autowired
    private ExceptionCodeConfiguration codeConfiguration;

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.INTERNAL_SERVER_ERROR)
    public UnifyResponse handleException(HttpServletRequest req, Exception e) {
        String requestUrl = req.getRequestURI();
        String method = req.getMethod();
        System.out.println(e);
        UnifyResponse message = new UnifyResponse(9999, "\u670d\u52a1\u5668\u5f02\u5e38", method + " " + requestUrl);
        return message;
    }

    @ExceptionHandler(value={HttpException.class})
    public ResponseEntity<UnifyResponse> handleHttpException(HttpServletRequest req, HttpException e) {
        String requestUrl = req.getRequestURI();
        String method = req.getMethod();
        UnifyResponse message = new UnifyResponse(e.getCode(), this.codeConfiguration.getMessage(e.getCode()), method + " " + requestUrl);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpStatus httpStatus = HttpStatus.resolve((int)e.getHttpStatusCode());
        ResponseEntity r = new ResponseEntity((Object)message, (MultiValueMap)headers, httpStatus);
        return r;
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    @ResponseStatus(code=HttpStatus.BAD_REQUEST)
    public UnifyResponse handleBeanValidation(HttpServletRequest req, MethodArgumentNotValidException e) {
        String requestUrl = req.getRequestURI();
        String method = req.getMethod();
        List errors = e.getBindingResult().getAllErrors();
        String message = this.formatAllErrorMessages(errors);
        return new UnifyResponse(10001, message, method + " " + requestUrl);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(code=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public UnifyResponse handleConstraintException(HttpServletRequest req, ConstraintViolationException e) {
        String requestUrl = req.getRequestURI();
        String method = req.getMethod();
        String message = e.getMessage();
        return new UnifyResponse(40000, message, method + " " + requestUrl);
    }

    @ExceptionHandler(value={ParameterException.class})
    @ResponseStatus(code=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public UnifyResponse handleParameterException(HttpServletRequest req, ParameterException e) {
        String requestUrl = req.getRequestURI();
        String method = req.getMethod();
        String message = e.getMessage();
        return new UnifyResponse(e.getCode(), this.codeConfiguration.getMessage(e.getCode()), method + " " + requestUrl);
    }

    @ExceptionHandler(value={UnAuthenticatedException.class})
    @ResponseStatus(code=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public UnifyResponse handleUnAuthenticatedException(HttpServletRequest req, UnAuthenticatedException e) {
        String requestUrl = req.getRequestURI();
        String method = req.getMethod();
        String message = e.getMessage();
        return new UnifyResponse(e.getCode(), this.codeConfiguration.getMessage(e.getCode()), method + " " + requestUrl);
    }

    @ExceptionHandler(value={ForbiddenException.class})
    @ResponseStatus(code=HttpStatus.FORBIDDEN)
    @ResponseBody
    public UnifyResponse handleForbiddenException(HttpServletRequest req, ForbiddenException e) {
        String requestUrl = req.getRequestURI();
        String method = req.getMethod();
        return new UnifyResponse(e.getCode(), this.codeConfiguration.getMessage(e.getCode()), method + " " + requestUrl);
    }

    private String formatAllErrorMessages(List<ObjectError> errors) {
        StringBuffer errorMsg = new StringBuffer();
        errors.forEach(error -> errorMsg.append(error.getDefaultMessage()).append(';'));
        return errorMsg.toString();
    }
}

