/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeinghelper.util;

import java.util.Map;
import java.util.UUID;

public class StringUtil {
    public static boolean isEmptyOrNull(String str) {
        return str == null || str.length() == 0 || str.trim().length() == 0;
    }

    public static String appendZero(String str, int strLength) {
        int strLen = str.length();
        StringBuffer sb = null;
        while (strLen < strLength) {
            sb = new StringBuffer();
            sb.append("0").append(str);
            str = sb.toString();
            strLen = str.length();
        }
        return str;
    }

    public static double castDouble(Object obj, double defaultValue) {
        String strValue;
        double value = defaultValue;
        if (obj != null && !StringUtil.isEmptyOrNull(strValue = StringUtil.castString(obj))) {
            try {
                value = Double.parseDouble(strValue);
            }
            catch (NumberFormatException e) {
                value = defaultValue;
            }
        }
        return value;
    }

    public static int castInt(Object obj, int defaultValue) {
        String strValue;
        int value = defaultValue;
        if (obj != null && !StringUtil.isEmptyOrNull(strValue = StringUtil.castString(obj))) {
            try {
                value = Integer.parseInt(strValue);
            }
            catch (NumberFormatException e) {
                value = defaultValue;
            }
        }
        return value;
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static String replaceString(String str, String oldString, String newString) {
        if (StringUtil.isEmptyOrNull(str)) {
            return "";
        }
        return str.replaceAll(oldString, newString);
    }

    public static String replaceString(String str, Map<String, String> oldNewMap) {
        if (oldNewMap == null || oldNewMap.size() == 0) {
            return str;
        }
        String newStr = str;
        for (Map.Entry<String, String> entry : oldNewMap.entrySet()) {
            newStr = newStr.replace(entry.getKey(), entry.getValue());
        }
        return newStr;
    }

    private static String castString(Object obj) {
        return StringUtil.castString(obj, "");
    }

    public static String castString(Object obj, String defaultValue) {
        return obj != null ? String.valueOf(obj) : defaultValue;
    }

    public static String subArr2String(int i, int j, char[] arr) {
        if (j < i) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int k = i; k < j; ++k) {
            builder.append(arr[k]);
        }
        return builder.toString();
    }

    public static String subArr2String(int i, int j, String[] arr, String separator) {
        if (j < i) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int k = i; k < j - 1; ++k) {
            if (separator != null) {
                builder.append(arr[k]).append(separator);
                continue;
            }
            builder.append(arr[k]);
        }
        builder.append(arr[j - 1]);
        return builder.toString().trim();
    }
}

