/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.services;

import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.database.TableName;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.mappers.BaseMapper;
import com.github.collinalpert.java2db.utilities.Lambda2Sql;
import com.github.collinalpert.java2db.utilities.SqlPredicate;
import com.github.collinalpert.java2db.utilities.Utilities;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class BaseService<T extends BaseEntity> {
    private final String typeName;
    private final String tableName;
    private BaseMapper<T> mapper;

    public BaseService(Class<T> clazz) {
        String name;
        this.mapper = new BaseMapper<T>(clazz);
        this.typeName = name = clazz.getSimpleName();
        if (clazz.getAnnotation(TableName.class) == null) {
            this.tableName = name.toLowerCase();
            return;
        }
        this.tableName = clazz.getAnnotation(TableName.class).value();
    }

    public boolean create(T instance) {
        StringBuilder insertQuery = new StringBuilder("insert into ").append(this.tableName).append(" (");
        String databaseFields = Utilities.getAllFields(instance).stream().map(Field::getName).collect(Collectors.joining(", "));
        insertQuery.append(databaseFields).append(") values (");
        Utilities.getAllFields(instance, BaseEntity.class).forEach(x -> {
            x.setAccessible(true);
            try {
                Object value = x.get(instance);
                if (value == null) {
                    insertQuery.append("default, ");
                    return;
                }
                if (value instanceof String) {
                    insertQuery.append("'").append(value).append("'").append(", ");
                    return;
                }
                insertQuery.append(value).append(", ");
            }
            catch (IllegalAccessException e) {
                System.err.printf("Unable to get value from field %s for type %s\n", x.getName(), this.typeName);
            }
        });
        insertQuery.append("default)");
        Utilities.log(insertQuery.toString());
        try (DBConnection connection = new DBConnection();){
            if (connection.update(insertQuery.toString())) {
                Utilities.logf("%s successfully created!", this.typeName);
                boolean bl = true;
                return bl;
            }
            System.err.printf("Unable to create type %s\n", this.typeName);
            boolean bl = false;
            return bl;
        }
    }

    protected ResultSet getByPredicate(SqlPredicate<T> predicate, DBConnection connection) {
        String query = "select * from " + this.tableName + " where " + Lambda2Sql.toSql(predicate);
        Utilities.log(query);
        return connection.execute(query);
    }

    public T getSingle(SqlPredicate<T> predicate) {
        try (DBConnection connection = new DBConnection();){
            T t = this.mapper.map(this.getByPredicate(predicate, connection));
            return t;
        }
    }

    public List<T> getMultiple(SqlPredicate<T> predicate) {
        try (DBConnection connection = new DBConnection();){
            List<T> list = this.mapper.mapToList(this.getByPredicate(predicate, connection));
            return list;
        }
    }

    public T getById(int id) {
        return (T)this.getSingle(x -> x.getId() == id);
    }

    public List<T> getAll() {
        return this.getMultiple(x -> true);
    }

    public boolean update(T instance) {
        StringBuilder updateQuery = new StringBuilder("update ").append(this.tableName).append(" set ");
        ArrayList fieldSetterList = new ArrayList();
        Utilities.getAllFields(instance, BaseEntity.class).forEach(x -> {
            x.setAccessible(true);
            try {
                Object value = x.get(instance);
                if (value instanceof String) {
                    fieldSetterList.add(String.format("%s = '%s'", x.getName(), value));
                    return;
                }
                fieldSetterList.add(x.getName() + " = " + value);
            }
            catch (IllegalAccessException e) {
                System.err.printf("Error getting value for field %s from type %s\n", x.getName(), this.typeName);
            }
        });
        updateQuery.append(String.join((CharSequence)", ", fieldSetterList)).append(" where id = ").append(((BaseEntity)instance).getId());
        Utilities.log(updateQuery.toString());
        try (DBConnection connection = new DBConnection();){
            if (connection.update(updateQuery.toString())) {
                Utilities.logf("%s with id %d was successfully updated", this.typeName, ((BaseEntity)instance).getId());
                boolean bl = true;
                return bl;
            }
            System.err.printf("%s with id %d could not be updated\n", this.typeName, ((BaseEntity)instance).getId());
            boolean bl = false;
            return bl;
        }
    }

    public void delete(T instance) {
        this.delete(((BaseEntity)instance).getId());
    }

    public void delete(int id) {
        try (DBConnection connection = new DBConnection();){
            boolean success = connection.update("delete from " + this.tableName + " where id=?", id);
            if (success) {
                Utilities.logf("%s with id %d successfully deleted!", this.typeName, id);
            }
        }
    }
}

