/*
 * Decompiled with CFR 0.152.
 */
package com.trigersoft.jaque.expression;

import com.trigersoft.jaque.expression.Expression;
import com.trigersoft.jaque.expression.ExpressionVisitor;
import com.trigersoft.jaque.expression.InvocableExpression;
import com.trigersoft.jaque.expression.ParameterExpression;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.util.List;

public final class MemberExpression
extends InvocableExpression {
    private final Expression _instance;
    private final Member _member;

    MemberExpression(int expressionType, Expression instance, Member member, Class<?> resultType, List<ParameterExpression> params) {
        super(expressionType, resultType, params);
        AccessibleObject ao;
        if (member instanceof AccessibleObject && !(ao = (AccessibleObject)((Object)member)).isAccessible()) {
            ao.setAccessible(true);
        }
        this._instance = instance;
        this._member = member;
    }

    public final Member getMember() {
        return this._member;
    }

    public final Expression getInstance() {
        return this._instance;
    }

    @Override
    protected <T> T visit(ExpressionVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        Member m = this.getMember();
        String me = this.getInstance() != null ? this.getInstance().toString() : m.getDeclaringClass().getSimpleName();
        return me + "." + (m instanceof Constructor ? "<new>" : m.getName());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this._instance == null ? 0 : this._instance.hashCode());
        result = 31 * result + (this._member == null ? 0 : this._member.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof MemberExpression)) {
            return false;
        }
        MemberExpression other = (MemberExpression)obj;
        if (this._instance == null ? other._instance != null : !this._instance.equals(other._instance)) {
            return false;
        }
        return !(this._member == null ? other._member != null : !this._member.equals(other._member));
    }
}

