/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.database;

import com.github.collinalpert.java2db.modules.TableModule;
import java.lang.reflect.Field;

public class TableColumnReference {
    private static final TableModule tableModule = TableModule.getInstance();
    private final String tableName;
    private final Field column;
    private final String alias;

    public TableColumnReference(String tableName, String alias, Field column) {
        this.tableName = tableName;
        this.alias = alias.isBlank() ? tableName : alias;
        this.column = column;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getAlias() {
        return this.alias;
    }

    public Field getColumn() {
        return this.column;
    }

    public String getSQLNotation() {
        return String.format("`%s`.`%s`", this.getAlias(), tableModule.getColumnName(this.column));
    }

    public String getAliasNotation() {
        return this.getAlias() + "_" + tableModule.getColumnName(this.column);
    }

    public String toString() {
        return this.getSQLNotation();
    }
}

