/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.mappers;

import com.github.collinalpert.java2db.mappers.Mappable;
import com.github.collinalpert.java2db.modules.ArrayModule;
import com.github.collinalpert.java2db.modules.FieldModule;
import com.github.collinalpert.java2db.utilities.IoC;
import com.github.collinalpert.java2db.utilities.Utilities;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class FieldMapper<T>
implements Mappable<T> {
    private static final Set<Class<?>> simpleValueTypes = new HashSet();
    private final Class<T> underlyingClass;

    public FieldMapper(Class<T> underlyingClass) {
        this.underlyingClass = underlyingClass;
    }

    @Override
    public Optional<T> map(ResultSet set) throws SQLException {
        if (simpleValueTypes.contains(this.underlyingClass)) {
            if (set.next()) {
                return Optional.ofNullable(set.getObject(1, this.underlyingClass));
            }
            set.close();
            return Optional.empty();
        }
        Object instance = IoC.createInstance(this.underlyingClass);
        List<Field> fields = FieldModule.getInstance().getAllFields(this.underlyingClass);
        if (set.next()) {
            for (Field field : fields) {
                field.setAccessible(true);
                Utilities.tryAction(() -> field.set(instance, set.getObject(field.getName(), field.getType())));
            }
            set.close();
            return Optional.of(instance);
        }
        set.close();
        return Optional.empty();
    }

    @Override
    public List<T> mapToList(ResultSet set) throws SQLException {
        return (List)this.mapInternal(set, new LinkedList(), List::add, Function.identity());
    }

    @Override
    public Stream<T> mapToStream(ResultSet set) throws SQLException {
        return this.mapInternal(set, Stream.builder(), Stream.Builder::accept, Stream.Builder::build);
    }

    @Override
    public T[] mapToArray(ResultSet set) throws SQLException {
        return this.mapInternal(set, new ArrayModule<T>(this.underlyingClass, 5), ArrayModule::addElement, ArrayModule::getArray);
    }

    @Override
    public <K, V> Map<K, V> mapToMap(ResultSet set, Function<T, K> keyMapping, Function<T, V> valueMapping) throws SQLException {
        return (Map)this.mapInternal(set, new HashMap(), (m, e) -> m.put(keyMapping.apply(e), valueMapping.apply(e)), Function.identity());
    }

    @Override
    public Set<T> mapToSet(ResultSet set) throws SQLException {
        return (Set)this.mapInternal(set, new HashSet(), Set::add, Function.identity());
    }

    private <R, O> R mapInternal(ResultSet set, O container, BiConsumer<O, T> addFunction, Function<O, R> returnFunction) throws SQLException {
        if (simpleValueTypes.contains(this.underlyingClass)) {
            while (set.next()) {
                addFunction.accept(container, set.getObject(1, this.underlyingClass));
            }
            return returnFunction.apply(container);
        }
        while (set.next()) {
            Object instance = IoC.createInstance(this.underlyingClass);
            for (Field field : FieldModule.getInstance().getAllFields(this.underlyingClass)) {
                field.setAccessible(true);
                Utilities.tryAction(() -> field.set(instance, set.getObject(field.getName(), field.getType())));
            }
            addFunction.accept(container, instance);
        }
        set.close();
        return returnFunction.apply(container);
    }

    static {
        simpleValueTypes.add(String.class);
        simpleValueTypes.add(Byte.class);
        simpleValueTypes.add(Byte.TYPE);
        simpleValueTypes.add(Short.class);
        simpleValueTypes.add(Short.TYPE);
        simpleValueTypes.add(Integer.class);
        simpleValueTypes.add(Integer.TYPE);
        simpleValueTypes.add(Long.class);
        simpleValueTypes.add(Long.TYPE);
        simpleValueTypes.add(Double.class);
        simpleValueTypes.add(Double.TYPE);
        simpleValueTypes.add(Float.class);
        simpleValueTypes.add(Float.TYPE);
        simpleValueTypes.add(Boolean.class);
        simpleValueTypes.add(Boolean.TYPE);
        simpleValueTypes.add(Character.class);
        simpleValueTypes.add(Character.TYPE);
    }
}

