/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries.async;

import com.github.collinalpert.expressions.expression.LambdaExpression;
import com.github.collinalpert.java2db.database.ConnectionConfiguration;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.queries.EntityQuery;
import com.github.collinalpert.java2db.queries.async.AsyncEntityProjectionQuery;
import com.github.collinalpert.java2db.queries.async.AsyncQueryable;
import com.github.collinalpert.java2db.queries.builder.ProjectionQueryBuilder;
import com.github.collinalpert.java2db.queries.builder.QueryBuilder;
import com.github.collinalpert.java2db.queries.ordering.OrderTypes;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import com.github.collinalpert.lambda2sql.functions.SqlPredicate;
import java.util.List;

public class AsyncEntityQuery<E extends BaseEntity>
extends EntityQuery<E>
implements AsyncQueryable<E> {
    public AsyncEntityQuery(Class<E> type, ConnectionConfiguration connectionConfiguration) {
        super(type, connectionConfiguration);
    }

    @Override
    public AsyncEntityQuery<E> where(SqlPredicate<E> predicate) {
        super.where(predicate);
        return this;
    }

    @Override
    public AsyncEntityQuery<E> orWhere(SqlPredicate<E> predicate) {
        super.orWhere(predicate);
        return this;
    }

    @Override
    public AsyncEntityQuery<E> orderBy(SqlFunction<E, ?> function) {
        super.orderBy(function, OrderTypes.ASCENDING);
        return this;
    }

    @Override
    public AsyncEntityQuery<E> orderBy(SqlFunction<E, ?>[] functions) {
        super.orderBy(functions, OrderTypes.ASCENDING);
        return this;
    }

    @Override
    public AsyncEntityQuery<E> orderBy(List<SqlFunction<E, ?>> functions) {
        super.orderBy(functions, OrderTypes.ASCENDING);
        return this;
    }

    @Override
    public AsyncEntityQuery<E> orderBy(SqlFunction<E, ?> function, OrderTypes orderType) {
        super.orderBy(function, orderType);
        return this;
    }

    @Override
    public AsyncEntityQuery<E> orderBy(SqlFunction<E, ?>[] functions, OrderTypes orderType) {
        super.orderBy(functions, orderType);
        return this;
    }

    @Override
    public AsyncEntityQuery<E> orderBy(List<SqlFunction<E, ?>> functions, OrderTypes orderType) {
        super.orderBy(functions, orderType);
        return this;
    }

    @Override
    public AsyncEntityQuery<E> limit(int limit, int offset) {
        super.limit(limit, offset);
        return this;
    }

    @Override
    public AsyncEntityQuery<E> limit(int limit) {
        super.limit(limit);
        return this;
    }

    @Override
    public <R> AsyncQueryable<R> project(SqlFunction<E, R> projection) {
        Class<?> returnType = LambdaExpression.parse(projection).getBody().getResultType();
        ProjectionQueryBuilder<E, R> queryBuilder = new ProjectionQueryBuilder<E, R>(projection, super.getTableName(), (QueryBuilder)this.queryBuilder);
        return new AsyncEntityProjectionQuery(returnType, queryBuilder, this.queryParameters, this.connectionConfiguration);
    }
}

