/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.expressions.expression;

import com.github.collinalpert.expressions.expression.Expression;
import com.github.collinalpert.expressions.expression.ExpressionVisitor;
import java.util.ArrayList;
import org.objectweb.asm.Label;

final class ExpressionStack
extends ArrayList<Expression> {
    private BranchExpression _parent;
    private boolean _reduced;

    ExpressionStack() {
        this((BranchExpression)null);
    }

    private ExpressionStack(BranchExpression parent) {
        this._parent = parent;
    }

    BranchExpression getParent() {
        return this._parent;
    }

    private void setParent(BranchExpression value) {
        this._parent = value;
    }

    boolean isReduced() {
        return this._reduced;
    }

    void reduce() {
        this._reduced = true;
    }

    void push(Expression item) {
        this.add(item);
    }

    int getDepth() {
        return this.getParent() != null ? this.getParent().getDepth() : 0;
    }

    Expression pop() {
        Expression obj = this.peek();
        this.remove(this.size() - 1);
        return obj;
    }

    Expression peek() {
        return (Expression)this.get(this.size() - 1);
    }

    static final class BranchExpression
    extends Expression {
        private final Expression _test;
        private final ExpressionStack _true;
        private final ExpressionStack _false;
        private final ExpressionStack _parent;

        BranchExpression(ExpressionStack parent, Expression test, Label label) {
            this(parent, test, null, null);
        }

        BranchExpression(ExpressionStack parent, Expression test, ExpressionStack trueE, ExpressionStack falseE) {
            super(6, Void.TYPE);
            this._parent = parent;
            this._test = test;
            if (trueE != null) {
                this._true = trueE;
                this._true.setParent(this);
            } else {
                this._true = new ExpressionStack(this);
            }
            if (falseE != null) {
                this._false = falseE;
                this._false.setParent(this);
            } else {
                this._false = new ExpressionStack(this);
            }
        }

        ExpressionStack getTrue() {
            return this._true;
        }

        ExpressionStack getFalse() {
            return this._false;
        }

        ExpressionStack get(boolean side) {
            return side ? this.getTrue() : this.getFalse();
        }

        Expression getTest() {
            return this._test;
        }

        ExpressionStack getParent() {
            return this._parent;
        }

        int getDepth() {
            return this._parent.getDepth() + 1;
        }

        @Override
        protected <T> T visit(ExpressionVisitor<T> v) {
            throw new IllegalStateException();
        }

        public String toString() {
            return "(" + this.getTest().toString() + " ? " + this.getTrue().toString() + " : " + this.getFalse().toString() + ")";
        }
    }
}

