/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries;

import com.github.collinalpert.java2db.database.ConnectionConfiguration;
import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.modules.ArrayModule;
import com.github.collinalpert.java2db.queries.QueryParameters;
import com.github.collinalpert.java2db.queries.Queryable;
import com.github.collinalpert.java2db.queries.builder.IQueryBuilder;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class EntityProjectionQuery<E extends BaseEntity, R>
implements Queryable<R> {
    private final Class<R> returnType;
    private final IQueryBuilder<E> queryBuilder;
    private final QueryParameters<E> queryParameters;
    private final ConnectionConfiguration connectionConfiguration;

    public EntityProjectionQuery(Class<R> returnType, IQueryBuilder<E> queryBuilder, QueryParameters<E> queryParameters, ConnectionConfiguration connectionConfiguration) {
        this.returnType = returnType;
        this.queryBuilder = queryBuilder;
        this.queryParameters = queryParameters;
        this.connectionConfiguration = connectionConfiguration;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<R> first() {
        try (DBConnection connection = new DBConnection(this.connectionConfiguration);){
            Optional optional;
            block17: {
                ResultSet result;
                block15: {
                    Optional<R> optional2;
                    block16: {
                        result = connection.execute(this.getQuery());
                        try {
                            if (!result.next()) break block15;
                            optional2 = Optional.ofNullable(result.getObject(1, this.returnType));
                            if (result == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return optional2;
                }
                optional = Optional.empty();
                if (result == null) break block17;
                result.close();
            }
            return optional;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    @Override
    public List<R> toList() {
        ArrayList list = new ArrayList();
        return this.resultHandling(list, List::add, Collections.emptyList(), Function.identity());
    }

    @Override
    public Stream<R> toStream() {
        Stream.Builder streamBuilder = Stream.builder();
        return this.resultHandling(streamBuilder, Stream.Builder::accept, Stream.empty(), Stream.Builder::build);
    }

    @Override
    public R[] toArray() {
        ArrayModule<R> arrayModule = new ArrayModule<R>(this.returnType, 20);
        Object[] defaultValue = (Object[])Array.newInstance(this.returnType, 0);
        return this.resultHandling(arrayModule, ArrayModule::addElement, defaultValue, ArrayModule::getArray);
    }

    @Override
    public <K, V> Map<K, V> toMap(Function<R, K> keyMapping, Function<R, V> valueMapping) {
        return this.resultHandling(new HashMap(), (m, v) -> m.put(keyMapping.apply(v), valueMapping.apply(v)), Collections.emptyMap(), Function.identity());
    }

    @Override
    public Set<R> toSet() {
        return this.resultHandling(new HashSet(), Set::add, Collections.emptySet(), Function.identity());
    }

    @Override
    public String getQuery() {
        return this.queryBuilder.build(this.queryParameters);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <T, D> T resultHandling(D dataStructure, BiConsumer<D, R> valueConsumer, T defaultValue, Function<D, T> valueMapping) {
        try (DBConnection connection = new DBConnection(this.connectionConfiguration);){
            D d;
            block14: {
                ResultSet result = connection.execute(this.getQuery());
                try {
                    while (result.next()) {
                        valueConsumer.accept(dataStructure, result.getObject(1, this.returnType));
                    }
                    d = valueMapping.apply(dataStructure);
                    if (result == null) break block14;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return (T)d;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }
}

