/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.java2db.queries;

import com.github.collinalpert.expressions.expression.LambdaExpression;
import com.github.collinalpert.java2db.database.ConnectionConfiguration;
import com.github.collinalpert.java2db.database.DBConnection;
import com.github.collinalpert.java2db.entities.BaseEntity;
import com.github.collinalpert.java2db.mappers.EntityMapper;
import com.github.collinalpert.java2db.mappers.Mappable;
import com.github.collinalpert.java2db.modules.TableModule;
import com.github.collinalpert.java2db.queries.EntityProjectionQuery;
import com.github.collinalpert.java2db.queries.QueryParameters;
import com.github.collinalpert.java2db.queries.Queryable;
import com.github.collinalpert.java2db.queries.builder.EntityQueryBuilder;
import com.github.collinalpert.java2db.queries.builder.IQueryBuilder;
import com.github.collinalpert.java2db.queries.builder.ProjectionQueryBuilder;
import com.github.collinalpert.java2db.queries.builder.QueryBuilder;
import com.github.collinalpert.java2db.queries.ordering.OrderTypes;
import com.github.collinalpert.java2db.utilities.IoC;
import com.github.collinalpert.lambda2sql.functions.SqlFunction;
import com.github.collinalpert.lambda2sql.functions.SqlPredicate;
import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class EntityQuery<E extends BaseEntity>
implements Queryable<E> {
    private static final TableModule tableModule = TableModule.getInstance();
    protected final ConnectionConfiguration connectionConfiguration;
    protected final IQueryBuilder<E> queryBuilder;
    protected final QueryParameters<E> queryParameters;
    private final Class<E> type;
    private final Mappable<E> mapper;

    public EntityQuery(Class<E> type, ConnectionConfiguration connectionConfiguration) {
        this.type = type;
        this.connectionConfiguration = connectionConfiguration;
        this.queryParameters = new QueryParameters();
        this.mapper = IoC.resolveMapper(type, new EntityMapper<E>(type));
        this.queryBuilder = new EntityQueryBuilder<E>(type);
    }

    public EntityQuery<E> where(SqlPredicate<E> predicate) {
        this.queryParameters.appendLogicalAndWhereClause(predicate);
        return this;
    }

    public EntityQuery<E> orWhere(SqlPredicate<E> predicate) {
        this.queryParameters.appendLogicalOrWhereClause(predicate);
        return this;
    }

    public EntityQuery<E> orderBy(SqlFunction<E, ?> function) {
        return this.orderBy(function, OrderTypes.ASCENDING);
    }

    public EntityQuery<E> orderBy(SqlFunction<E, ?> function, OrderTypes orderType) {
        this.queryParameters.setOrderByClause(function, orderType);
        return this;
    }

    public EntityQuery<E> orderBy(SqlFunction<E, ?>[] functions) {
        if (functions == null) {
            return this;
        }
        return this.orderBy(Arrays.asList(functions), OrderTypes.ASCENDING);
    }

    public EntityQuery<E> orderBy(SqlFunction<E, ?>[] functions, OrderTypes orderType) {
        if (functions == null) {
            return this;
        }
        return this.orderBy(Arrays.asList(functions), orderType);
    }

    public EntityQuery<E> orderBy(List<SqlFunction<E, ?>> functions) {
        return this.orderBy(functions, OrderTypes.ASCENDING);
    }

    public EntityQuery<E> orderBy(List<SqlFunction<E, ?>> functions, OrderTypes orderType) {
        this.queryParameters.setOrderByClause(functions, orderType);
        return this;
    }

    public EntityQuery<E> groupBy(SqlFunction<E, ?> groupBy) {
        this.queryParameters.setGroupBy(groupBy);
        return this;
    }

    public EntityQuery<E> groupBy(SqlFunction<E, ?> ... groupBy) {
        this.queryParameters.setGroupBy(Arrays.asList(groupBy));
        return this;
    }

    public EntityQuery<E> thenBy(SqlFunction<E, ?> function) {
        return this.thenBy(function, OrderTypes.ASCENDING);
    }

    public EntityQuery<E> thenBy(SqlFunction<E, ?> function, OrderTypes orderType) {
        this.queryParameters.addOrderByColumns(function, orderType);
        return this;
    }

    public EntityQuery<E> thenBy(SqlFunction<E, ?>[] functions) {
        return this.thenBy(Arrays.asList(functions), OrderTypes.ASCENDING);
    }

    public EntityQuery<E> thenBy(SqlFunction<E, ?>[] functions, OrderTypes orderType) {
        return this.thenBy(Arrays.asList(functions), orderType);
    }

    public EntityQuery<E> thenBy(List<SqlFunction<E, ?>> functions) {
        return this.thenBy(functions, OrderTypes.ASCENDING);
    }

    public EntityQuery<E> thenBy(List<SqlFunction<E, ?>> functions, OrderTypes orderType) {
        this.queryParameters.addOrderByColumns(functions, orderType);
        return this;
    }

    public EntityQuery<E> limit(int limit, int offset) {
        this.queryParameters.setLimit(limit);
        this.queryParameters.setLimitOffset(offset);
        return this;
    }

    public EntityQuery<E> limit(int limit) {
        this.queryParameters.setLimit(limit);
        return this;
    }

    public EntityQuery<E> distinct() {
        this.queryParameters.setDistinct();
        return this;
    }

    public <R> Queryable<R> project(SqlFunction<E, R> projection) {
        Class<?> returnType = LambdaExpression.parse(projection).getBody().getResultType();
        ProjectionQueryBuilder<E, R> queryBuilder = new ProjectionQueryBuilder<E, R>(projection, this.getTableName(), (QueryBuilder)this.queryBuilder);
        return new EntityProjectionQuery(returnType, queryBuilder, this.queryParameters, this.connectionConfiguration);
    }

    @Override
    public Optional<E> first() {
        this.limit(1);
        DBConnection connection = new DBConnection(this.connectionConfiguration);
        try {
            Optional<E> optional = this.mapper.map(connection.execute(this.getQuery()));
            connection.close();
            return optional;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }
    }

    @Override
    public List<E> toList() {
        DBConnection connection = new DBConnection(this.connectionConfiguration);
        try {
            List<E> list = this.mapper.mapToList(connection.execute(this.getQuery()));
            connection.close();
            return list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Collections.emptyList();
            }
        }
    }

    @Override
    public Stream<E> toStream() {
        DBConnection connection = new DBConnection(this.connectionConfiguration);
        try {
            Stream<E> stream = this.mapper.mapToStream(connection.execute(this.getQuery()));
            connection.close();
            return stream;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Stream.empty();
            }
        }
    }

    @Override
    public E[] toArray() {
        DBConnection connection = new DBConnection(this.connectionConfiguration);
        try {
            BaseEntity[] baseEntityArray = (BaseEntity[])this.mapper.mapToArray(connection.execute(this.getQuery()));
            connection.close();
            return baseEntityArray;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return (BaseEntity[])Array.newInstance(this.type, 0);
            }
        }
    }

    @Override
    public <K, V> Map<K, V> toMap(Function<E, K> keyMapping, Function<E, V> valueMapping) {
        DBConnection connection = new DBConnection(this.connectionConfiguration);
        try {
            Map<K, V> map = this.mapper.mapToMap(connection.execute(this.getQuery()), keyMapping, valueMapping);
            connection.close();
            return map;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Collections.emptyMap();
            }
        }
    }

    @Override
    public Set<E> toSet() {
        DBConnection connection = new DBConnection(this.connectionConfiguration);
        try {
            Set<E> set = this.mapper.mapToSet(connection.execute(this.getQuery()));
            connection.close();
            return set;
        }
        catch (Throwable throwable) {
            try {
                try {
                    connection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return Collections.emptySet();
            }
        }
    }

    @Override
    public String getQuery() {
        return this.queryBuilder.build(this.queryParameters);
    }

    protected String getTableName() {
        return tableModule.getTableName(this.type);
    }
}

