/*
 * Decompiled with CFR 0.152.
 */
package com.trigersoft.jaque.expression;

import com.trigersoft.jaque.expression.BinaryExpression;
import com.trigersoft.jaque.expression.ConstantExpression;
import com.trigersoft.jaque.expression.Expression;
import com.trigersoft.jaque.expression.ExpressionClassCracker;
import com.trigersoft.jaque.expression.ExpressionClassVisitor;
import com.trigersoft.jaque.expression.ExpressionStack;
import com.trigersoft.jaque.expression.InvocationExpression;
import com.trigersoft.jaque.expression.SerializedLambda;
import com.trigersoft.jaque.expression.TypeConverter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

final class ExpressionMethodVisitor
extends MethodVisitor {
    private static final Class<?>[] NumericTypeLookup = new Class[]{Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
    private static final Class<?>[] NumericTypeLookup2 = new Class[]{Byte.TYPE, Character.TYPE, Short.TYPE};
    private static final HashMap<Class<?>, Class<?>> _primitives;
    private ExpressionStack _exprStack;
    private final HashMap<Label, List<ExpressionStack>> _branches = new HashMap();
    private final ExpressionClassVisitor _classVisitor;
    private final Class<?>[] _argTypes;
    private Supplier<ConstantExpression> _me;

    ExpressionMethodVisitor(ExpressionClassVisitor classVisitor, Supplier<ConstantExpression> me, Class<?>[] argTypes) {
        super(327680);
        this._classVisitor = classVisitor;
        this._me = me;
        this._argTypes = argTypes;
    }

    private List<ExpressionStack> getBranchUsers(Label label) {
        List<ExpressionStack> bl = this._branches.get(label);
        if (bl == null) {
            bl = new ArrayList<ExpressionStack>();
            this._branches.put(label, bl);
        }
        return bl;
    }

    private void go(Label label) {
        this.getBranchUsers(label).add(this._exprStack);
        this._exprStack = null;
    }

    private void branch(Label label, Expression test) {
        List<ExpressionStack> bl = this.getBranchUsers(label);
        ExpressionStack.BranchExpression br = new ExpressionStack.BranchExpression(this._exprStack, test, label);
        this._exprStack.push(br);
        ExpressionStack left = br.getFalse();
        bl.add(left);
        this._exprStack = br.getTrue();
    }

    private void pushZeroConstantOrReduce() {
        Comparable<Byte> value;
        Expression e = this._exprStack.peek();
        if (e.getExpressionType() == 34) {
            BinaryExpression be = (BinaryExpression)this._exprStack.pop();
            this._exprStack.push(be.getFirst());
            this._exprStack.push(be.getSecond());
            return;
        }
        Class<?> type = this._exprStack.peek().getResultType();
        if (type == Byte.TYPE) {
            value = (byte)0;
        } else if (type == Double.TYPE) {
            value = 0.0;
        } else if (type == Float.TYPE) {
            value = Float.valueOf(0.0f);
        } else if (type == Integer.TYPE) {
            value = 0;
        } else if (type == Long.TYPE) {
            value = 0L;
        } else if (type == Short.TYPE) {
            value = (short)0;
        } else if (type == Boolean.TYPE) {
            value = Boolean.FALSE;
        } else {
            throw new IllegalStateException(type.toString());
        }
        this._exprStack.push(Expression.constant(value, type));
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        return null;
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    @Override
    public void visitCode() {
        this._exprStack = new ExpressionStack();
    }

    @Override
    public void visitEnd() {
        this.visitLabel(null);
        assert (this._exprStack.size() == 1);
        this._classVisitor.setResult(this._exprStack.pop());
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        InvocationExpression e;
        switch (opcode) {
            case 180: {
                try {
                    e = Expression.get(this._exprStack.pop(), name);
                    break;
                }
                catch (NoSuchFieldException nsfe) {
                    throw new RuntimeException(nsfe);
                }
            }
            case 178: {
                try {
                    e = Expression.get(this._classVisitor.getClass(Type.getObjectType(owner)), name);
                    break;
                }
                catch (NoSuchFieldException nsfe) {
                    throw new RuntimeException(nsfe);
                }
            }
            default: {
                throw ExpressionMethodVisitor.notLambda(opcode);
            }
        }
        this._exprStack.push(e);
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        throw ExpressionMethodVisitor.notLambda(type);
    }

    @Override
    public void visitIincInsn(int arg0, int arg1) {
        throw ExpressionMethodVisitor.notLambda(132);
    }

    @Override
    public void visitInsn(int opcode) {
        Expression e;
        switch (opcode) {
            case 190: {
                e = Expression.arrayLength(this._exprStack.pop());
                break;
            }
            case 1: {
                e = Expression.constant(null, Object.class);
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.arrayIndex(second, first);
                break;
            }
            case 14: {
                e = Expression.constant(0.0, Double.TYPE);
                break;
            }
            case 15: {
                e = Expression.constant(1.0, Double.TYPE);
                break;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.subtract(second, first);
                break;
            }
            case 11: {
                e = Expression.constant(Float.valueOf(0.0f), Float.TYPE);
                break;
            }
            case 12: {
                e = Expression.constant(Float.valueOf(1.0f), Float.TYPE);
                break;
            }
            case 13: {
                e = Expression.constant(Float.valueOf(2.0f), Float.TYPE);
                break;
            }
            case 2: {
                e = Expression.constant(-1, Integer.TYPE);
                break;
            }
            case 3: {
                e = Expression.constant(0, Integer.TYPE);
                break;
            }
            case 4: {
                e = Expression.constant(1, Integer.TYPE);
                break;
            }
            case 5: {
                e = Expression.constant(2, Integer.TYPE);
                break;
            }
            case 6: {
                e = Expression.constant(3, Integer.TYPE);
                break;
            }
            case 7: {
                e = Expression.constant(4, Integer.TYPE);
                break;
            }
            case 8: {
                e = Expression.constant(5, Integer.TYPE);
                break;
            }
            case 9: {
                e = Expression.constant(0L, Long.TYPE);
                break;
            }
            case 10: {
                e = Expression.constant(1L, Long.TYPE);
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.add(second, first);
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.subtract(second, first);
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.multiply(second, first);
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.divide(second, first);
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.modulo(second, first);
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                Expression first = this._exprStack.pop();
                e = Expression.negate(first);
                break;
            }
            case 120: 
            case 121: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.leftShift(second, first);
                break;
            }
            case 122: 
            case 123: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.rightShift(second, first);
                break;
            }
            case 124: 
            case 125: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.rightShift(second, first);
                break;
            }
            case 126: 
            case 127: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.bitwiseAnd(second, first);
                break;
            }
            case 128: 
            case 129: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.bitwiseOr(second, first);
                break;
            }
            case 130: 
            case 131: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                e = Expression.exclusiveOr(second, first);
                break;
            }
            case 145: 
            case 146: 
            case 147: {
                Expression first = this._exprStack.pop();
                e = Expression.convert(first, NumericTypeLookup2[opcode - 145]);
                break;
            }
            case 133: 
            case 134: 
            case 135: {
                Expression first = this._exprStack.pop();
                e = Expression.convert(first, NumericTypeLookup[opcode - 133 + 1]);
                break;
            }
            case 136: 
            case 137: 
            case 138: {
                int l2l = opcode > 136 ? 1 : 0;
                Expression first = this._exprStack.pop();
                e = Expression.convert(first, NumericTypeLookup[opcode - 136 + l2l]);
                break;
            }
            case 139: 
            case 140: 
            case 141: {
                int f2f = opcode == 141 ? 1 : 0;
                Expression first = this._exprStack.pop();
                e = Expression.convert(first, NumericTypeLookup[opcode - 139 + f2f]);
                break;
            }
            case 142: 
            case 143: 
            case 144: {
                Expression first = this._exprStack.pop();
                e = Expression.convert(first, NumericTypeLookup[opcode - 142]);
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                this.go(null);
                return;
            }
            case 95: {
                Expression first = this._exprStack.pop();
                Expression second = this._exprStack.pop();
                this._exprStack.push(first);
                this._exprStack.push(second);
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                int base = (opcode - 89) % 3;
                ExpressionMethodVisitor.dup(this._exprStack, ++base, base - 1);
                return;
            }
            case 0: {
                return;
            }
            default: {
                throw ExpressionMethodVisitor.notLambda(opcode);
            }
        }
        this._exprStack.push(e);
    }

    private static void dup(ExpressionStack stack, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        Expression e = (Expression)stack.get(stack.size() - fromIndex--);
        ExpressionMethodVisitor.dup(stack, fromIndex, toIndex);
        stack.push(e);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        switch (opcode) {
            case 16: 
            case 17: {
                this._exprStack.push(Expression.constant(operand, Integer.TYPE));
                break;
            }
            default: {
                throw ExpressionMethodVisitor.notLambda(opcode);
            }
        }
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        int etype;
        switch (opcode) {
            case 167: {
                this.go(label);
                return;
            }
            default: {
                throw ExpressionMethodVisitor.notLambda(opcode);
            }
            case 153: {
                etype = 28;
                this.pushZeroConstantOrReduce();
                break;
            }
            case 154: {
                etype = 10;
                this.pushZeroConstantOrReduce();
                break;
            }
            case 155: {
                etype = 13;
                this.pushZeroConstantOrReduce();
                break;
            }
            case 156: {
                etype = 18;
                this.pushZeroConstantOrReduce();
                break;
            }
            case 157: {
                etype = 19;
                this.pushZeroConstantOrReduce();
                break;
            }
            case 158: {
                etype = 12;
                this.pushZeroConstantOrReduce();
                break;
            }
            case 159: 
            case 165: {
                etype = 28;
                break;
            }
            case 160: 
            case 166: {
                etype = 10;
                break;
            }
            case 161: {
                etype = 13;
                break;
            }
            case 162: {
                etype = 18;
                break;
            }
            case 163: {
                etype = 19;
                break;
            }
            case 164: {
                etype = 12;
                break;
            }
            case 198: 
            case 199: {
                Expression e = Expression.isNull(this._exprStack.pop());
                if (opcode == 198) {
                    e = Expression.logicalNot(e);
                }
                this.branch(label, e);
                return;
            }
        }
        Expression second = this._exprStack.pop();
        Expression first = this._exprStack.pop();
        Expression e = Expression.binary(etype, first, second);
        this.branch(label, e);
    }

    private static ExpressionStack reduce(ExpressionStack first, ExpressionStack second) {
        int sDepth;
        int fDepth = first.getDepth();
        if (fDepth == (sDepth = second.getDepth())) {
            ExpressionStack.BranchExpression secondBB;
            ExpressionStack.BranchExpression firstBB;
            ExpressionStack.BranchExpression secondB;
            ExpressionStack.BranchExpression firstB = first.getParent();
            if (firstB == (secondB = second.getParent())) {
                ExpressionStack parentStack = firstB.getParent();
                parentStack.pop();
                Expression right = firstB.getTrue().pop();
                Expression left = firstB.getFalse().pop();
                assert (right.getResultType() == left.getResultType());
                parentStack.push(Expression.condition(firstB.getTest(), right, left));
                return parentStack;
            }
            if (first.size() == 0 && second.size() == 0 && (firstBB = firstB.getParent().getParent()) == (secondBB = secondB.getParent().getParent())) {
                ExpressionStack l;
                Expression fTest = firstB.getTest();
                if (firstB.getTrue() != first) {
                    fTest = Expression.logicalNot(fTest);
                    l = firstB.getTrue();
                } else {
                    l = firstB.getFalse();
                }
                Expression sTest = secondB.getTest();
                if (secondB.getTrue() != second) {
                    sTest = Expression.logicalNot(sTest);
                    secondB.getTrue().reduce();
                } else {
                    secondB.getFalse().reduce();
                }
                Expression rootTest = firstBB.getTest();
                if (firstBB.getTrue() != firstB.getParent()) {
                    rootTest = Expression.logicalNot(rootTest);
                }
                rootTest = Expression.condition(rootTest, fTest, sTest);
                ExpressionStack parentStack = firstBB.getParent();
                ExpressionStack.BranchExpression be = new ExpressionStack.BranchExpression(parentStack, rootTest, first, l);
                parentStack.pop();
                parentStack.add(be);
                return first;
            }
        } else if (first.size() == 0 && second.size() == 0) {
            ExpressionStack other;
            ExpressionStack younger;
            ExpressionStack older;
            if (fDepth > sDepth) {
                older = second;
                younger = first;
            } else {
                older = first;
                younger = second;
            }
            boolean trueB = older.getParent().getTrue() == older;
            ExpressionStack.BranchExpression youngerBranch = younger.getParent();
            Expression youngTest = youngerBranch.getTest();
            if (younger.getParent().get(trueB) != younger) {
                youngTest = Expression.logicalNot(youngTest);
                other = youngerBranch.get(trueB);
            } else {
                other = youngerBranch.get(!trueB);
            }
            Expression test = Expression.logicalAnd(older.getParent().getTest(), youngTest);
            if (!trueB) {
                test = Expression.logicalNot(test);
            }
            ExpressionStack parentStack = older.getParent().getParent();
            ExpressionStack.BranchExpression be = new ExpressionStack.BranchExpression(parentStack, test, older, other);
            parentStack.pop();
            parentStack.add(be);
            return older;
        }
        return null;
    }

    private static ExpressionStack reduce(List<ExpressionStack> bl) {
        int index = bl.size() - 1;
        ExpressionStack second = bl.remove(index--);
        if (index < 0) {
            return second;
        }
        ExpressionStack first = bl.get(index);
        ExpressionStack reduced = ExpressionMethodVisitor.reduce(first, second);
        if (reduced != null) {
            bl.set(index, reduced);
            return ExpressionMethodVisitor.reduce(bl);
        }
        first = ExpressionMethodVisitor.reduce(bl);
        return ExpressionMethodVisitor.reduce(first, second);
    }

    @Override
    public void visitLabel(Label label) {
        List<ExpressionStack> bl = this._branches.get(label);
        this._branches.remove(label);
        for (int i = bl.size() - 1; i >= 0; --i) {
            ExpressionStack es = bl.get(i);
            if (!es.isReduced()) continue;
            bl.remove(i);
        }
        if (this._exprStack != null) {
            bl.add(this._exprStack);
        }
        this._exprStack = ExpressionMethodVisitor.reduce(bl);
        assert (this._exprStack != null);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        Class<?> type = _primitives.get(cst.getClass());
        if (type == null) {
            type = cst.getClass();
        }
        this._exprStack.push(Expression.constant(cst, type));
    }

    @Override
    public void visitLineNumber(int line, Label start) {
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        throw ExpressionMethodVisitor.notLambda(-1);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        throw ExpressionMethodVisitor.notLambda(171);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        Expression e;
        Type[] argsTypes = Type.getArgumentTypes(desc);
        Expression[] arguments = this.createArguments(argsTypes);
        switch (opcode) {
            case 183: {
                if (name.equals("<init>")) {
                    Class<?>[] parameterTypes = this.getParameterTypes(argsTypes);
                    this.convertArguments(arguments, parameterTypes);
                    try {
                        e = Expression.newInstance(this._exprStack.pop().getResultType(), parameterTypes, arguments);
                    }
                    catch (NoSuchMethodException nsme) {
                        throw new RuntimeException(nsme);
                    }
                    this._exprStack.pop();
                    break;
                }
            }
            case 182: 
            case 185: {
                try {
                    Object value;
                    Class<?> lambdaClass = this._classVisitor.getClass(Type.getObjectType(owner));
                    Expression instance = this._exprStack.pop();
                    if (instance.getExpressionType() == 7 && (value = ((ConstantExpression)instance).getValue()) instanceof SerializedLambda) {
                        Class<?> serializedClass;
                        SerializedLambda serialized = (SerializedLambda)value;
                        ClassLoader lambdaClassLoader = this._classVisitor.getLoader();
                        try {
                            serializedClass = lambdaClassLoader.loadClass(serialized.functionalInterfaceClass.replace('/', '.'));
                        }
                        catch (ClassNotFoundException cnfe) {
                            throw new RuntimeException(cnfe);
                        }
                        if (!lambdaClass.isAssignableFrom(serializedClass)) {
                            throw new ClassCastException(serializedClass + " cannot be cast to " + lambdaClass);
                        }
                        if (!serialized.functionalInterfaceMethodName.equals(name)) {
                            throw new NoSuchMethodException(name);
                        }
                        argsTypes = Type.getArgumentTypes(serialized.implMethodSignature);
                        Class<?>[] parameterTypes = this.getParameterTypes(argsTypes);
                        this.convertArguments(arguments, parameterTypes);
                        e = Expression.invoke(ExpressionClassCracker.get().lambda(serialized, lambdaClassLoader), arguments);
                        break;
                    }
                    Class<?>[] parameterTypes = this.getParameterTypes(argsTypes);
                    this.convertArguments(arguments, parameterTypes);
                    e = Expression.invoke(TypeConverter.convert(instance, lambdaClass), name, parameterTypes, arguments);
                    break;
                }
                catch (NoSuchMethodException nsme) {
                    throw new RuntimeException(nsme);
                }
            }
            case 184: 
            case 186: {
                Class<?>[] parameterTypes = this.getParameterTypes(argsTypes);
                this.convertArguments(arguments, parameterTypes);
                try {
                    e = Expression.invoke(this._classVisitor.getClass(Type.getObjectType(owner)), name, parameterTypes, arguments);
                    break;
                }
                catch (NoSuchMethodException nsme) {
                    throw new RuntimeException(nsme);
                }
            }
            default: {
                throw new IllegalArgumentException("opcode: " + opcode);
            }
        }
        this._exprStack.push(e);
    }

    private void convertArguments(Expression[] arguments, Class<?>[] parameterTypes) {
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = TypeConverter.convert(arguments[i], parameterTypes[i]);
        }
    }

    private Expression[] createArguments(Type[] argsTypes) {
        Expression[] arguments = new Expression[argsTypes.length];
        int i = argsTypes.length;
        while (i > 0) {
            arguments[--i] = this._exprStack.pop();
        }
        return arguments;
    }

    private Class<?>[] getParameterTypes(Type[] argsTypes) {
        Class[] parameterTypes = new Class[argsTypes.length];
        for (int i = 0; i < argsTypes.length; ++i) {
            parameterTypes[i] = this._classVisitor.getClass(argsTypes[i]);
        }
        return parameterTypes;
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        throw ExpressionMethodVisitor.notLambda(197);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int arg0, String arg1, boolean arg2) {
        return null;
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        throw ExpressionMethodVisitor.notLambda(170);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        throw ExpressionMethodVisitor.notLambda(-2);
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        Expression e;
        Class<?> resultType = this._classVisitor.getClass(Type.getObjectType(type));
        switch (opcode) {
            case 187: {
                e = Expression.constant(null, resultType);
                break;
            }
            case 192: {
                if (resultType == Object.class) {
                    return;
                }
                return;
            }
            default: {
                throw ExpressionMethodVisitor.notLambda(opcode);
            }
            case 193: {
                e = Expression.instanceOf(this._exprStack.pop(), resultType);
            }
        }
        this._exprStack.push(e);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        Class<Number> type;
        if (this._me != null) {
            if (var == 0) {
                this._exprStack.push(this._me.get());
                return;
            }
            --var;
        }
        for (int i = 0; i < var; ++i) {
            Class<?> clazz = this._argTypes[i];
            if (clazz != Long.TYPE && clazz != Double.TYPE) continue;
            --var;
        }
        switch (opcode) {
            default: {
                throw ExpressionMethodVisitor.notLambda(opcode);
            }
            case 21: {
                type = Integer.TYPE;
                break;
            }
            case 22: {
                type = Long.TYPE;
                break;
            }
            case 23: {
                type = Float.TYPE;
                break;
            }
            case 24: {
                type = Double.TYPE;
                break;
            }
            case 25: {
                type = this._argTypes[var];
            }
        }
        this._exprStack.push(Expression.parameter(type, var));
    }

    static RuntimeException notLambda(int opcode) {
        String opcodeName = Integer.toString(opcode);
        Field[] ops = Opcodes.class.getFields();
        for (int i = 0; i < ops.length; ++i) {
            Field f = ops[i];
            if (!Modifier.isStatic(f.getModifiers()) || f.getType() != Integer.TYPE) continue;
            try {
                int test = f.getInt(null);
                if (test != opcode) continue;
                opcodeName = f.getName();
            }
            catch (IllegalAccessException e) {}
            break;
        }
        return new IllegalArgumentException("Not a lambda expression. Opcode " + opcodeName + " is illegal.");
    }

    static {
        HashMap<Class, Class<Comparable<Boolean>>> primitives = new HashMap<Class, Class<Comparable<Boolean>>>(8);
        primitives.put(Boolean.class, Boolean.TYPE);
        primitives.put(Byte.class, Byte.TYPE);
        primitives.put(Character.class, Character.TYPE);
        primitives.put(Double.class, Double.TYPE);
        primitives.put(Float.class, Float.TYPE);
        primitives.put(Integer.class, Integer.TYPE);
        primitives.put(Long.class, Long.TYPE);
        primitives.put(Short.class, Short.TYPE);
        _primitives = primitives;
    }
}

