/*
 * Decompiled with CFR 0.152.
 */
package com.trigersoft.jaque.expression;

import com.trigersoft.jaque.expression.Expression;
import com.trigersoft.jaque.expression.ExpressionType;
import com.trigersoft.jaque.expression.ExpressionVisitor;
import com.trigersoft.jaque.expression.UnaryExpression;
import lombok.NonNull;

public final class BinaryExpression
extends UnaryExpression {
    private final Expression operator;
    private final Expression second;

    BinaryExpression(int expressionType, Class<?> resultType, Expression operator, Expression first, @NonNull Expression second) {
        super(expressionType, resultType, first);
        if (second == null) {
            throw new NullPointerException("second is marked @NonNull but is null");
        }
        if (expressionType == 6 && operator == null) {
            throw new IllegalArgumentException(new NullPointerException("operator"));
        }
        this.operator = operator;
        this.second = second;
    }

    @Override
    protected <T> T visit(ExpressionVisitor<T> v) {
        return v.visit(this);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('(');
        if (this.getOperator() != null) {
            b.append(this.getOperator().toString());
            b.append(' ');
            b.append(ExpressionType.toString(this.getExpressionType()));
            b.append(' ');
            b.append(this.getFirst().toString());
            b.append(' ');
            b.append(':');
        } else {
            b.append(this.getFirst().toString());
            b.append(' ');
            b.append(ExpressionType.toString(this.getExpressionType()));
        }
        b.append(' ');
        b.append(this.getSecond().toString());
        b.append(')');
        return b.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinaryExpression)) {
            return false;
        }
        BinaryExpression other = (BinaryExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Expression this$operator = this.getOperator();
        Expression other$operator = other.getOperator();
        if (this$operator == null ? other$operator != null : !((Object)this$operator).equals(other$operator)) {
            return false;
        }
        Expression this$second = this.getSecond();
        Expression other$second = other.getSecond();
        return !(this$second == null ? other$second != null : !((Object)this$second).equals(other$second));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BinaryExpression;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Expression $operator = this.getOperator();
        result = result * 59 + ($operator == null ? 43 : ((Object)$operator).hashCode());
        Expression $second = this.getSecond();
        result = result * 59 + ($second == null ? 43 : ((Object)$second).hashCode());
        return result;
    }

    public Expression getOperator() {
        return this.operator;
    }

    public Expression getSecond() {
        return this.second;
    }
}

