/*
 * Decompiled with CFR 0.152.
 */
package com.github.collinalpert.expressions.expression;

import com.github.collinalpert.expressions.expression.BinaryExpression;
import com.github.collinalpert.expressions.expression.ConstantExpression;
import com.github.collinalpert.expressions.expression.Expression;
import com.github.collinalpert.expressions.expression.InvocationExpression;
import com.github.collinalpert.expressions.expression.LambdaExpression;
import com.github.collinalpert.expressions.expression.MemberExpression;
import com.github.collinalpert.expressions.expression.ParameterExpression;
import com.github.collinalpert.expressions.expression.SimpleExpressionVisitor;
import com.github.collinalpert.expressions.expression.UnaryExpression;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class TypeConverter
extends SimpleExpressionVisitor {
    private static final Map<Class<?>, List<Class<?>>> primitiveWides;
    private static final Map<Class<?>, Class<?>> unboxers;
    private static final Map<Class<?>, Class<?>> boxers;
    private final Class<?> _to;

    private TypeConverter(Class<?> to) {
        this._to = to;
    }

    static Expression convert(Expression e, Class<?> to) {
        Class<?> from = e.getResultType();
        if (from == to) {
            return e;
        }
        return e.accept(new TypeConverter(to));
    }

    public static boolean isAssignable(Class<?> to, Class<?> from) {
        if (to.isPrimitive() ^ from.isPrimitive() && (from = to.isPrimitive() ? unboxers.get(from) : boxers.get(from)) == null) {
            return false;
        }
        if (to.isAssignableFrom(from)) {
            return true;
        }
        List<Class<?>> wides = primitiveWides.get(from);
        if (wides != null) {
            return wides.contains(to);
        }
        return false;
    }

    private Object convert(Class<?> from, Object value) {
        if (from == Integer.TYPE) {
            return this.convert((Integer)value);
        }
        return this.defaultConvert(value);
    }

    private Object convert(int value) {
        if (this._to == Boolean.TYPE) {
            if (value == 0) {
                return Boolean.FALSE;
            }
            if (value == 1) {
                return Boolean.TRUE;
            }
        }
        return this.defaultConvert(value);
    }

    private Expression defaultConvert(Expression e) {
        if (TypeConverter.isAssignable(this._to, e.getResultType())) {
            return e;
        }
        return Expression.convert(e, this._to);
    }

    private Object defaultConvert(Object value) {
        return this._to.cast(value);
    }

    @Override
    public Expression visit(BinaryExpression e) {
        if (TypeConverter.isAssignable(this._to, e.getResultType())) {
            return e;
        }
        Expression first = e.getFirst().accept(this);
        Expression second = e.getSecond().accept(this);
        Expression op = e.getOperator();
        return Expression.condition(op, first, second);
    }

    @Override
    public Expression visit(ConstantExpression e) {
        Class<?> resultType = e.getResultType();
        if (TypeConverter.isAssignable(this._to, resultType)) {
            return e;
        }
        return Expression.constant(this.convert(resultType, e.getValue()), this._to);
    }

    @Override
    public Expression visit(InvocationExpression e) {
        return this.defaultConvert(e);
    }

    @Override
    public Expression visit(LambdaExpression e) {
        return this.defaultConvert(e);
    }

    @Override
    public Expression visit(MemberExpression e) {
        return this.defaultConvert(e);
    }

    @Override
    public Expression visit(ParameterExpression e) {
        if (TypeConverter.isAssignable(e.getResultType(), this._to)) {
            return Expression.parameter(this._to, e.getIndex());
        }
        return this.defaultConvert(e);
    }

    @Override
    public Expression visit(UnaryExpression e) {
        return this.defaultConvert(e);
    }

    static {
        HashMap wides = new HashMap();
        wides.put(Byte.TYPE, Arrays.asList(Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        wides.put(Short.TYPE, Arrays.asList(Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE));
        wides.put(Integer.TYPE, Arrays.asList(Long.TYPE, Float.TYPE, Double.TYPE));
        wides.put(Long.TYPE, Arrays.asList(Float.TYPE, Double.TYPE));
        wides.put(Float.TYPE, Arrays.asList(Double.TYPE));
        primitiveWides = wides;
        HashMap<Class<Object>, Class<Object>> primitives = new HashMap(8);
        primitives.put(Boolean.class, Boolean.TYPE);
        primitives.put(Byte.class, Byte.TYPE);
        primitives.put(Character.class, Character.TYPE);
        primitives.put(Double.class, Double.TYPE);
        primitives.put(Float.class, Float.TYPE);
        primitives.put(Integer.class, Integer.TYPE);
        primitives.put(Long.class, Long.TYPE);
        primitives.put(Short.class, Short.TYPE);
        unboxers = primitives;
        primitives = new HashMap(8);
        primitives.put(Boolean.TYPE, Boolean.class);
        primitives.put(Byte.TYPE, Byte.class);
        primitives.put(Character.TYPE, Character.class);
        primitives.put(Double.TYPE, Double.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Short.TYPE, Short.class);
        boxers = primitives;
    }
}

