/*
 * Decompiled with CFR 0.152.
 */
package merger;

import com.github.javaparser.Position;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.nodeTypes.NodeWithJavadoc;
import com.github.javaparser.javadoc.Javadoc;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class CodeSnipitLocation
implements Comparable<CodeSnipitLocation> {
    private final int start;
    private final int end;

    public CodeSnipitLocation(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getFirstIndex() {
        return this.start - 1;
    }

    public int getLastIndex() {
        return this.end - 1;
    }

    public boolean containsLines() {
        return this.end > this.start;
    }

    public int size() {
        return this.end - this.start;
    }

    public static CodeSnipitLocation of(int start, int end) {
        return new CodeSnipitLocation(start, end);
    }

    public static CodeSnipitLocation of(int startEnd) {
        return CodeSnipitLocation.of(startEnd, startEnd);
    }

    public static CodeSnipitLocation of(Node node) {
        int javaDocLines = CodeSnipitLocation.countJavaDocLines(node);
        CodeSnipitLocation location = CodeSnipitLocation.of(((Position)node.getBegin().get()).line - javaDocLines, ((Position)node.getEnd().get()).line + 1);
        return location;
    }

    public static CodeSnipitLocation before(Node node) {
        return CodeSnipitLocation.of(((Position)node.getBegin().get()).line);
    }

    public static CodeSnipitLocation after(Node node) {
        return CodeSnipitLocation.of(((Position)node.getEnd().get()).line + 1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.end;
        result = 31 * result + this.start;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeSnipitLocation other = (CodeSnipitLocation)obj;
        if (this.end != other.end) {
            return false;
        }
        return this.start == other.start;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("start", this.start).append("end", this.end);
        return builder.toString();
    }

    @Override
    public int compareTo(CodeSnipitLocation that) {
        return this.start - that.start;
    }

    private static int countJavaDocLines(Node node) {
        NodeWithJavadoc javaDocNode;
        Optional javadoc;
        int javaDocLines = 0;
        if (NodeWithJavadoc.class.isAssignableFrom(node.getClass()) && (javadoc = (javaDocNode = (NodeWithJavadoc)node).getJavadoc()).isPresent()) {
            String text = ((Javadoc)javadoc.get()).toText();
            String[] lines = text.split("\r\n|\r|\n");
            javaDocLines = lines.length + 2;
        }
        return javaDocLines;
    }
}

