/*
 * Decompiled with CFR 0.152.
 */
package templateInput.definition;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import templateInput.StringConverter;
import templateInput.definition.TypeDefinition;

public class InitializedTypeDefinition
extends TypeDefinition {
    protected String defaultInit;
    protected String init1;
    protected String init2;
    protected String noInit = "null";
    protected boolean collection;
    protected LinkedHashSet<String> initImports = new LinkedHashSet();

    public InitializedTypeDefinition() {
    }

    public InitializedTypeDefinition(InitializedTypeDefinition var) {
        super(var);
        this.defaultInit = var.defaultInit;
        this.init1 = var.init1;
        this.init2 = var.init2;
        this.noInit = var.noInit;
        this.collection = var.collection;
        this.initImports = var.initImports;
        this.typeImports = var.typeImports;
    }

    protected InitializedTypeDefinition(Builder<?> builder) {
        this.name = ((Builder)builder).name;
        this.type = new StringConverter(((Builder)builder).type);
        this.lineNumber = ((Builder)builder).lineNumber;
        this.column = ((Builder)builder).column;
        this.annotations = ((Builder)builder).annotations;
        this.typeImports = ((Builder)builder).typeImports;
        this.accessModifiers = ((Builder)builder).accessModifiers;
        this.init1 = ((Builder)builder).init1;
        this.init2 = ((Builder)builder).init2;
        this.noInit = ((Builder)builder).noInit;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public void setCollection(boolean collection) {
        this.collection = collection;
    }

    public String getDefaultInit() {
        return this.defaultInit;
    }

    public void setDefaultInit(String defaultInit) {
        this.defaultInit = defaultInit;
    }

    public String getNoInit() {
        return this.noInit;
    }

    public void setNoInit(String noInit) {
        this.noInit = noInit;
    }

    public String getInit1() {
        return this.init1;
    }

    public void setInit1(String init1) {
        this.init1 = init1;
    }

    public String getInit2() {
        return this.init2;
    }

    public void setInit2(String init2) {
        this.init2 = init2;
    }

    public String getGetter() {
        String prefix = Objects.equals(this.type == null ? "null" : this.type.toString(), "boolean") ? "is" : "get";
        return prefix + this.getName().getUpperFirst();
    }

    public String getSetter() {
        return "set" + this.getName().getUpperFirst();
    }

    public String getTypeWithoutParameters() {
        int indexOf = this.type.toString().indexOf("<");
        indexOf = indexOf < 1 ? this.type.toString().length() : indexOf;
        String mainType = this.type.toString().substring(0, indexOf);
        return mainType;
    }

    public LinkedHashSet<String> getInitImports() {
        return this.initImports;
    }

    public void setInitImports(LinkedHashSet<String> imports) {
        this.initImports = imports;
    }

    public void addInitImports(List<String> imports) {
        this.initImports.addAll(imports);
    }

    public void addInitImports(LinkedHashSet<String> imports) {
        this.initImports.addAll(imports);
    }

    public static class Builder<T extends Builder<?>> {
        private StringConverter name;
        private String type;
        private int lineNumber;
        private int column;
        private Set<String> annotations = new HashSet<String>();
        private Set<String> accessModifiers = new HashSet<String>();
        private String init1;
        private String init2;
        private String noInit;
        private LinkedHashSet<String> typeImports = new LinkedHashSet();

        protected Builder() {
        }

        public T copy(InitializedTypeDefinition copy) {
            this.name = copy.name;
            this.type = copy.getType().toString();
            this.lineNumber = copy.getLineNumber();
            this.column = copy.getColumn();
            this.annotations = copy.getAnnotations();
            this.accessModifiers = copy.getAccessModifiers();
            this.init1 = copy.getInit1();
            this.init2 = copy.getInit2();
            this.noInit = copy.getNoInit();
            this.typeImports = copy.getTypeImports();
            return (T)this;
        }

        public T name(String name) {
            this.name = new StringConverter(name);
            return (T)this;
        }

        public T type(String type) {
            this.type = type;
            return (T)this;
        }

        public T lineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return (T)this;
        }

        public T column(int column) {
            this.column = column;
            return (T)this;
        }

        public T annotations(Set<String> annotations) {
            this.annotations = annotations;
            return (T)this;
        }

        public T accessModifiers(Set<String> accessModifiers) {
            this.accessModifiers = accessModifiers;
            return (T)this;
        }

        public T init1(String init1) {
            this.init1 = init1;
            return (T)this;
        }

        public T init2(String init2) {
            this.init2 = init2;
            return (T)this;
        }

        public T noInit(String noInit) {
            this.noInit = noInit;
            return (T)this;
        }

        public T typeImport(String typeImport) {
            this.typeImports.add(typeImport);
            return (T)this;
        }

        public T typeImports(String ... imports) {
            this.typeImports.addAll(Arrays.asList(imports));
            return (T)this;
        }

        public T typeImports(List<String> imports) {
            this.typeImports.addAll(imports);
            return (T)this;
        }
    }
}

