/*
 * Decompiled with CFR 0.152.
 */
package develop.framework.components;

import java.io.Serializable;

public class KeyValuePair<K, V>
implements Serializable {
    private static final long serialVersionUID = -6101907039622686690L;
    protected K key;
    protected V value;

    public KeyValuePair() {
    }

    public KeyValuePair(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public String toString() {
        return this.key + " -> " + this.value;
    }

    public int hashCode() {
        int hash = 7;
        if (this.key != null) {
            hash = hash * 31 + this.key.hashCode();
        }
        if (this.value != null) {
            hash = hash * 31 + this.value.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof KeyValuePair) {
            KeyValuePair otherKeyValuePair = (KeyValuePair)obj;
            if (this.key == null && otherKeyValuePair.getKey() == null || this.key.equals(otherKeyValuePair.getKey())) {
                V otherValue = otherKeyValuePair.getValue();
                if (this.value == null && otherValue != null) {
                    return false;
                }
                return this.value == otherValue || this.value.equals(otherValue);
            }
        }
        return false;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public void setValue(V value) {
        this.value = value;
    }
}

