/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SecretSpec
implements Serializable {
    public static final long serialVersionUID = 1L;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="Data")
    private String data;
    @JsonProperty(value="Labels")
    private Map<String, String> labels;

    public String getName() {
        return this.name;
    }

    public SecretSpec withName(String name) {
        this.name = name;
        return this;
    }

    public String getData() {
        return this.data;
    }

    public SecretSpec withData(String data) {
        this.data = Base64.encodeBase64String((byte[])data.getBytes());
        return this;
    }

    public SecretSpec withLabels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    @CheckForNull
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

