/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.model.EndpointSpec;
import com.github.dockerjava.api.model.NetworkAttachmentConfig;
import com.github.dockerjava.api.model.ServiceModeConfig;
import com.github.dockerjava.api.model.TaskSpec;
import com.github.dockerjava.api.model.UpdateConfig;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ServiceSpec
implements Serializable {
    public static final long serialVersionUID = 1L;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="TaskTemplate")
    private TaskSpec taskTemplate;
    @JsonProperty(value="Mode")
    private ServiceModeConfig mode;
    @JsonProperty(value="UpdateConfig")
    private UpdateConfig updateConfig;
    @JsonProperty(value="Networks")
    private List<NetworkAttachmentConfig> networks;
    @JsonProperty(value="EndpointSpec")
    private EndpointSpec endpointSpec;
    @JsonProperty(value="Labels")
    private Map<String, String> labels;
    @JsonProperty(value="RollbackConfig")
    private UpdateConfig rollbackConfig;

    public String getName() {
        return this.name;
    }

    public ServiceSpec withName(String name) {
        this.name = name;
        return this;
    }

    @CheckForNull
    public TaskSpec getTaskTemplate() {
        return this.taskTemplate;
    }

    public ServiceSpec withTaskTemplate(TaskSpec taskTemplate) {
        this.taskTemplate = taskTemplate;
        return this;
    }

    @CheckForNull
    public ServiceModeConfig getMode() {
        return this.mode;
    }

    public ServiceSpec withMode(ServiceModeConfig mode) {
        this.mode = mode;
        return this;
    }

    @CheckForNull
    public UpdateConfig getUpdateConfig() {
        return this.updateConfig;
    }

    public ServiceSpec withUpdateConfig(UpdateConfig updateConfig) {
        this.updateConfig = updateConfig;
        return this;
    }

    @CheckForNull
    public List<NetworkAttachmentConfig> getNetworks() {
        return this.networks;
    }

    public ServiceSpec withNetworks(List<NetworkAttachmentConfig> networks) {
        this.networks = networks;
        return this;
    }

    @CheckForNull
    public EndpointSpec getEndpointSpec() {
        return this.endpointSpec;
    }

    public ServiceSpec withEndpointSpec(EndpointSpec endpointSpec) {
        this.endpointSpec = endpointSpec;
        return this;
    }

    public ServiceSpec withLabels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public UpdateConfig getRollbackConfig() {
        return this.rollbackConfig;
    }

    public ServiceSpec withRollbackConfig(UpdateConfig rollbackConfig) {
        this.rollbackConfig = rollbackConfig;
        return this;
    }

    @CheckForNull
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

