/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.exception.BadRequestException;
import com.github.dockerjava.api.exception.ConflictException;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotAcceptableException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.github.dockerjava.api.exception.UnauthorizedException;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.core.FramedInputStreamConsumer;
import com.github.dockerjava.core.InvocationBuilder;
import com.github.dockerjava.core.MediaType;
import com.github.dockerjava.transport.DockerHttpClient;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;

class DefaultInvocationBuilder
implements InvocationBuilder {
    private final DockerHttpClient.Request.Builder requestBuilder;
    private final DockerHttpClient dockerHttpClient;
    private final ObjectMapper objectMapper;

    DefaultInvocationBuilder(DockerHttpClient dockerHttpClient, ObjectMapper objectMapper, String path) {
        this.requestBuilder = DockerHttpClient.Request.builder().path(path);
        this.dockerHttpClient = dockerHttpClient;
        this.objectMapper = objectMapper;
    }

    @Override
    public DefaultInvocationBuilder accept(MediaType mediaType) {
        return this.header("accept", mediaType.getMediaType());
    }

    @Override
    public DefaultInvocationBuilder header(String name, String value) {
        this.requestBuilder.putHeader(name, value);
        return this;
    }

    @Override
    public void delete() {
        DockerHttpClient.Request request = this.requestBuilder.method(DockerHttpClient.Request.Method.DELETE).build();
        this.execute(request).close();
    }

    @Override
    public void get(ResultCallback<Frame> resultCallback) {
        DockerHttpClient.Request request = this.requestBuilder.method(DockerHttpClient.Request.Method.GET).build();
        this.executeAndStream(request, resultCallback, new FramedInputStreamConsumer(resultCallback));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T get(TypeReference<T> typeReference) {
        try (InputStream inputStream = this.get();){
            Object object = this.objectMapper.readValue(inputStream, typeReference);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> void get(TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
        DockerHttpClient.Request request = this.requestBuilder.method(DockerHttpClient.Request.Method.GET).build();
        this.executeAndStream(request, resultCallback, new JsonSink<T>(typeReference, resultCallback));
    }

    @Override
    public InputStream post(Object entity) {
        DockerHttpClient.Request request = this.requestBuilder.method(DockerHttpClient.Request.Method.POST).putHeader("content-type", "application/json").body(this.encode(entity)).build();
        final DockerHttpClient.Response response = this.execute(request);
        return new FilterInputStream(response.getBody()){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    response.close();
                }
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T post(Object entity, TypeReference<T> typeReference) {
        try {
            DockerHttpClient.Request request = this.requestBuilder.method(DockerHttpClient.Request.Method.POST).putHeader("content-type", "application/json").body((InputStream)new ByteArrayInputStream(this.objectMapper.writeValueAsBytes(entity))).build();
            try (DockerHttpClient.Response response = this.execute(request);){
                Object object = this.objectMapper.readValue(response.getBody(), typeReference);
                return (T)object;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> void post(Object entity, TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
        try {
            this.post(typeReference, resultCallback, new ByteArrayInputStream(this.objectMapper.writeValueAsBytes(entity)));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T post(TypeReference<T> typeReference, InputStream body) {
        try (InputStream inputStream = this.post(body);){
            Object object = this.objectMapper.readValue(inputStream, typeReference);
            return (T)object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void post(Object entity, InputStream stdin, ResultCallback<Frame> resultCallback) {
        DockerHttpClient.Request request;
        try {
            request = this.requestBuilder.method(DockerHttpClient.Request.Method.POST).putHeader("content-type", "application/json").body((InputStream)new ByteArrayInputStream(this.objectMapper.writeValueAsBytes(entity))).hijackedInput(stdin).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.executeAndStream(request, resultCallback, new FramedInputStreamConsumer(resultCallback));
    }

    @Override
    public <T> void post(TypeReference<T> typeReference, ResultCallback<T> resultCallback, InputStream body) {
        DockerHttpClient.Request request = this.requestBuilder.method(DockerHttpClient.Request.Method.POST).body(body).build();
        this.executeAndStream(request, resultCallback, new JsonSink<T>(typeReference, resultCallback));
    }

    @Override
    public void postStream(InputStream body) {
        DockerHttpClient.Request request = this.requestBuilder.method(DockerHttpClient.Request.Method.POST).body(body).build();
        this.execute(request).close();
    }

    @Override
    public InputStream get() {
        DockerHttpClient.Request request = this.requestBuilder.method(DockerHttpClient.Request.Method.GET).build();
        final DockerHttpClient.Response response = this.execute(request);
        return new FilterInputStream(response.getBody()){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    response.close();
                }
            }
        };
    }

    @Override
    public void put(InputStream body, MediaType mediaType) {
        DockerHttpClient.Request request = this.requestBuilder.method(DockerHttpClient.Request.Method.PUT).putHeader("content-type", mediaType.toString()).body(body).build();
        this.execute(request).close();
    }

    protected DockerHttpClient.Response execute(DockerHttpClient.Request request) {
        try {
            DockerHttpClient.Response response = this.dockerHttpClient.execute(request);
            int statusCode = response.getStatusCode();
            if (statusCode < 200 || statusCode > 299) {
                try {
                    String body = IOUtils.toString((InputStream)response.getBody(), (Charset)StandardCharsets.UTF_8);
                    switch (statusCode) {
                        case 304: {
                            throw new NotModifiedException(body);
                        }
                        case 400: {
                            throw new BadRequestException(body);
                        }
                        case 401: {
                            throw new UnauthorizedException(body);
                        }
                        case 404: {
                            throw new NotFoundException(body);
                        }
                        case 406: {
                            throw new NotAcceptableException(body);
                        }
                        case 409: {
                            throw new ConflictException(body);
                        }
                        case 500: {
                            throw new InternalServerErrorException(body);
                        }
                    }
                    throw new DockerException(body, statusCode);
                }
                catch (Throwable throwable) {
                    response.close();
                    throw throwable;
                }
            }
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> void executeAndStream(DockerHttpClient.Request request, ResultCallback<T> callback, Consumer<DockerHttpClient.Response> sourceConsumer) {
        Thread thread = new Thread(() -> {
            Thread streamingThread = Thread.currentThread();
            try (DockerHttpClient.Response response = this.execute(request);){
                callback.onStart(() -> {
                    streamingThread.interrupt();
                    response.close();
                });
                sourceConsumer.accept(response);
                callback.onComplete();
            }
            catch (Exception e) {
                callback.onError((Throwable)e);
            }
        }, "docker-java-stream-" + Objects.hashCode(request));
        thread.setDaemon(true);
        thread.start();
    }

    private InputStream encode(Object entity) {
        if (entity == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(this.objectMapper.writeValueAsBytes(entity));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private class JsonSink<T>
    implements Consumer<DockerHttpClient.Response> {
        private final TypeReference<T> typeReference;
        private final ResultCallback<T> resultCallback;

        JsonSink(TypeReference<T> typeReference, ResultCallback<T> resultCallback) {
            this.typeReference = typeReference;
            this.resultCallback = resultCallback;
        }

        @Override
        public void accept(DockerHttpClient.Response response) {
            try {
                InputStream body = response.getBody();
                MappingIterator iterator = DefaultInvocationBuilder.this.objectMapper.readerFor(this.typeReference).readValues(body);
                while (iterator.hasNextValue()) {
                    this.resultCallback.onNext(iterator.nextValue());
                }
            }
            catch (Exception e) {
                this.resultCallback.onError((Throwable)e);
            }
        }
    }
}

