/*
 * Decompiled with CFR 0.152.
 */
package com.github.gonella.gopro.api.core;

import java.nio.ByteBuffer;

public class GoProProtocolParser {
    public static int RESULT_IS_BUSY = 2;
    public static int RESULT_IS_OK = 0;
    private static byte ZERO_PADDING;
    private ByteBuffer bb;
    private byte[] mBytes;
    private int mPosition = 0;

    public GoProProtocolParser(byte[] abyte0) {
        if (abyte0 == null) {
            abyte0 = new byte[]{};
        }
        this.mBytes = abyte0;
    }

    private void padBuffer(ByteBuffer bytebuffer, int i) {
        int j = 0;
        while (j < i) {
            bytebuffer.put((byte)0);
            ++j;
        }
        return;
    }

    public boolean extractBoolean() {
        return this.extractByte() == 0;
    }

    public byte extractByte() {
        byte[] abyte0 = this.mBytes;
        int i = this.mPosition;
        this.mPosition = i + 1;
        return abyte0[i];
    }

    public String extractFixedLengthString(int i) {
        byte[] abyte0 = new byte[i];
        System.arraycopy(this.mBytes, this.mPosition, abyte0, 0, i);
        String s = new String(abyte0);
        this.mPosition = i + this.mPosition;
        return s;
    }

    public long extractInteger() {
        this.bb = ByteBuffer.allocate(8);
        this.padBuffer(this.bb, 4);
        this.bb.put(this.extractByte());
        this.bb.put(this.extractByte());
        this.bb.put(this.extractByte());
        this.bb.put(this.extractByte());
        return this.bb.getLong(0);
    }

    public byte extractResultCode() {
        if (this.mBytes == null) {
            return 1;
        }
        return this.extractByte();
    }

    public int extractShort() {
        return (0xFF & this.extractByte()) << 8 | 0xFF & this.extractByte();
    }

    public String extractString() {
        byte byte0 = this.extractByte();
        if (byte0 == 0) {
            return "";
        }
        return this.extractFixedLengthString(byte0);
    }

    public short extractUnsignedByte() {
        this.bb = ByteBuffer.allocate(2);
        this.padBuffer(this.bb, 1);
        this.bb.put(this.extractByte());
        return this.bb.getShort(0);
    }

    public int getPosition() {
        return this.mPosition;
    }
}

