/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql;

import com.github.jasync.sql.db.ConcreteConnectionBase;
import com.github.jasync.sql.db.Configuration;
import com.github.jasync.sql.db.Connection;
import com.github.jasync.sql.db.QueryResult;
import com.github.jasync.sql.db.ResultSet;
import com.github.jasync.sql.db.ResultSetKt;
import com.github.jasync.sql.db.column.ColumnDecoderRegistry;
import com.github.jasync.sql.db.column.ColumnEncoderRegistry;
import com.github.jasync.sql.db.exceptions.ConnectionStillRunningQueryException;
import com.github.jasync.sql.db.exceptions.InsufficientParametersException;
import com.github.jasync.sql.db.general.ColumnData;
import com.github.jasync.sql.db.general.MutableResultSet;
import com.github.jasync.sql.db.interceptor.PreparedStatementParams;
import com.github.jasync.sql.db.pool.TimeoutScheduler;
import com.github.jasync.sql.db.pool.TimeoutSchedulerImpl;
import com.github.jasync.sql.db.postgresql.PostgreSQLConnectionKt;
import com.github.jasync.sql.db.postgresql.PreparedStatementHolder;
import com.github.jasync.sql.db.postgresql.codec.PostgreSQLConnectionDelegate;
import com.github.jasync.sql.db.postgresql.codec.PostgreSQLConnectionHandler;
import com.github.jasync.sql.db.postgresql.column.PostgreSQLColumnDecoderRegistry;
import com.github.jasync.sql.db.postgresql.column.PostgreSQLColumnEncoderRegistry;
import com.github.jasync.sql.db.postgresql.exceptions.GenericDatabaseException;
import com.github.jasync.sql.db.postgresql.exceptions.MissingCredentialInformationException;
import com.github.jasync.sql.db.postgresql.exceptions.PendingCloseStatementException;
import com.github.jasync.sql.db.postgresql.exceptions.QueryMustNotBeNullOrEmptyException;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationChallengeCleartextMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationChallengeMD5;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationChallengeMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationOkMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.CommandCompleteMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.DataRowMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.ErrorMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.NotificationResponse;
import com.github.jasync.sql.db.postgresql.messages.backend.ParameterStatusMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.PostgreSQLColumnData;
import com.github.jasync.sql.db.postgresql.messages.backend.RowDescriptionMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.ClientMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.CredentialMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.PreparedStatementCloseMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.PreparedStatementExecuteMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.PreparedStatementMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.PreparedStatementOpeningMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.QueryMessage;
import com.github.jasync.sql.db.postgresql.util.URLParser;
import com.github.jasync.sql.db.util.CollectionsUtilsKt;
import com.github.jasync.sql.db.util.FP;
import com.github.jasync.sql.db.util.FutureUtilsKt;
import com.github.jasync.sql.db.util.VersionKt;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.KotlinVersion;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00fc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 y2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001yB%\b\u0007\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010<\u001a\u00020+J\u0014\u0010=\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002040\u00110\u0010H\u0002J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00000\u0011H\u0016J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0002J\u000e\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0016J\u0010\u0010D\u001a\u00020+2\u0006\u0010E\u001a\u00020&H\u0002J\b\u0010F\u001a\u00020\rH\u0016J\b\u0010G\u001a\u00020\rH\u0016J\b\u0010H\u001a\u00020\rH\u0016J\u0006\u0010I\u001a\u00020\rJ\b\u0010J\u001a\u00020\rH\u0016J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u0018\u0010K\u001a\u00020+2\u0006\u0010L\u001a\u00020\u00172\u0006\u0010M\u001a\u00020\rH\u0002J\u0010\u0010N\u001a\u00020+2\u0006\u0010O\u001a\u00020PH\u0016J\b\u0010Q\u001a\u00020+H\u0016J\u0010\u0010R\u001a\u00020+2\u0006\u0010O\u001a\u00020SH\u0016J\u0010\u0010T\u001a\u00020+2\u0006\u0010O\u001a\u00020UH\u0016J\u0010\u0010V\u001a\u00020+2\u0006\u0010O\u001a\u00020WH\u0016J\u0010\u0010V\u001a\u00020+2\u0006\u0010X\u001a\u00020&H\u0016J\u0010\u0010Y\u001a\u00020+2\u0006\u0010O\u001a\u00020*H\u0016J\u0010\u0010Z\u001a\u00020+2\u0006\u0010O\u001a\u00020[H\u0016J\b\u0010\\\u001a\u00020+H\u0016J\u0010\u0010]\u001a\u00020+2\u0006\u0010O\u001a\u00020^H\u0016J\b\u0010_\u001a\u00020+H\u0002J\u0012\u0010`\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170aJ\u0014\u0010b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002040\u00110\u0010H\u0002J\u001a\u0010c\u001a\u00020+2\u0012\u0010d\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0)J\u0016\u0010e\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010f\u001a\u00020\u0017H\u0016J\u0016\u0010g\u001a\b\u0012\u0004\u0012\u0002040\u00112\u0006\u0010h\u001a\u00020iH\u0016J\u0016\u0010j\u001a\b\u0012\u0004\u0012\u0002040\u00112\u0006\u0010f\u001a\u00020\u0017H\u0016J\u0016\u0010k\u001a\u00020+2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020\u001d0-H\u0002J\u0010\u0010m\u001a\u00020+2\u0006\u0010n\u001a\u00020&H\u0002J\u0016\u0010o\u001a\u00020+2\f\u0010p\u001a\b\u0012\u0004\u0012\u0002040\u0011H\u0002J\u0010\u0010q\u001a\u00020+2\u0006\u0010r\u001a\u000204H\u0002J\b\u0010s\u001a\u00020\u0017H\u0016J\u001a\u0010t\u001a\u00020+2\u0012\u0010d\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0)J\u000e\u0010u\u001a\u00020+2\u0006\u0010L\u001a\u00020\u0017J\u0010\u0010v\u001a\u00020+2\u0006\u0010f\u001a\u00020\u0017H\u0002J\u0010\u0010w\u001a\u00020+2\u0006\u0010O\u001a\u00020xH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00000\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000Rb\u0010'\u001aV\u0012$\u0012\"\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+ ,*\u0010\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+\u0018\u00010)0) ,**\u0012$\u0012\"\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+ ,*\u0010\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+\u0018\u00010)0)\u0018\u00010-0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00120/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u00103\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002040\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\b\u0012\u0004\u0012\u0002040\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00109\u001a\u00060:j\u0002`;X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006z"}, d2={"Lcom/github/jasync/sql/db/postgresql/PostgreSQLConnection;", "Lcom/github/jasync/sql/db/ConcreteConnectionBase;", "Lcom/github/jasync/sql/db/postgresql/codec/PostgreSQLConnectionDelegate;", "Lcom/github/jasync/sql/db/Connection;", "Lcom/github/jasync/sql/db/pool/TimeoutScheduler;", "configuration", "Lcom/github/jasync/sql/db/Configuration;", "encoderRegistry", "Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;", "decoderRegistry", "Lcom/github/jasync/sql/db/column/ColumnDecoderRegistry;", "(Lcom/github/jasync/sql/db/Configuration;Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;Lcom/github/jasync/sql/db/column/ColumnDecoderRegistry;)V", "authenticated", "", "closeStatementReference", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/Optional;", "Ljava/util/concurrent/CompletableFuture;", "Lcom/github/jasync/sql/db/postgresql/PreparedStatementHolder;", "connectionFuture", "connectionHandler", "Lcom/github/jasync/sql/db/postgresql/codec/PostgreSQLConnectionHandler;", "connectionId", "", "currentCount", "", "currentPreparedStatement", "currentQuery", "Lcom/github/jasync/sql/db/general/MutableResultSet;", "Lcom/github/jasync/sql/db/postgresql/messages/backend/PostgreSQLColumnData;", "getDecoderRegistry", "()Lcom/github/jasync/sql/db/column/ColumnDecoderRegistry;", "getEncoderRegistry", "()Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;", "id", "getId", "()Ljava/lang/String;", "lastException", "", "notifyListeners", "", "Lkotlin/Function1;", "Lcom/github/jasync/sql/db/postgresql/messages/backend/NotificationResponse;", "", "kotlin.jvm.PlatformType", "", "parameterStatus", "", "parsedStatements", "preparedStatementsCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "queryPromiseReference", "Lcom/github/jasync/sql/db/QueryResult;", "queryResult", "recentError", "timeoutSchedulerImpl", "Lcom/github/jasync/sql/db/pool/TimeoutSchedulerImpl;", "version", "Lkotlin/KotlinVersion;", "Lcom/github/jasync/sql/db/util/Version;", "clearNotifyListeners", "clearQueryPromise", "connect", "credential", "Lcom/github/jasync/sql/db/postgresql/messages/frontend/CredentialMessage;", "authenticationMessage", "Lcom/github/jasync/sql/db/postgresql/messages/backend/AuthenticationChallengeMessage;", "disconnect", "failQueryPromise", "t", "hasRecentError", "isConnected", "isQuerying", "isReadyForQuery", "isTimeout", "notReadyForQueryError", "errorMessage", "race", "onAuthenticationResponse", "message", "Lcom/github/jasync/sql/db/postgresql/messages/backend/AuthenticationMessage;", "onCloseComplete", "onCommandComplete", "Lcom/github/jasync/sql/db/postgresql/messages/backend/CommandCompleteMessage;", "onDataRow", "Lcom/github/jasync/sql/db/postgresql/messages/backend/DataRowMessage;", "onError", "Lcom/github/jasync/sql/db/postgresql/messages/backend/ErrorMessage;", "throwable", "onNotificationResponse", "onParameterStatus", "Lcom/github/jasync/sql/db/postgresql/messages/backend/ParameterStatusMessage;", "onReadyForQuery", "onRowDescription", "Lcom/github/jasync/sql/db/postgresql/messages/backend/RowDescriptionMessage;", "onTimeout", "parameterStatuses", "", "queryPromise", "registerNotifyListener", "listener", "releasePreparedStatement", "query", "sendPreparedStatementDirect", "params", "Lcom/github/jasync/sql/db/interceptor/PreparedStatementParams;", "sendQueryDirect", "setColumnDatas", "columnDatas", "setErrorOnFutures", "e", "setQueryPromise", "promise", "succeedQueryPromise", "result", "toString", "unregisterNotifyListener", "validateIfItIsReadyForQuery", "validateQuery", "write", "Lcom/github/jasync/sql/db/postgresql/messages/frontend/ClientMessage;", "Companion", "jasync-postgresql"})
public final class PostgreSQLConnection
extends ConcreteConnectionBase
implements PostgreSQLConnectionDelegate,
Connection,
TimeoutScheduler {
    private final PostgreSQLConnectionHandler connectionHandler;
    private final long currentCount;
    private final String connectionId;
    @NotNull
    private final String id;
    private final AtomicInteger preparedStatementsCounter;
    private final Map<String, String> parameterStatus;
    private final Map<String, PreparedStatementHolder> parsedStatements;
    private boolean authenticated;
    private final CompletableFuture<PostgreSQLConnection> connectionFuture;
    private final TimeoutSchedulerImpl timeoutSchedulerImpl;
    private boolean recentError;
    private final AtomicReference<Optional<CompletableFuture<QueryResult>>> queryPromiseReference;
    private final AtomicReference<Optional<CompletableFuture<PreparedStatementHolder>>> closeStatementReference;
    private Optional<MutableResultSet<PostgreSQLColumnData>> currentQuery;
    private Optional<PreparedStatementHolder> currentPreparedStatement;
    private KotlinVersion version;
    private final List<Function1<NotificationResponse, Unit>> notifyListeners;
    private Optional<QueryResult> queryResult;
    private Throwable lastException;
    @NotNull
    private final ColumnEncoderRegistry encoderRegistry;
    @NotNull
    private final ColumnDecoderRegistry decoderRegistry;
    @NotNull
    private static final AtomicLong Counter;
    @NotNull
    private static final String ServerVersionKey = "server_version";
    public static final Companion Companion;

    @NotNull
    public String getId() {
        return this.id;
    }

    public final boolean isReadyForQuery() {
        return !this.queryPromise().isPresent();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompletableFuture<PostgreSQLConnection> connect() {
        CompletionStage<PostgreSQLConnection> completionStage;
        void $receiver$iv;
        CompletableFuture<PostgreSQLConnectionHandler> completableFuture = this.connectionHandler.connect();
        Executor executor$iv = this.getConfiguration().getExecutionContext();
        boolean $i$f$onFailureAsync = false;
        Intrinsics.checkExpressionValueIsNotNull((Object)$receiver$iv.whenCompleteAsync(new BiConsumer<PostgreSQLConnectionHandler, Throwable>(this){
            final /* synthetic */ PostgreSQLConnection this$0;
            {
                this.this$0 = postgreSQLConnection;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void accept(Object $noName_0, Throwable t) {
                if (t != null) {
                    Throwable e = t;
                    boolean bl = false;
                    FutureUtilsKt.failed((CompletableFuture)PostgreSQLConnection.access$getConnectionFuture$p(this.this$0), (Throwable)e);
                }
            }
        }, executor$iv), (String)"whenCompleteAsync(BiCons\u2026ailureFun(t) }, executor)");
        if (this.getConfiguration().getApplicationName() == null) {
            completionStage = this.connectionFuture;
        } else {
            String string = this.getConfiguration().getApplicationName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String appName = StringsKt.replace$default((String)string, (String)"'", (String)"\\'", (boolean)false, (int)4, null);
            CompletionStage completionStage2 = this.connectionFuture.thenComposeAsync(new Function<PostgreSQLConnection, CompletionStage<PostgreSQLConnection>>(appName){
                final /* synthetic */ String $appName;

                public final CompletableFuture<PostgreSQLConnection> apply(PostgreSQLConnection conn) {
                    return conn.sendQuery("set application_name=E'" + this.$appName + '\'').thenApply(new Function<T, U>(conn){
                        final /* synthetic */ PostgreSQLConnection $conn;

                        public final PostgreSQLConnection apply(QueryResult it) {
                            return this.$conn;
                        }
                        {
                            this.$conn = postgreSQLConnection;
                        }
                    });
                }
                {
                    this.$appName = string;
                }
            }, this.getConfiguration().getExecutionContext());
            completionStage = completionStage2;
            Intrinsics.checkExpressionValueIsNotNull((Object)completionStage2, (String)"this.connectionFuture.th\u2026uration.executionContext)");
        }
        return completionStage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompletableFuture<Connection> disconnect() {
        void $receiver$iv;
        CompletableFuture<PostgreSQLConnectionHandler> completableFuture = this.connectionHandler.disconnect().toCompletableFuture();
        Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"this.connectionHandler.d\u2026t().toCompletableFuture()");
        CompletableFuture<PostgreSQLConnectionHandler> completableFuture2 = completableFuture;
        Executor executor$iv = this.getConfiguration().getExecutionContext();
        boolean $i$f$mapAsync = false;
        CompletionStage completionStage = $receiver$iv.thenApplyAsync(new Function<PostgreSQLConnectionHandler, Connection>(this){
            final /* synthetic */ PostgreSQLConnection this$0;
            {
                this.this$0 = postgreSQLConnection;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Object apply(Object it) {
                PostgreSQLConnectionHandler c = (PostgreSQLConnectionHandler)((Object)it);
                boolean bl = false;
                return this.this$0;
            }
        }, executor$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"thenApplyAsync(Function { f(it) }, executor)");
        return completionStage;
    }

    private final void onTimeout() {
        this.disconnect();
    }

    public boolean isConnected() {
        return this.connectionHandler.isConnected();
    }

    public boolean isTimeout() {
        return this.timeoutSchedulerImpl.isTimeout();
    }

    public boolean isQuerying() {
        return this.queryPromise().isPresent();
    }

    @Nullable
    public Throwable lastException() {
        return this.lastException;
    }

    @NotNull
    public final Map<String, String> parameterStatuses() {
        return MapsKt.toMap(this.parameterStatus);
    }

    @NotNull
    public CompletableFuture<QueryResult> sendQueryDirect(@NotNull String query) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        this.validateQuery(query);
        CompletableFuture<QueryResult> promise = new CompletableFuture<QueryResult>();
        this.setQueryPromise(promise);
        this.write(new QueryMessage(query));
        this.timeoutSchedulerImpl.addTimeout(promise, this.getConfiguration().getQueryTimeout(), this.connectionId);
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompletableFuture<QueryResult> sendPreparedStatementDirect(@NotNull PreparedStatementParams params) {
        PreparedStatementMessage preparedStatementMessage;
        PreparedStatementHolder holder;
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        this.validateQuery(params.getQuery());
        CompletableFuture<QueryResult> promise = new CompletableFuture<QueryResult>();
        this.setQueryPromise(promise);
        Map<String, PreparedStatementHolder> map2 = this.parsedStatements;
        String key$iv = params.getQuery();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            PreparedStatementHolder answer$iv = new PreparedStatementHolder(params.getQuery(), this.preparedStatementsCounter.incrementAndGet());
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if ((holder = (PreparedStatementHolder)object).getParamsCount() != CollectionsUtilsKt.getLength((Collection)params.getValues())) {
            this.clearQueryPromise();
            throw (Throwable)new InsufficientParametersException(holder.getParamsCount(), params.getValues());
        }
        Optional<PreparedStatementHolder> optional = Optional.of(holder);
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.of(holder)");
        this.currentPreparedStatement = optional;
        Optional<MutableResultSet> optional2 = Optional.of(new MutableResultSet(holder.getColumnDatas(), null, 2, null));
        Intrinsics.checkExpressionValueIsNotNull(optional2, (String)"Optional.of(MutableResultSet(holder.columnDatas))");
        this.currentQuery = optional2;
        if (holder.getPrepared()) {
            preparedStatementMessage = new PreparedStatementExecuteMessage(holder.getStatementId(), holder.getRealQuery(), params.getValues(), this.encoderRegistry);
        } else {
            holder.setPrepared(true);
            preparedStatementMessage = new PreparedStatementOpeningMessage(holder.getStatementId(), holder.getRealQuery(), params.getValues(), this.encoderRegistry);
        }
        this.write(preparedStatementMessage);
        this.timeoutSchedulerImpl.addTimeout(promise, this.getConfiguration().getQueryTimeout(), this.connectionId);
        CompletableFuture closedPromise = this.releaseIfNeeded(params.getRelease(), promise, params.getQuery());
        return closedPromise;
    }

    @Override
    public void onError(@NotNull Throwable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
        this.setErrorOnFutures(throwable);
    }

    public boolean hasRecentError() {
        return this.recentError;
    }

    private final void setErrorOnFutures(Throwable e) {
        this.lastException = e;
        this.recentError = true;
        PostgreSQLConnectionKt.access$getLogger$p().error("Error on connection", e);
        if (!FutureUtilsKt.isCompleted(this.connectionFuture)) {
            FutureUtilsKt.failed(this.connectionFuture, (Throwable)e);
            this.disconnect();
        }
        this.currentPreparedStatement.map(new Function<T, U>(this){
            final /* synthetic */ PostgreSQLConnection this$0;

            @Nullable
            public final PreparedStatementHolder apply(PreparedStatementHolder p) {
                return (PreparedStatementHolder)PostgreSQLConnection.access$getParsedStatements$p(this.this$0).remove(p.getQuery());
            }
            {
                this.this$0 = postgreSQLConnection;
            }
        });
        Optional optional = Optional.empty();
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.empty()");
        this.currentPreparedStatement = optional;
        this.failQueryPromise(e);
    }

    @Override
    public void onReadyForQuery() {
        FutureUtilsKt.success(this.connectionFuture, (Object)this);
        this.recentError = false;
        this.queryResult.ifPresent(new Consumer<QueryResult>(this){
            final /* synthetic */ PostgreSQLConnection this$0;

            public final void accept(@NotNull QueryResult it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                PostgreSQLConnection.access$succeedQueryPromise(this.this$0, it);
            }
            {
                this.this$0 = postgreSQLConnection;
            }
        });
    }

    @Override
    public void onError(@NotNull ErrorMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        PostgreSQLConnectionKt.access$getLogger$p().error("Error , message -> {}", (Object)message);
        GenericDatabaseException error = new GenericDatabaseException(message);
        this.setErrorOnFutures((Throwable)((Object)error));
    }

    @Override
    public void onCommandComplete(@NotNull CommandCompleteMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Optional optional = Optional.empty();
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.empty()");
        this.currentPreparedStatement = optional;
        MutableResultSet mutableResultSet = this.currentQuery.orElse(null);
        ResultSet resultSet = mutableResultSet != null ? (ResultSet)mutableResultSet : ResultSetKt.getEMPTY_RESULT_SET();
        Optional<QueryResult> optional2 = Optional.of(new QueryResult((long)message.getRowsAffected(), message.getStatusMessage(), resultSet));
        Intrinsics.checkExpressionValueIsNotNull(optional2, (String)"Optional.of(QueryResult(\u2026tatusMessage, resultSet))");
        this.queryResult = optional2;
    }

    @Override
    public void onParameterStatus(@NotNull ParameterStatusMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.parameterStatus.put(message.getKey(), message.getValue());
        if (Intrinsics.areEqual((Object)ServerVersionKey, (Object)message.getKey())) {
            this.version = VersionKt.parseVersion((String)message.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void onDataRow(@NotNull DataRowMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        int size$iv = message.getValues().length;
        Object[] result$iv = new Object[size$iv];
        int n = 0;
        int n2 = result$iv.length;
        while (n < n2) {
            Object object;
            Object object2;
            void it;
            void i$iv;
            void var7_6 = i$iv;
            void var14_11 = i$iv;
            Object[] objectArray = result$iv;
            boolean bl = false;
            ByteBuf buf = message.getValues()[it];
            if (buf == null) {
                object2 = null;
            } else {
                Object object3;
                try {
                    PostgreSQLColumnData columnType = (PostgreSQLColumnData)this.currentQuery.get().getColumnTypes().get((int)it);
                    object3 = this.decoderRegistry.decode((ColumnData)columnType, buf, this.getConfiguration().getCharset());
                }
                finally {
                    buf.release();
                }
                object2 = object3;
            }
            objectArray[var14_11] = object = object2;
            ++i$iv;
        }
        Object[] items = result$iv;
        this.currentQuery.get().addRow(items);
    }

    @Override
    public void onRowDescription(@NotNull RowDescriptionMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Optional<MutableResultSet> optional = Optional.of(new MutableResultSet(message.getColumnDatas(), null, 2, null));
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.of(MutableResultSet(message.columnDatas))");
        this.currentQuery = optional;
        this.setColumnDatas(message.getColumnDatas());
    }

    private final void setColumnDatas(List<PostgreSQLColumnData> columnDatas) {
        this.currentPreparedStatement.ifPresent(new Consumer<PreparedStatementHolder>(columnDatas){
            final /* synthetic */ List $columnDatas;

            public final void accept(@NotNull PreparedStatementHolder holder) {
                Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
                holder.setColumnDatas(this.$columnDatas);
            }
            {
                this.$columnDatas = list;
            }
        });
    }

    @Override
    public void onAuthenticationResponse(@NotNull AuthenticationMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        AuthenticationMessage authenticationMessage = message;
        if (authenticationMessage instanceof AuthenticationOkMessage) {
            PostgreSQLConnectionKt.access$getLogger$p().debug("Successfully logged in to database");
            this.authenticated = true;
        } else if (authenticationMessage instanceof AuthenticationChallengeCleartextMessage) {
            this.write(this.credential((AuthenticationChallengeMessage)message));
        } else if (authenticationMessage instanceof AuthenticationChallengeMD5) {
            this.write(this.credential((AuthenticationChallengeMessage)message));
        }
    }

    @Override
    public void onNotificationResponse(@NotNull NotificationResponse message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Iterator<Function1<NotificationResponse, Unit>> iterator = this.notifyListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().invoke((Object)message);
        }
    }

    public final void registerNotifyListener(@NotNull Function1<? super NotificationResponse, Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        this.notifyListeners.add(listener);
    }

    public final void unregisterNotifyListener(@NotNull Function1<? super NotificationResponse, Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        this.notifyListeners.remove(listener);
    }

    public final void clearNotifyListeners() {
        this.notifyListeners.clear();
    }

    private final CredentialMessage credential(AuthenticationChallengeMessage authenticationMessage) {
        String string;
        String string2;
        if (this.getConfiguration().getPassword() != null) {
            string2 = this.getConfiguration().getUsername();
            string = this.getConfiguration().getPassword();
            if (string == null) {
                Intrinsics.throwNpe();
            }
        } else {
            throw (Throwable)((Object)new MissingCredentialInformationException(this.getConfiguration().getUsername(), this.getConfiguration().getPassword(), authenticationMessage.getChallengeType()));
        }
        return new CredentialMessage(string2, string, authenticationMessage.getChallengeType(), authenticationMessage.getSalt());
    }

    private final void notReadyForQueryError(String errorMessage, boolean race) {
        PostgreSQLConnectionKt.access$getLogger$p().error(errorMessage);
        throw (Throwable)new ConnectionStillRunningQueryException(this.getId(), race);
    }

    public final void validateIfItIsReadyForQuery(@NotNull String errorMessage) {
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        if (this.queryPromise().isPresent()) {
            this.notReadyForQueryError(errorMessage, false);
        }
    }

    private final void validateQuery(String query) {
        if (!this.isConnected()) {
            throw (Throwable)new IllegalStateException("not connected so can't execute queries. please make sure connect() was called and disconnect() was not called.");
        }
        this.validateIfItIsReadyForQuery("Can't run query because there is one query pending already");
        CharSequence charSequence = query;
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)((Object)new QueryMustNotBeNullOrEmptyException(query));
        }
    }

    private final Optional<CompletableFuture<QueryResult>> queryPromise() {
        Optional<CompletableFuture<QueryResult>> optional = this.queryPromiseReference.get();
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"queryPromiseReference.get()");
        return optional;
    }

    private final void setQueryPromise(CompletableFuture<QueryResult> promise) {
        if (!this.queryPromiseReference.compareAndSet(Optional.empty(), Optional.of(promise))) {
            this.notReadyForQueryError("Can't run query due to a race , another started query", true);
        }
    }

    private final Optional<CompletableFuture<QueryResult>> clearQueryPromise() {
        Optional<CompletableFuture<QueryResult>> optional = this.queryPromiseReference.getAndSet(Optional.empty());
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"this.queryPromiseReferen\u2026tAndSet(Optional.empty())");
        return optional;
    }

    private final void failQueryPromise(Throwable t) {
        this.clearQueryPromise().ifPresent(new Consumer<CompletableFuture<QueryResult>>(t){
            final /* synthetic */ Throwable $t;

            public final void accept(@NotNull CompletableFuture<QueryResult> promise) {
                Intrinsics.checkParameterIsNotNull(promise, (String)"promise");
                PostgreSQLConnectionKt.access$getLogger$p().error("Setting error on future {}", promise);
                FutureUtilsKt.failed(promise, (Throwable)this.$t);
            }
            {
                this.$t = throwable;
            }
        });
    }

    private final void succeedQueryPromise(QueryResult result) {
        Optional optional = Optional.empty();
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.empty()");
        this.queryResult = optional;
        Optional optional2 = Optional.empty();
        Intrinsics.checkExpressionValueIsNotNull(optional2, (String)"Optional.empty()");
        this.currentQuery = optional2;
        this.clearQueryPromise().ifPresent(new Consumer<CompletableFuture<QueryResult>>(result){
            final /* synthetic */ QueryResult $result;

            public final void accept(@NotNull CompletableFuture<QueryResult> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                FutureUtilsKt.success(it, (Object)this.$result);
            }
            {
                this.$result = queryResult;
            }
        });
    }

    private final void write(ClientMessage message) {
        this.connectionHandler.write(message);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "{counter=" + this.currentCount + '}';
    }

    @NotNull
    public CompletableFuture<Boolean> releasePreparedStatement(@NotNull String query) {
        CompletionStage completionStage;
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Optional<CompletableFuture<PreparedStatementHolder>> optional = this.closeStatementReference.get();
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"this.closeStatementReference.get()");
        if (optional.isPresent()) {
            PendingCloseStatementException exception = new PendingCloseStatementException("There is already another close operation pending, your query was [" + query + ']');
            exception.fillInStackTrace();
            return FP.INSTANCE.failed((Throwable)((Object)exception));
        }
        this.validateIfItIsReadyForQuery("You can't close a prepared statement if we're still running a query");
        PreparedStatementHolder statement = this.parsedStatements.get(query);
        if (statement != null) {
            this.write(new PreparedStatementCloseMessage(statement.getStatementId(), false, 2, null));
            Optional<PreparedStatementHolder> optional2 = Optional.of(statement);
            Intrinsics.checkExpressionValueIsNotNull(optional2, (String)"Optional.of(statement)");
            this.currentPreparedStatement = optional2;
            CompletableFuture promise = new CompletableFuture();
            this.closeStatementReference.set(Optional.of(promise));
            CompletableFuture $receiver$iv = promise;
            boolean $i$f$map = false;
            CompletionStage completionStage2 = $receiver$iv.thenApply(new Function<T, U>(this, query){
                final /* synthetic */ PostgreSQLConnection this$0;
                final /* synthetic */ String $query$inlined;
                {
                    this.this$0 = postgreSQLConnection;
                    this.$query$inlined = string;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Object apply(Object it) {
                    PreparedStatementHolder it2 = (PreparedStatementHolder)it;
                    boolean bl = false;
                    PostgreSQLConnection.access$getParsedStatements$p(this.this$0).remove(this.$query$inlined);
                    PostgreSQLConnection.access$getCloseStatementReference$p(this.this$0).set(Optional.empty());
                    return true;
                }
            });
            completionStage = completionStage2;
            Intrinsics.checkExpressionValueIsNotNull((Object)completionStage2, (String)"thenApply { f(it) }");
        } else {
            completionStage = FP.INSTANCE.successful((Object)false);
        }
        return completionStage;
    }

    @Override
    public void onCloseComplete() {
        this.closeStatementReference.get().ifPresent(new Consumer<CompletableFuture<PreparedStatementHolder>>(this){
            final /* synthetic */ PostgreSQLConnection this$0;

            public final void accept(@NotNull CompletableFuture<PreparedStatementHolder> reference) {
                Intrinsics.checkParameterIsNotNull(reference, (String)"reference");
                PostgreSQLConnection.access$getCurrentPreparedStatement$p(this.this$0).ifPresent((Consumer)new Consumer<PreparedStatementHolder>(reference){
                    final /* synthetic */ CompletableFuture $reference;

                    public final void accept(@NotNull PreparedStatementHolder statement) {
                        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
                        CompletableFuture completableFuture = this.$reference;
                        Intrinsics.checkExpressionValueIsNotNull((Object)completableFuture, (String)"reference");
                        FutureUtilsKt.success((CompletableFuture)completableFuture, (Object)statement);
                    }
                    {
                        this.$reference = completableFuture;
                    }
                });
            }
            {
                this.this$0 = postgreSQLConnection;
            }
        });
    }

    @NotNull
    public final ColumnEncoderRegistry getEncoderRegistry() {
        return this.encoderRegistry;
    }

    @NotNull
    public final ColumnDecoderRegistry getDecoderRegistry() {
        return this.decoderRegistry;
    }

    @JvmOverloads
    public PostgreSQLConnection(@NotNull Configuration configuration, @NotNull ColumnEncoderRegistry encoderRegistry, @NotNull ColumnDecoderRegistry decoderRegistry) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)encoderRegistry, (String)"encoderRegistry");
        Intrinsics.checkParameterIsNotNull((Object)decoderRegistry, (String)"decoderRegistry");
        super(configuration);
        this.encoderRegistry = encoderRegistry;
        this.decoderRegistry = decoderRegistry;
        this.connectionHandler = new PostgreSQLConnectionHandler(configuration, this.encoderRegistry, this, configuration.getEventLoopGroup(), configuration.getExecutionContext());
        this.currentCount = Counter.incrementAndGet();
        this.id = this.connectionId = "<postgres-connection-" + this.currentCount + '>';
        this.preparedStatementsCounter = new AtomicInteger();
        PostgreSQLConnection postgreSQLConnection = this;
        boolean bl = false;
        Object object = new LinkedHashMap();
        postgreSQLConnection.parameterStatus = object;
        postgreSQLConnection = this;
        bl = false;
        object = new LinkedHashMap();
        postgreSQLConnection.parsedStatements = object;
        this.connectionFuture = new CompletableFuture();
        this.timeoutSchedulerImpl = new TimeoutSchedulerImpl(configuration.getExecutionContext(), configuration.getEventLoopGroup(), (Function0)new Function0<Unit>(this){

            public final void invoke() {
                PostgreSQLConnection.access$onTimeout((PostgreSQLConnection)this.receiver);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(PostgreSQLConnection.class);
            }

            public final String getName() {
                return "onTimeout";
            }

            public final String getSignature() {
                return "onTimeout()V";
            }
        });
        this.queryPromiseReference = new AtomicReference(Optional.empty());
        this.closeStatementReference = new AtomicReference(Optional.empty());
        Optional optional = Optional.empty();
        Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.empty()");
        this.currentQuery = optional;
        Optional optional2 = Optional.empty();
        Intrinsics.checkExpressionValueIsNotNull(optional2, (String)"Optional.empty()");
        this.currentPreparedStatement = optional2;
        this.version = new KotlinVersion(0, 0, 0);
        postgreSQLConnection = this;
        bl = false;
        object = new ArrayList();
        postgreSQLConnection.notifyListeners = Collections.synchronizedList(object);
        Optional optional3 = Optional.empty();
        Intrinsics.checkExpressionValueIsNotNull(optional3, (String)"Optional.empty()");
        this.queryResult = optional3;
    }

    @JvmOverloads
    public /* synthetic */ PostgreSQLConnection(Configuration configuration, ColumnEncoderRegistry columnEncoderRegistry, ColumnDecoderRegistry columnDecoderRegistry, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            configuration = URLParser.INSTANCE.getDEFAULT();
        }
        if ((n & 2) != 0) {
            columnEncoderRegistry = PostgreSQLColumnEncoderRegistry.Companion.getInstance();
        }
        if ((n & 4) != 0) {
            columnDecoderRegistry = PostgreSQLColumnDecoderRegistry.Companion.getInstance();
        }
        this(configuration, columnEncoderRegistry, columnDecoderRegistry);
    }

    @JvmOverloads
    public PostgreSQLConnection(@NotNull Configuration configuration, @NotNull ColumnEncoderRegistry encoderRegistry) {
        this(configuration, encoderRegistry, null, 4, null);
    }

    @JvmOverloads
    public PostgreSQLConnection(@NotNull Configuration configuration) {
        this(configuration, null, null, 6, null);
    }

    @JvmOverloads
    public PostgreSQLConnection() {
        this(null, null, null, 7, null);
    }

    static {
        Companion = new Companion(null);
        Counter = new AtomicLong();
        ServerVersionKey = ServerVersionKey;
    }

    public static final /* synthetic */ CompletableFuture access$getConnectionFuture$p(PostgreSQLConnection $this) {
        return $this.connectionFuture;
    }

    public static final /* synthetic */ Map access$getParsedStatements$p(PostgreSQLConnection $this) {
        return $this.parsedStatements;
    }

    public static final /* synthetic */ void access$succeedQueryPromise(PostgreSQLConnection $this, QueryResult result) {
        $this.succeedQueryPromise(result);
    }

    public static final /* synthetic */ AtomicReference access$getCloseStatementReference$p(PostgreSQLConnection $this) {
        return $this.closeStatementReference;
    }

    public static final /* synthetic */ Optional access$getCurrentPreparedStatement$p(PostgreSQLConnection $this) {
        return $this.currentPreparedStatement;
    }

    public static final /* synthetic */ void access$setCurrentPreparedStatement$p(PostgreSQLConnection $this, Optional optional) {
        $this.currentPreparedStatement = optional;
    }

    public static final /* synthetic */ void access$onTimeout(PostgreSQLConnection $this) {
        $this.onTimeout();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/github/jasync/sql/db/postgresql/PostgreSQLConnection$Companion;", "", "()V", "Counter", "Ljava/util/concurrent/atomic/AtomicLong;", "getCounter", "()Ljava/util/concurrent/atomic/AtomicLong;", "ServerVersionKey", "", "getServerVersionKey", "()Ljava/lang/String;", "jasync-postgresql"})
    public static final class Companion {
        @NotNull
        public final AtomicLong getCounter() {
            return Counter;
        }

        @NotNull
        public final String getServerVersionKey() {
            return ServerVersionKey;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

