/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.codec;

import com.github.jasync.sql.db.Configuration;
import com.github.jasync.sql.db.SSLConfiguration;
import com.github.jasync.sql.db.column.ColumnEncoderRegistry;
import com.github.jasync.sql.db.postgresql.codec.MessageDecoder;
import com.github.jasync.sql.db.postgresql.codec.MessageEncoder;
import com.github.jasync.sql.db.postgresql.codec.PostgreSQLConnectionDelegate;
import com.github.jasync.sql.db.postgresql.codec.PostgreSQLConnectionHandler$disconnect$;
import com.github.jasync.sql.db.postgresql.codec.PostgreSQLConnectionHandlerKt;
import com.github.jasync.sql.db.postgresql.exceptions.QueryMustNotBeNullOrEmptyException;
import com.github.jasync.sql.db.postgresql.messages.backend.AuthenticationMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.CommandCompleteMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.DataRowMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.ErrorMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.NotificationResponse;
import com.github.jasync.sql.db.postgresql.messages.backend.ParameterStatusMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.ProcessData;
import com.github.jasync.sql.db.postgresql.messages.backend.RowDescriptionMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.SSLResponseMessage;
import com.github.jasync.sql.db.postgresql.messages.backend.ServerMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.ClientMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.CloseMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.SSLRequestMessage;
import com.github.jasync.sql.db.postgresql.messages.frontend.StartupMessage;
import com.github.jasync.sql.db.util.ChannelFutureTransformerKt;
import com.github.jasync.sql.db.util.ExecutorServiceUtils;
import com.github.jasync.sql.db.util.Failure;
import com.github.jasync.sql.db.util.FutureUtilsKt;
import com.github.jasync.sql.db.util.NettyUtils;
import com.github.jasync.sql.db.util.Success;
import com.github.jasync.sql.db.util.Try;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.CodecException;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0017H\u0016J\u0010\u0010)\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0017H\u0016J\u001a\u0010*\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u00172\u0006\u0010+\u001a\u00020\u0002H\u0014J\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015J\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015J\u0018\u0010.\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00172\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0017H\u0016J\u0006\u00102\u001a\u000203J\u000e\u00104\u001a\u00020'2\u0006\u0010+\u001a\u000205R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010!\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020$\u0012\f\u0012\n %*\u0004\u0018\u00010$0$0#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/github/jasync/sql/db/postgresql/codec/PostgreSQLConnectionHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "", "configuration", "Lcom/github/jasync/sql/db/Configuration;", "encoderRegistry", "Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;", "connectionDelegate", "Lcom/github/jasync/sql/db/postgresql/codec/PostgreSQLConnectionDelegate;", "group", "Lio/netty/channel/EventLoopGroup;", "executionContext", "Ljava/util/concurrent/Executor;", "(Lcom/github/jasync/sql/db/Configuration;Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;Lcom/github/jasync/sql/db/postgresql/codec/PostgreSQLConnectionDelegate;Lio/netty/channel/EventLoopGroup;Ljava/util/concurrent/Executor;)V", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "getConfiguration", "()Lcom/github/jasync/sql/db/Configuration;", "getConnectionDelegate", "()Lcom/github/jasync/sql/db/postgresql/codec/PostgreSQLConnectionDelegate;", "connectionFuture", "Ljava/util/concurrent/CompletableFuture;", "currentContext", "Lio/netty/channel/ChannelHandlerContext;", "disconnectionPromise", "getEncoderRegistry", "()Lcom/github/jasync/sql/db/column/ColumnEncoderRegistry;", "getExecutionContext", "()Ljava/util/concurrent/Executor;", "getGroup", "()Lio/netty/channel/EventLoopGroup;", "processData", "Lcom/github/jasync/sql/db/postgresql/messages/backend/ProcessData;", "properties", "", "Lkotlin/Pair;", "", "kotlin.jvm.PlatformType", "channelActive", "", "ctx", "channelInactive", "channelRead0", "message", "connect", "disconnect", "exceptionCaught", "cause", "", "handlerAdded", "isConnected", "", "write", "Lcom/github/jasync/sql/db/postgresql/messages/frontend/ClientMessage;", "jasync-postgresql"})
public final class PostgreSQLConnectionHandler
extends SimpleChannelInboundHandler<Object> {
    private final List<Pair<String, String>> properties;
    private final Bootstrap bootstrap;
    private final CompletableFuture<PostgreSQLConnectionHandler> connectionFuture;
    private final CompletableFuture<PostgreSQLConnectionHandler> disconnectionPromise;
    private ProcessData processData;
    private ChannelHandlerContext currentContext;
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final ColumnEncoderRegistry encoderRegistry;
    @NotNull
    private final PostgreSQLConnectionDelegate connectionDelegate;
    @NotNull
    private final EventLoopGroup group;
    @NotNull
    private final Executor executionContext;

    @NotNull
    public final CompletableFuture<PostgreSQLConnectionHandler> connect() {
        this.bootstrap.group(this.group);
        this.bootstrap.channel(NettyUtils.INSTANCE.getSocketChannelClass(this.group));
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(this){
            final /* synthetic */ PostgreSQLConnectionHandler this$0;

            protected void initChannel(@NotNull Channel ch) {
                Intrinsics.checkParameterIsNotNull((Object)ch, (String)"ch");
                ch.pipeline().addLast(new ChannelHandler[]{(ChannelHandler)new MessageDecoder(this.this$0.getConfiguration().getSsl().getMode() != SSLConfiguration.Mode.Disable, this.this$0.getConfiguration().getCharset(), this.this$0.getConfiguration().getMaximumMessageSize()), (ChannelHandler)new MessageEncoder(this.this$0.getConfiguration().getCharset(), this.this$0.getEncoderRegistry()), (ChannelHandler)this.this$0});
            }
            {
                this.this$0 = $outer;
            }
        });
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)this.configuration.getAllocator());
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.configuration.getConnectionTimeout());
        ChannelFuture channelFuture = this.bootstrap.connect((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
        Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"this.bootstrap.connect(I\u2026ost, configuration.port))");
        ChannelFutureTransformerKt.onFailure((ChannelFuture)channelFuture, (Executor)this.executionContext, (Function1)((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ PostgreSQLConnectionHandler this$0;

            public final void invoke(@NotNull Throwable e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                FutureUtilsKt.failed((CompletableFuture)PostgreSQLConnectionHandler.access$getConnectionFuture$p(this.this$0), (Throwable)e);
            }
            {
                this.this$0 = postgreSQLConnectionHandler;
                super(1);
            }
        }));
        return this.connectionFuture;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompletableFuture<PostgreSQLConnectionHandler> disconnect() {
        if (this.isConnected()) {
            void $receiver$iv;
            ChannelHandlerContext channelHandlerContext = this.currentContext;
            if (channelHandlerContext == null) {
                Intrinsics.throwNpe();
            }
            ChannelFuture channelFuture = channelHandlerContext.channel().writeAndFlush((Object)CloseMessage.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"this.currentContext!!.ch\u2026iteAndFlush(CloseMessage)");
            CompletableFuture completableFuture = ChannelFutureTransformerKt.toCompletableFuture((ChannelFuture)channelFuture);
            Executor executor$iv = this.executionContext;
            boolean $i$f$onCompleteAsync = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)$receiver$iv.whenCompleteAsync(new BiConsumer<ChannelFuture, Throwable>(this){
                final /* synthetic */ PostgreSQLConnectionHandler this$0;
                {
                    this.this$0 = postgreSQLConnectionHandler;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public final void accept(Object a, Throwable t) {
                    Try ty1 = t != null ? Try.Companion.raise(t) : Try.Companion.just(a);
                    boolean bl = false;
                    Try try_ = ty1;
                    if (try_ instanceof Success) {
                        void $receiver$iv;
                        ChannelFuture channelFuture = ((ChannelFuture)ty1.get()).channel().close();
                        Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"ty1.get().channel().close()");
                        CompletableFuture completableFuture = ChannelFutureTransformerKt.toCompletableFuture((ChannelFuture)channelFuture);
                        Executor executor$iv = this.this$0.getExecutionContext();
                        boolean $i$f$onCompleteAsync = false;
                        Intrinsics.checkExpressionValueIsNotNull((Object)$receiver$iv.whenCompleteAsync(new BiConsumer<ChannelFuture, Throwable>(this){
                            final /* synthetic */ disconnect$$inlined$onCompleteAsync$1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            public final void accept(Object a, Throwable t) {
                                Try ty2 = t != null ? Try.Companion.raise(t) : Try.Companion.just(a);
                                boolean bl = false;
                                Try try_ = ty2;
                                if (try_ instanceof Success) {
                                    FutureUtilsKt.success((CompletableFuture)PostgreSQLConnectionHandler.access$getDisconnectionPromise$p(this.this$0.this$0), (Object)((Object)this.this$0.this$0));
                                } else if (try_ instanceof Failure) {
                                    FutureUtilsKt.failed((CompletableFuture)PostgreSQLConnectionHandler.access$getDisconnectionPromise$p(this.this$0.this$0), (Throwable)((Failure)ty2).getException());
                                }
                            }
                        }, executor$iv), (String)"whenCompleteAsync(BiCons\u2026Try.just(a)) }, executor)");
                    } else if (try_ instanceof Failure) {
                        FutureUtilsKt.failed((CompletableFuture)PostgreSQLConnectionHandler.access$getDisconnectionPromise$p(this.this$0), (Throwable)((Failure)ty1).getException());
                    }
                }
            }, executor$iv), (String)"whenCompleteAsync(BiCons\u2026Try.just(a)) }, executor)");
        }
        return this.disconnectionPromise;
    }

    public final boolean isConnected() {
        ChannelHandlerContext channelHandlerContext = this.currentContext;
        return channelHandlerContext != null && (channelHandlerContext = channelHandlerContext.channel()) != null ? channelHandlerContext.isActive() : false;
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        if (this.configuration.getSsl().getMode() == SSLConfiguration.Mode.Disable) {
            ctx.writeAndFlush((Object)new StartupMessage(this.properties));
        } else {
            ctx.writeAndFlush((Object)SSLRequestMessage.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(@Nullable ChannelHandlerContext ctx, @NotNull Object message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        PostgreSQLConnectionHandlerKt.access$getLogger$p().trace((Function0)new Function0<String>(message){
            final /* synthetic */ Object $message;

            @NotNull
            public final String invoke() {
                return "got message " + this.$message;
            }
            {
                this.$message = object;
                super(0);
            }
        });
        Object object = message;
        if (Intrinsics.areEqual((Object)object, (Object)new SSLResponseMessage(true))) {
            SslContextBuilder ctxBuilder = SslContextBuilder.forClient();
            if (this.configuration.getSsl().getMode().compareTo((Enum)SSLConfiguration.Mode.VerifyCA) >= 0) {
                if (this.configuration.getSsl().getRootCert() == null) {
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                    FileInputStream cacerts = new FileInputStream(System.getProperty("java.home") + "/lib/security/cacerts");
                    Closeable closeable = cacerts;
                    boolean bl = false;
                    Throwable throwable = null;
                    try {
                        FileInputStream it = (FileInputStream)closeable;
                        boolean bl2 = false;
                        String string = "changeit";
                        InputStream inputStream = it;
                        KeyStore keyStore = ks;
                        boolean bl3 = false;
                        char[] cArray = string.toCharArray();
                        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
                        char[] cArray2 = cArray;
                        keyStore.load(inputStream, cArray2);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    tmf.init(ks);
                    ctxBuilder.trustManager(tmf);
                } else {
                    ctxBuilder.trustManager(this.configuration.getSsl().getRootCert());
                }
            } else {
                ctxBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            }
            SslContext sslContext = ctxBuilder.build();
            ChannelHandlerContext channelHandlerContext = ctx;
            if (channelHandlerContext == null) {
                Intrinsics.throwNpe();
            }
            SSLEngine sslEngine = sslContext.newEngine(channelHandlerContext.alloc(), this.configuration.getHost(), this.configuration.getPort());
            if (this.configuration.getSsl().getMode().compareTo((Enum)SSLConfiguration.Mode.VerifyFull) >= 0) {
                SSLParameters sslParams;
                SSLEngine sSLEngine = sslEngine;
                Intrinsics.checkExpressionValueIsNotNull((Object)sSLEngine, (String)"sslEngine");
                SSLParameters sSLParameters = sslParams = sSLEngine.getSSLParameters();
                Intrinsics.checkExpressionValueIsNotNull((Object)sSLParameters, (String)"sslParams");
                sSLParameters.setEndpointIdentificationAlgorithm("HTTPS");
                sslEngine.setSSLParameters(sslParams);
            }
            SslHandler handler = new SslHandler(sslEngine);
            ctx.pipeline().addFirst(new ChannelHandler[]{(ChannelHandler)handler});
            handler.handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Channel>>(this, ctx){
                final /* synthetic */ PostgreSQLConnectionHandler this$0;
                final /* synthetic */ ChannelHandlerContext $ctx;

                public final void operationComplete(Future<? super Channel> future) {
                    Future<? super Channel> future2 = future;
                    Intrinsics.checkExpressionValueIsNotNull(future2, (String)"future");
                    if (future2.isSuccess()) {
                        this.$ctx.writeAndFlush((Object)new StartupMessage(PostgreSQLConnectionHandler.access$getProperties$p(this.this$0)));
                    } else {
                        PostgreSQLConnectionDelegate postgreSQLConnectionDelegate = this.this$0.getConnectionDelegate();
                        Throwable throwable = future.cause();
                        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"future.cause()");
                        postgreSQLConnectionDelegate.onError(throwable);
                    }
                }
                {
                    this.this$0 = postgreSQLConnectionHandler;
                    this.$ctx = channelHandlerContext;
                }
            });
        } else if (Intrinsics.areEqual((Object)object, (Object)new SSLResponseMessage(false))) {
            if (this.configuration.getSsl().getMode().compareTo((Enum)SSLConfiguration.Mode.Require) < 0) {
                ChannelHandlerContext channelHandlerContext = ctx;
                if (channelHandlerContext == null) {
                    Intrinsics.throwNpe();
                }
                channelHandlerContext.writeAndFlush((Object)new StartupMessage(this.properties));
            } else {
                this.connectionDelegate.onError(new IllegalArgumentException("SSL is not supported on server"));
            }
        } else if (object instanceof ServerMessage) {
            switch (((ServerMessage)message).getKind()) {
                case 75: {
                    this.processData = (ProcessData)message;
                    break;
                }
                case 50: {
                    break;
                }
                case 82: {
                    PostgreSQLConnectionHandlerKt.access$getLogger$p().debug("Authentication response received " + message);
                    this.connectionDelegate.onAuthenticationResponse((AuthenticationMessage)message);
                    break;
                }
                case 67: {
                    this.connectionDelegate.onCommandComplete((CommandCompleteMessage)message);
                    break;
                }
                case 51: {
                    this.connectionDelegate.onCloseComplete();
                    break;
                }
                case 68: {
                    this.connectionDelegate.onDataRow((DataRowMessage)message);
                    break;
                }
                case 69: {
                    this.connectionDelegate.onError((ErrorMessage)message);
                    break;
                }
                case 73: {
                    QueryMustNotBeNullOrEmptyException exception = new QueryMustNotBeNullOrEmptyException("");
                    this.connectionDelegate.onError((Throwable)((Object)exception));
                    break;
                }
                case 110: {
                    break;
                }
                case 78: {
                    PostgreSQLConnectionHandlerKt.access$getLogger$p().info("Received notice " + message);
                    break;
                }
                case 65: {
                    this.connectionDelegate.onNotificationResponse((NotificationResponse)message);
                    break;
                }
                case 83: {
                    this.connectionDelegate.onParameterStatus((ParameterStatusMessage)message);
                    break;
                }
                case 49: {
                    break;
                }
                case 90: {
                    this.connectionDelegate.onReadyForQuery();
                    break;
                }
                case 84: {
                    this.connectionDelegate.onRowDescription((RowDescriptionMessage)message);
                    break;
                }
                default: {
                    String string;
                    String string2 = "Handler not implemented for message %s";
                    Object[] objectArray = new Object[]{((ServerMessage)message).getKind()};
                    boolean bl = false;
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(this, *args)");
                    String string4 = string = string3;
                    IllegalStateException exception = new IllegalStateException(string4);
                    this.connectionDelegate.onError(exception);
                    break;
                }
            }
        } else {
            String string;
            PostgreSQLConnectionHandlerKt.access$getLogger$p().error("Unknown message type - " + message);
            String string5 = "Unknown message type - %s";
            Object[] objectArray = new Object[]{message};
            boolean bl = false;
            String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(this, *args)");
            String string7 = string = string6;
            IllegalArgumentException exception = new IllegalArgumentException(string7);
            this.connectionDelegate.onError(exception);
        }
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        Throwable throwable = cause;
        if (throwable instanceof CodecException) {
            Throwable throwable2 = cause.getCause();
            if (throwable2 == null) {
                Intrinsics.throwNpe();
            }
            this.connectionDelegate.onError(throwable2);
        } else {
            this.connectionDelegate.onError(cause);
        }
    }

    public void channelInactive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        PostgreSQLConnectionHandlerKt.access$getLogger$p().info("Connection disconnected - {}", (Object)ctx.channel().remoteAddress());
    }

    public void handlerAdded(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        this.currentContext = ctx;
    }

    public final void write(@NotNull ClientMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        ChannelHandlerContext channelHandlerContext = this.currentContext;
        if (channelHandlerContext == null) {
            Intrinsics.throwNpe();
        }
        ChannelFuture channelFuture = channelHandlerContext.writeAndFlush((Object)message);
        Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"this.currentContext!!.writeAndFlush(message)");
        ChannelFutureTransformerKt.onFailure((ChannelFuture)channelFuture, (Executor)this.executionContext, (Function1)((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ PostgreSQLConnectionHandler this$0;

            public final void invoke(@NotNull Throwable e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.this$0.getConnectionDelegate().onError(e);
            }
            {
                this.this$0 = postgreSQLConnectionHandler;
                super(1);
            }
        }));
    }

    @NotNull
    public final Configuration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final ColumnEncoderRegistry getEncoderRegistry() {
        return this.encoderRegistry;
    }

    @NotNull
    public final PostgreSQLConnectionDelegate getConnectionDelegate() {
        return this.connectionDelegate;
    }

    @NotNull
    public final EventLoopGroup getGroup() {
        return this.group;
    }

    @NotNull
    public final Executor getExecutionContext() {
        return this.executionContext;
    }

    public PostgreSQLConnectionHandler(@NotNull Configuration configuration, @NotNull ColumnEncoderRegistry encoderRegistry, @NotNull PostgreSQLConnectionDelegate connectionDelegate, @NotNull EventLoopGroup group, @NotNull Executor executionContext) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)encoderRegistry, (String)"encoderRegistry");
        Intrinsics.checkParameterIsNotNull((Object)connectionDelegate, (String)"connectionDelegate");
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)executionContext, (String)"executionContext");
        this.configuration = configuration;
        this.encoderRegistry = encoderRegistry;
        this.connectionDelegate = connectionDelegate;
        this.group = group;
        this.executionContext = executionContext;
        this.properties = CollectionsKt.listOf((Object[])new Pair[]{TuplesKt.to((Object)"user", (Object)this.configuration.getUsername()), TuplesKt.to((Object)"database", (Object)this.configuration.getDatabase()), TuplesKt.to((Object)"client_encoding", (Object)this.configuration.getCharset().name()), TuplesKt.to((Object)"DateStyle", (Object)"ISO"), TuplesKt.to((Object)"extra_float_digits", (Object)"2")});
        this.bootstrap = new Bootstrap();
        this.connectionFuture = new CompletableFuture();
        this.disconnectionPromise = new CompletableFuture();
    }

    public /* synthetic */ PostgreSQLConnectionHandler(Configuration configuration, ColumnEncoderRegistry columnEncoderRegistry, PostgreSQLConnectionDelegate postgreSQLConnectionDelegate, EventLoopGroup eventLoopGroup, Executor executor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            executor = ExecutorServiceUtils.INSTANCE.getCommonPool();
        }
        this(configuration, columnEncoderRegistry, postgreSQLConnectionDelegate, eventLoopGroup, executor);
    }

    public static final /* synthetic */ CompletableFuture access$getConnectionFuture$p(PostgreSQLConnectionHandler $this) {
        return $this.connectionFuture;
    }

    public static final /* synthetic */ CompletableFuture access$getDisconnectionPromise$p(PostgreSQLConnectionHandler $this) {
        return $this.disconnectionPromise;
    }

    public static final /* synthetic */ List access$getProperties$p(PostgreSQLConnectionHandler $this) {
        return $this.properties;
    }
}

