/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.column;

import com.github.jasync.sql.db.column.ColumnEncoderDecoder;
import com.github.jasync.sql.db.exceptions.DateEncoderNotAvailableException;
import com.github.jasync.sql.db.general.ColumnData;
import com.github.jasync.sql.db.postgresql.messages.backend.PostgreSQLColumnData;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0006\u0010\u0014\u001a\u00020\u0004J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/github/jasync/sql/db/postgresql/column/PostgreSQLTimestampEncoderDecoder;", "Lcom/github/jasync/sql/db/column/ColumnEncoderDecoder;", "()V", "internalFormatterWithoutSeconds", "Lorg/joda/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "internalFormatters", "", "optionalTimeZone", "Lorg/joda/time/format/DateTimeParser;", "decode", "", "kind", "Lcom/github/jasync/sql/db/general/ColumnData;", "value", "Lio/netty/buffer/ByteBuf;", "charset", "Ljava/nio/charset/Charset;", "", "encode", "formatter", "selectFormatter", "text", "supportsStringDecoding", "", "jasync-postgresql"})
public final class PostgreSQLTimestampEncoderDecoder
implements ColumnEncoderDecoder {
    private static final DateTimeParser optionalTimeZone;
    private static final List<DateTimeFormatter> internalFormatters;
    private static final DateTimeFormatter internalFormatterWithoutSeconds;
    public static final PostgreSQLTimestampEncoderDecoder INSTANCE;

    @NotNull
    public final DateTimeFormatter formatter() {
        return internalFormatters.get(5);
    }

    @NotNull
    public Object decode(@NotNull ColumnData kind, @NotNull ByteBuf value, @NotNull Charset charset) {
        LocalDateTime localDateTime;
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        byte[] bytes = new byte[value.readableBytes()];
        value.readBytes(bytes);
        String text = new String(bytes, charset);
        PostgreSQLColumnData columnType = (PostgreSQLColumnData)kind;
        switch (columnType.getDataType()) {
            case 1114: 
            case 1115: {
                localDateTime = this.selectFormatter(text).parseLocalDateTime(text);
                break;
            }
            case 1185: {
                localDateTime = this.selectFormatter(text).parseDateTime(text);
                break;
            }
            case 1184: {
                if (columnType.getDataTypeModifier() > 0) {
                    localDateTime = internalFormatters.get(columnType.getDataTypeModifier() - 1).parseDateTime(text);
                    break;
                }
                localDateTime = this.selectFormatter(text).parseDateTime(text);
                break;
            }
            default: {
                String reason$iv = "should treat " + columnType.getDataType();
                boolean $i$f$XXX = false;
                throw (Throwable)new UnsupportedOperationException("An operation is not implemented: " + reason$iv);
            }
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"when (columnType.dataTyp\u2026ype.dataType}\")\n        }");
        return localDateTime;
    }

    private final DateTimeFormatter selectFormatter(String text) {
        DateTimeFormatter dateTimeFormatter;
        if (StringsKt.contains$default((CharSequence)text, (CharSequence)".", (boolean)false, (int)2, null)) {
            dateTimeFormatter = internalFormatters.get(5);
        } else {
            DateTimeFormatter dateTimeFormatter2 = internalFormatterWithoutSeconds;
            dateTimeFormatter = dateTimeFormatter2;
            Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeFormatter2, (String)"internalFormatterWithoutSeconds");
        }
        return dateTimeFormatter;
    }

    @NotNull
    public Object decode(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        throw (Throwable)new UnsupportedOperationException("this method should not have been called");
    }

    @NotNull
    public String encode(@NotNull Object value) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Object object = value;
        if (object instanceof Timestamp) {
            String string2 = this.formatter().print((ReadableInstant)new DateTime(value));
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"this.formatter().print(DateTime(value))");
        } else if (object instanceof Date) {
            String string3 = this.formatter().print((ReadableInstant)new DateTime(value));
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"this.formatter().print(DateTime(value))");
        } else if (object instanceof Calendar) {
            String string4 = this.formatter().print((ReadableInstant)new DateTime(value));
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"this.formatter().print(DateTime(value))");
        } else if (object instanceof LocalDateTime) {
            String string5 = this.formatter().print((ReadablePartial)value);
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"this.formatter().print(value)");
        } else if (object instanceof ReadableDateTime) {
            String string6 = this.formatter().print((ReadableInstant)value);
            string = string6;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"this.formatter().print(value)");
        } else {
            throw (Throwable)new DateEncoderNotAvailableException(value);
        }
        return string;
    }

    public boolean supportsStringDecoding() {
        return false;
    }

    private PostgreSQLTimestampEncoderDecoder() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_4;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        PostgreSQLTimestampEncoderDecoder postgreSQLTimestampEncoderDecoder;
        INSTANCE = postgreSQLTimestampEncoderDecoder = new PostgreSQLTimestampEncoderDecoder();
        optionalTimeZone = new DateTimeFormatterBuilder().appendPattern("Z").toParser();
        int n = 1;
        Iterable iterable = $receiver$iv = (Iterable)new IntRange(n, 6);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void index;
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendPattern("." + StringsKt.repeat((CharSequence)"S", (int)index)).appendOptional(optionalTimeZone).toFormatter();
            collection.add(dateTimeFormatter);
        }
        internalFormatters = (List)var3_4;
        internalFormatterWithoutSeconds = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendOptional(optionalTimeZone).toFormatter();
    }
}

