/*
 * Decompiled with CFR 0.152.
 */
package com.github.jasync.sql.db.postgresql.util;

import com.github.jasync.sql.db.Configuration;
import com.github.jasync.sql.db.SSLConfiguration;
import com.github.jasync.sql.db.util.AbstractURIParser;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\f\u001a\u00020\u00042\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/jasync/sql/db/postgresql/util/URLParser;", "Lcom/github/jasync/sql/db/util/AbstractURIParser;", "()V", "DEFAULT", "Lcom/github/jasync/sql/db/Configuration;", "getDEFAULT", "()Lcom/github/jasync/sql/db/Configuration;", "SCHEME", "Lkotlin/text/Regex;", "getSCHEME", "()Lkotlin/text/Regex;", "simplePGDB", "assembleConfiguration", "properties", "", "", "charset", "Ljava/nio/charset/Charset;", "handleJDBC", "uri", "Ljava/net/URI;", "jasync-postgresql"})
public final class URLParser
extends AbstractURIParser {
    @NotNull
    private static final Configuration DEFAULT;
    @NotNull
    private static final Regex SCHEME;
    private static final Regex simplePGDB;
    public static final URLParser INSTANCE;

    @NotNull
    public Configuration getDEFAULT() {
        return DEFAULT;
    }

    @NotNull
    protected Regex getSCHEME() {
        return SCHEME;
    }

    @NotNull
    protected Map<String, String> handleJDBC(@NotNull URI uri) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        String string = uri.getSchemeSpecificPart();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri.schemeSpecificPart");
        if (simplePGDB.matches((CharSequence)string)) {
            String string2 = uri.getSchemeSpecificPart();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"uri.schemeSpecificPart");
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"database", (Object)StringsKt.removePrefix((String)string2, (CharSequence)"postgresql:")));
        } else {
            map2 = this.parse(new URI(uri.getSchemeSpecificPart()));
        }
        return map2;
    }

    @NotNull
    protected Configuration assembleConfiguration(@NotNull Map<String, String> properties, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        return Configuration.copy$default((Configuration)super.assembleConfiguration(properties, charset), null, null, (int)0, null, null, (SSLConfiguration)new SSLConfiguration(properties), null, (int)0, null, (int)0, null, null, null, null, null, (int)32735, null);
    }

    private URLParser() {
    }

    static {
        URLParser uRLParser;
        INSTANCE = uRLParser = new URLParser();
        DEFAULT = new Configuration("postgres", "localhost", 5432, null, null, new SSLConfiguration(null, null, null, null, 15, null), null, 0, null, 0, null, null, null, null, null, 32704, null);
        String string = "^postgres(?:ql)?$";
        boolean bl = false;
        SCHEME = new Regex(string);
        string = "^postgresql:(\\w+)$";
        bl = false;
        simplePGDB = new Regex(string);
    }
}

