/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.impl;

import com.github.jsonldjava.core.JSONLDTripleCallback;
import com.github.jsonldjava.core.RDFDataset;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.util.List;

public class JenaTripleCallback
implements JSONLDTripleCallback {
    private Model jenaModel = ModelFactory.createDefaultModel();

    public void setJenaModel(Model jenaModel) {
        this.jenaModel = jenaModel;
    }

    public Model getJenaModel() {
        return this.jenaModel;
    }

    private void triple(String s, String p, String o, String graph) {
        Resource oR;
        Property pR;
        if (s == null || p == null || o == null) {
            return;
        }
        Resource sR = this.jenaModel.getResource(s);
        if (sR == null) {
            sR = this.jenaModel.createResource(s);
        }
        if ((pR = this.jenaModel.getProperty(p)) == null) {
            pR = this.jenaModel.createProperty(p);
        }
        if ((oR = this.jenaModel.getResource(o)) == null) {
            oR = this.jenaModel.createResource(o);
        }
        Statement statement = this.jenaModel.createStatement(sR, pR, (RDFNode)oR);
        this.jenaModel.add(statement);
    }

    private void triple(String s, String p, String value, String datatype, String language, String graph) {
        Property pR;
        Resource sR = this.jenaModel.getResource(s);
        if (sR == null) {
            sR = this.jenaModel.createResource(s);
        }
        if ((pR = this.jenaModel.getProperty(p)) == null) {
            pR = this.jenaModel.createProperty(p);
        }
        Literal oR = language != null ? this.jenaModel.createLiteral(value, language) : this.jenaModel.createTypedLiteral(value, datatype);
        Statement statement = this.jenaModel.createStatement(sR, pR, (RDFNode)oR);
        this.jenaModel.add(statement);
    }

    public Object call(RDFDataset dataset) {
        for (String graphName : dataset.graphNames()) {
            List quads = dataset.getQuads(graphName);
            if ("@default".equals(graphName)) {
                graphName = null;
            }
            for (RDFDataset.Quad quad : quads) {
                if (quad.getObject().isLiteral()) {
                    this.triple(quad.getSubject().getValue(), quad.getPredicate().getValue(), quad.getObject().getValue(), quad.getObject().getDatatype(), quad.getObject().getLanguage(), graphName);
                    continue;
                }
                this.triple(quad.getSubject().getValue(), quad.getPredicate().getValue(), quad.getObject().getValue(), graphName);
            }
        }
        return this.getJenaModel();
    }
}

