/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient;

import io.netty.buffer.ByteBuf;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.ArrayTuple;
import io.vertx.sqlclient.impl.ListTuple;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@VertxGen
public interface Tuple {
    public static final Object JSON_NULL = new Object(){

        public String toString() {
            return "null";
        }
    };

    public static Tuple tuple() {
        return new ArrayTuple(10);
    }

    public static <T> Tuple from(List<T> list) {
        return Tuple.wrap(new ArrayList<T>(list));
    }

    @GenIgnore(value={"permitted-type"})
    public static Tuple from(Object[] array) {
        ArrayList<Object> list = new ArrayList<Object>(array.length);
        for (Object o : array) {
            list.add(o);
        }
        return Tuple.wrap(list);
    }

    public static <T> Tuple wrap(List<T> list) {
        return new ListTuple(list);
    }

    @GenIgnore(value={"permitted-type"})
    public static Tuple wrap(Object[] array) {
        return new ListTuple(Arrays.asList(array));
    }

    public static Tuple of(Object elt1) {
        ArrayTuple tuple = new ArrayTuple(1);
        tuple.addValue(elt1);
        return tuple;
    }

    public static Tuple of(Object elt1, Object elt2) {
        ArrayTuple tuple = new ArrayTuple(2);
        tuple.addValue(elt1);
        tuple.addValue(elt2);
        return tuple;
    }

    public static Tuple of(Object elt1, Object elt2, Object elt3) {
        ArrayTuple tuple = new ArrayTuple(3);
        tuple.addValue(elt1);
        tuple.addValue(elt2);
        tuple.addValue(elt3);
        return tuple;
    }

    public static Tuple of(Object elt1, Object elt2, Object elt3, Object elt4) {
        ArrayTuple tuple = new ArrayTuple(4);
        tuple.addValue(elt1);
        tuple.addValue(elt2);
        tuple.addValue(elt3);
        tuple.addValue(elt4);
        return tuple;
    }

    public static Tuple of(Object elt1, Object elt2, Object elt3, Object elt4, Object elt5) {
        ArrayTuple tuple = new ArrayTuple(5);
        tuple.addValue(elt1);
        tuple.addValue(elt2);
        tuple.addValue(elt3);
        tuple.addValue(elt4);
        tuple.addValue(elt5);
        return tuple;
    }

    public static Tuple of(Object elt1, Object elt2, Object elt3, Object elt4, Object elt5, Object elt6) {
        ArrayTuple tuple = new ArrayTuple(6);
        tuple.addValue(elt1);
        tuple.addValue(elt2);
        tuple.addValue(elt3);
        tuple.addValue(elt4);
        tuple.addValue(elt5);
        tuple.addValue(elt6);
        return tuple;
    }

    @GenIgnore
    public static Tuple of(Object elt1, Object ... elts) {
        ArrayTuple tuple = new ArrayTuple(1 + elts.length);
        tuple.addValue(elt1);
        for (Object elt : elts) {
            tuple.addValue(elt);
        }
        return tuple;
    }

    public static Tuple tuple(List<Object> elements) {
        return new ArrayTuple(elements);
    }

    public Object getValue(int var1);

    default public Boolean getBoolean(int pos) {
        return (Boolean)this.getValue(pos);
    }

    default public Short getShort(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Short) {
            return (Short)val;
        }
        if (val instanceof Number) {
            return ((Number)val).shortValue();
        }
        if (val instanceof Enum) {
            return (short)((Enum)val).ordinal();
        }
        return (Short)val;
    }

    default public Integer getInteger(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        if (val instanceof Enum) {
            return ((Enum)val).ordinal();
        }
        return (Integer)val;
    }

    default public Long getLong(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        if (val instanceof Enum) {
            return ((Enum)val).ordinal();
        }
        return (Long)val;
    }

    default public Float getFloat(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Float) {
            return (Float)val;
        }
        if (val instanceof Number) {
            return Float.valueOf(((Number)val).floatValue());
        }
        if (val instanceof Enum) {
            return Float.valueOf(((Enum)val).ordinal());
        }
        return (Float)val;
    }

    default public Double getDouble(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        if (val instanceof Enum) {
            return ((Enum)val).ordinal();
        }
        return (Double)val;
    }

    @GenIgnore(value={"permitted-type"})
    default public Numeric getNumeric(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Numeric) {
            return (Numeric)val;
        }
        if (val instanceof Number) {
            return Numeric.create((Number)((Number)val));
        }
        return (Numeric)val;
    }

    default public String getString(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof Enum) {
            return ((Enum)val).name();
        }
        throw new ClassCastException("Invalid String value type " + val.getClass());
    }

    default public JsonObject getJsonObject(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof JsonObject) {
            return (JsonObject)val;
        }
        if (val instanceof Buffer) {
            return new JsonObject((Map)Json.CODEC.fromBuffer((Buffer)val, Map.class));
        }
        throw new ClassCastException("Invalid JsonObject value type " + val.getClass());
    }

    default public JsonArray getJsonArray(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof JsonArray) {
            return (JsonArray)val;
        }
        if (val instanceof Buffer) {
            return new JsonArray((List)Json.CODEC.fromBuffer((Buffer)val, List.class));
        }
        throw new ClassCastException("Invalid JsonArray value type " + val.getClass());
    }

    default public Object getJson(int pos) {
        Object val = this.getValue(pos);
        if (val == null || val == JSON_NULL || val instanceof Buffer || val instanceof String || val instanceof Boolean || val instanceof Number || val instanceof JsonObject || val instanceof JsonArray) {
            return val;
        }
        throw new ClassCastException("Invalid JSON value type " + val.getClass());
    }

    @GenIgnore(value={"permitted-type"})
    default public Temporal getTemporal(int pos) {
        return (Temporal)this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDate getLocalDate(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof LocalDate) {
            return (LocalDate)val;
        }
        if (val instanceof LocalDateTime) {
            return ((LocalDateTime)val).toLocalDate();
        }
        return (LocalDate)val;
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalTime getLocalTime(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof LocalTime) {
            return (LocalTime)val;
        }
        if (val instanceof LocalDateTime) {
            return ((LocalDateTime)val).toLocalTime();
        }
        return (LocalTime)val;
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDateTime getLocalDateTime(int pos) {
        return (LocalDateTime)this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetTime getOffsetTime(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof OffsetTime) {
            return (OffsetTime)val;
        }
        if (val instanceof OffsetDateTime) {
            return ((OffsetDateTime)val).toOffsetTime();
        }
        return (OffsetTime)val;
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetDateTime getOffsetDateTime(int pos) {
        return (OffsetDateTime)this.getValue(pos);
    }

    default public Buffer getBuffer(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Buffer) {
            return (Buffer)val;
        }
        if (val instanceof ByteBuf) {
            return Buffer.buffer((ByteBuf)((ByteBuf)val));
        }
        if (val instanceof byte[]) {
            return Buffer.buffer((byte[])((byte[])val));
        }
        return (Buffer)val;
    }

    @GenIgnore(value={"permitted-type"})
    default public UUID getUUID(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof UUID) {
            return (UUID)val;
        }
        if (val instanceof String) {
            return UUID.fromString((String)val);
        }
        return (UUID)val;
    }

    @GenIgnore(value={"permitted-type"})
    default public BigDecimal getBigDecimal(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val instanceof Number) {
            return new BigDecimal(val.toString());
        }
        return (BigDecimal)val;
    }

    @GenIgnore(value={"permitted-type"})
    default public Boolean[] getArrayOfBooleans(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Boolean[]) {
            return (Boolean[])val;
        }
        if (val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            Boolean[] booleanArray = new Boolean[array.length];
            for (int i = 0; i < array.length; ++i) {
                booleanArray[i] = (Boolean)array[i];
            }
            return booleanArray;
        }
        return (Boolean[])val;
    }

    @GenIgnore(value={"permitted-type"})
    default public Short[] getArrayOfShorts(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Short[]) {
            return (Short[])val;
        }
        if (val instanceof Number[]) {
            Number[] a = (Number[])val;
            int len = a.length;
            Short[] arr = new Short[len];
            for (int i = 0; i < len; ++i) {
                Number elt = a[i];
                if (elt == null) continue;
                arr[i] = elt.shortValue();
            }
            return arr;
        }
        if (val instanceof Enum[]) {
            Enum[] a = (Enum[])val;
            int len = a.length;
            Short[] arr = new Short[len];
            for (int i = 0; i < len; ++i) {
                Enum elt = a[i];
                if (elt == null) continue;
                arr[i] = (short)elt.ordinal();
            }
            return arr;
        }
        if (val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            Short[] shortArray = new Short[array.length];
            for (int i = 0; i < array.length; ++i) {
                shortArray[i] = ((Number)array[i]).shortValue();
            }
            return shortArray;
        }
        return (Short[])val;
    }

    @GenIgnore(value={"permitted-type"})
    default public Integer[] getArrayOfIntegers(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Integer[]) {
            return (Integer[])val;
        }
        if (val instanceof Number[]) {
            Number[] a = (Number[])val;
            int len = a.length;
            Integer[] arr = new Integer[len];
            for (int i = 0; i < len; ++i) {
                Number elt = a[i];
                if (elt == null) continue;
                arr[i] = elt.intValue();
            }
            return arr;
        }
        if (val instanceof Enum[]) {
            Enum[] a = (Enum[])val;
            int len = a.length;
            Integer[] arr = new Integer[len];
            for (int i = 0; i < len; ++i) {
                Enum elt = a[i];
                if (elt == null) continue;
                arr[i] = elt.ordinal();
            }
            return arr;
        }
        if (val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            Integer[] integerArray = new Integer[array.length];
            for (int i = 0; i < array.length; ++i) {
                integerArray[i] = ((Number)array[i]).intValue();
            }
            return integerArray;
        }
        return (Integer[])val;
    }

    @GenIgnore(value={"permitted-type"})
    default public Long[] getArrayOfLongs(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Long[]) {
            return (Long[])val;
        }
        if (val instanceof Number[]) {
            Number[] a = (Number[])val;
            int len = a.length;
            Long[] arr = new Long[len];
            for (int i = 0; i < len; ++i) {
                Number elt = a[i];
                if (elt == null) continue;
                arr[i] = elt.longValue();
            }
            return arr;
        }
        if (val instanceof Enum[]) {
            Enum[] a = (Enum[])val;
            int len = a.length;
            Long[] arr = new Long[len];
            for (int i = 0; i < len; ++i) {
                Enum elt = a[i];
                if (elt == null) continue;
                arr[i] = elt.ordinal();
            }
            return arr;
        }
        if (val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            Long[] longArray = new Long[array.length];
            for (int i = 0; i < array.length; ++i) {
                longArray[i] = ((Number)array[i]).longValue();
            }
            return longArray;
        }
        return (Long[])val;
    }

    @GenIgnore(value={"permitted-type"})
    default public Float[] getArrayOfFloats(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Float[]) {
            return (Float[])val;
        }
        if (val instanceof Number[]) {
            Number[] a = (Number[])val;
            int len = a.length;
            Float[] arr = new Float[len];
            for (int i = 0; i < len; ++i) {
                Number elt = a[i];
                if (elt == null) continue;
                arr[i] = Float.valueOf(elt.floatValue());
            }
            return arr;
        }
        if (val instanceof Enum[]) {
            Enum[] a = (Enum[])val;
            int len = a.length;
            Float[] arr = new Float[len];
            for (int i = 0; i < len; ++i) {
                Enum elt = a[i];
                if (elt == null) continue;
                arr[i] = Float.valueOf(elt.ordinal());
            }
            return arr;
        }
        if (val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            Float[] floatArray = new Float[array.length];
            for (int i = 0; i < array.length; ++i) {
                floatArray[i] = Float.valueOf(((Number)array[i]).floatValue());
            }
            return floatArray;
        }
        return (Float[])val;
    }

    @GenIgnore(value={"permitted-type"})
    default public Double[] getArrayOfDoubles(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Double[]) {
            return (Double[])val;
        }
        if (val instanceof Number[]) {
            Number[] a = (Number[])val;
            int len = a.length;
            Double[] arr = new Double[len];
            for (int i = 0; i < len; ++i) {
                Number elt = a[i];
                if (elt == null) continue;
                arr[i] = elt.doubleValue();
            }
            return arr;
        }
        if (val instanceof Enum[]) {
            Enum[] a = (Enum[])val;
            int len = a.length;
            Double[] arr = new Double[len];
            for (int i = 0; i < len; ++i) {
                Enum elt = a[i];
                if (elt == null) continue;
                arr[i] = elt.ordinal();
            }
            return arr;
        }
        if (val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            Double[] doubleArray = new Double[array.length];
            for (int i = 0; i < array.length; ++i) {
                doubleArray[i] = ((Number)array[i]).doubleValue();
            }
            return doubleArray;
        }
        return (Double[])val;
    }

    @GenIgnore(value={"permitted-type"})
    default public Numeric[] getArrayOfNumerics(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof Numeric[]) {
            return (Numeric[])val;
        }
        if (val instanceof Number[]) {
            Number[] a = (Number[])val;
            int len = a.length;
            Numeric[] arr = new Numeric[len];
            for (int i = 0; i < len; ++i) {
                Number elt = a[i];
                if (elt == null) continue;
                arr[i] = Numeric.create((Number)elt);
            }
            return arr;
        }
        if (val instanceof Enum[]) {
            Enum[] a = (Enum[])val;
            int len = a.length;
            Numeric[] arr = new Numeric[len];
            for (int i = 0; i < len; ++i) {
                Enum elt = a[i];
                if (elt == null) continue;
                arr[i] = Numeric.create((Number)elt.ordinal());
            }
            return arr;
        }
        if (val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            Numeric[] doubleArray = new Numeric[array.length];
            for (int i = 0; i < array.length; ++i) {
                doubleArray[i] = Numeric.create((Number)((Number)array[i]));
            }
            return doubleArray;
        }
        throw new ClassCastException();
    }

    @GenIgnore(value={"permitted-type"})
    default public String[] getArrayOfStrings(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof String[]) {
            return (String[])val;
        }
        if (val instanceof Enum[]) {
            Enum[] a = (Enum[])val;
            int len = a.length;
            String[] arr = new String[len];
            for (int i = 0; i < len; ++i) {
                Enum elt = a[i];
                if (elt == null) continue;
                arr[i] = elt.name();
            }
            return arr;
        }
        if (val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            String[] stringArray = new String[array.length];
            for (int i = 0; i < array.length; ++i) {
                stringArray[i] = (String)array[i];
            }
            return stringArray;
        }
        return (String[])val;
    }

    @GenIgnore(value={"permitted-type"})
    default public JsonObject[] getArrayOfJsonObjects(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            JsonObject[] jsonObjectArray = new JsonObject[array.length];
            for (int i = 0; i < array.length; ++i) {
                jsonObjectArray[i] = (JsonObject)array[i];
            }
            return jsonObjectArray;
        }
        return (JsonObject[])val;
    }

    @GenIgnore(value={"permitted-type"})
    default public JsonArray[] getArrayOfJsonArrays(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            JsonArray[] jsonObjectArray = new JsonArray[array.length];
            for (int i = 0; i < array.length; ++i) {
                jsonObjectArray[i] = (JsonArray)array[i];
            }
            return jsonObjectArray;
        }
        return (JsonArray[])val;
    }

    @GenIgnore(value={"permitted-type"})
    default public Object[] getArrayOfJsons(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof JsonObject[] || val instanceof JsonArray[] || val instanceof Number[] || val instanceof Boolean[] || val instanceof String[]) {
            return (Object[])val;
        }
        if (val.getClass() == Object[].class) {
            Object[] array = (Object[])val;
            for (int i = 0; i < array.length; ++i) {
                Object elt = Array.get(val, i);
                if (elt == null || elt == JSON_NULL || elt instanceof String || elt instanceof Boolean || elt instanceof Number || elt instanceof JsonObject || elt instanceof JsonArray) continue;
                throw new ClassCastException();
            }
            return array;
        }
        throw new ClassCastException();
    }

    @GenIgnore(value={"permitted-type"})
    default public Temporal[] getArrayOfTemporals(int pos) {
        return (Temporal[])this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDate[] getArrayOfLocalDates(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof LocalDate[]) {
            return (LocalDate[])val;
        }
        if (val instanceof LocalDateTime[]) {
            LocalDateTime[] a = (LocalDateTime[])val;
            int len = a.length;
            LocalDate[] arr = new LocalDate[len];
            for (int i = 0; i < len; ++i) {
                LocalDateTime elt = a[i];
                if (elt == null) continue;
                arr[i] = elt.toLocalDate();
            }
            return arr;
        }
        return (LocalDate[])val;
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalTime[] getArrayOfLocalTimes(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof LocalTime[]) {
            return (LocalTime[])val;
        }
        if (val instanceof LocalDateTime[]) {
            LocalDateTime[] a = (LocalDateTime[])val;
            int len = a.length;
            LocalTime[] arr = new LocalTime[len];
            for (int i = 0; i < len; ++i) {
                LocalDateTime elt = a[i];
                if (elt == null) continue;
                arr[i] = elt.toLocalTime();
            }
            return arr;
        }
        return (LocalTime[])val;
    }

    @GenIgnore(value={"permitted-type"})
    default public LocalDateTime[] getArrayOfLocalDateTimes(int pos) {
        return (LocalDateTime[])this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetTime[] getArrayOfOffsetTimes(int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof OffsetTime[]) {
            return (OffsetTime[])val;
        }
        if (val instanceof OffsetDateTime[]) {
            OffsetDateTime[] a = (OffsetDateTime[])val;
            int len = a.length;
            OffsetTime[] arr = new OffsetTime[len];
            for (int i = 0; i < len; ++i) {
                OffsetDateTime elt = a[i];
                if (elt == null) continue;
                arr[i] = elt.toOffsetTime();
            }
            return arr;
        }
        return (OffsetTime[])val;
    }

    @GenIgnore(value={"permitted-type"})
    default public OffsetDateTime[] getArrayOfOffsetDateTimes(int pos) {
        return (OffsetDateTime[])this.getValue(pos);
    }

    @GenIgnore
    default public Buffer[] getArrayOfBuffers(int pos) {
        return (Buffer[])this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public UUID[] getArrayOfUUIDs(int pos) {
        return (UUID[])this.getValue(pos);
    }

    @GenIgnore(value={"permitted-type"})
    default public BigDecimal[] getArrayOfBigDecimals(int pos) {
        return (BigDecimal[])this.getValue(pos);
    }

    @Fluent
    public Tuple addValue(Object var1);

    @Fluent
    default public Tuple addBoolean(Boolean value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addShort(Short value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addInteger(Integer value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addLong(Long value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addFloat(Float value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addDouble(Double value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addString(String value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addJsonObject(JsonObject value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addJsonArray(JsonArray value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addTemporal(Temporal value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addLocalDate(LocalDate value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addLocalTime(LocalTime value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addLocalDateTime(LocalDateTime value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addOffsetTime(OffsetTime value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addOffsetDateTime(OffsetDateTime value) {
        return this.addValue(value);
    }

    @Fluent
    default public Tuple addBuffer(Buffer value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addUUID(UUID value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addBigDecimal(BigDecimal value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addArrayOfBoolean(Boolean[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addArrayOfShort(Short[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addArrayOfInteger(Integer[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addArrayOfLong(Long[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addArrayOfFloat(Float[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addArrayOfDouble(Double[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addArrayOfString(String[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addArrayOfJsonObject(JsonObject[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addArrayOfJsonArray(JsonArray[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addArrayOfTemporal(Temporal[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addArrayOfLocalDate(LocalDate[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addArrayOfLocalTime(LocalTime[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addArrayOfLocalDateTime(LocalDateTime[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addArrayOfOffsetTime(OffsetTime[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addArrayOfOffsetDateTime(OffsetDateTime[] value) {
        return this.addValue(value);
    }

    @GenIgnore
    default public Tuple addArrayOfBuffer(Buffer[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addArrayOfUUID(UUID[] value) {
        return this.addValue(value);
    }

    @GenIgnore(value={"permitted-type"})
    default public Tuple addArrayOfBigDecimal(BigDecimal[] value) {
        return this.addValue(value);
    }

    default public <T> T get(Class<T> type, int position) {
        if (type == null) {
            throw new IllegalArgumentException("Accessor type can not be null");
        }
        Object value = this.getValue(position);
        if (value != null && type.isAssignableFrom(value.getClass())) {
            return type.cast(value);
        }
        return null;
    }

    public int size();

    public void clear();

    @GenIgnore
    default public List<Class<?>> types() {
        int len = this.size();
        ArrayList types = new ArrayList();
        for (int i = 0; i < len; ++i) {
            Object param = this.getValue(i);
            if (param == null) {
                types.add(Object.class);
                continue;
            }
            types.add(param.getClass());
        }
        return types;
    }

    default public String deepToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            sb.append(this.getValue(i));
            if (i + 1 >= size) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

