/*
 * Decompiled with CFR 0.152.
 */
package com.github.longdt.vertxorm.repository.postgresql.query;

import com.github.longdt.vertxorm.repository.postgresql.query.Between;
import com.github.longdt.vertxorm.repository.postgresql.query.Equal;
import com.github.longdt.vertxorm.repository.postgresql.query.GreaterThan;
import com.github.longdt.vertxorm.repository.postgresql.query.GreaterThanEqual;
import com.github.longdt.vertxorm.repository.postgresql.query.Has;
import com.github.longdt.vertxorm.repository.postgresql.query.ILike;
import com.github.longdt.vertxorm.repository.postgresql.query.In;
import com.github.longdt.vertxorm.repository.postgresql.query.IsNull;
import com.github.longdt.vertxorm.repository.postgresql.query.LessThan;
import com.github.longdt.vertxorm.repository.postgresql.query.LessThanEqual;
import com.github.longdt.vertxorm.repository.postgresql.query.Like;
import com.github.longdt.vertxorm.repository.postgresql.query.NotEqual;
import com.github.longdt.vertxorm.repository.postgresql.query.RawQuery;
import com.github.longdt.vertxorm.repository.query.And;
import com.github.longdt.vertxorm.repository.query.Not;
import com.github.longdt.vertxorm.repository.query.Or;
import com.github.longdt.vertxorm.repository.query.Order;
import com.github.longdt.vertxorm.repository.query.Query;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.ArrayTuple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class QueryFactory {
    public static final Tuple EMPTY_PARAMS = ArrayTuple.EMPTY;

    public static <E> Equal<E> equal(String fieldName, Object value) {
        return new Equal(fieldName, value);
    }

    public static <E> NotEqual<E> notEqual(String fieldName, Object value) {
        return new NotEqual(fieldName, value);
    }

    public static <O, A extends Comparable<A>> LessThanEqual<O, A> lessThanOrEqualTo(String fieldName, A value) {
        return new LessThanEqual(fieldName, value);
    }

    public static <O, A extends Comparable<A>> LessThan<O, A> lessThan(String fieldName, A value) {
        return new LessThan(fieldName, value);
    }

    public static <O, A extends Comparable<A>> GreaterThanEqual<O, A> greaterThanOrEqualTo(String fieldName, A value) {
        return new GreaterThanEqual(fieldName, value);
    }

    public static <O, A extends Comparable<A>> GreaterThan<O, A> greaterThan(String fieldName, A value) {
        return new GreaterThan(fieldName, value);
    }

    public static <E> And<E> and(Query<E> query1, Query<E> query2) {
        List<Query> queries = Arrays.asList(query1, query2);
        return new And(queries);
    }

    public static <E> And<E> and(Query<E> query1, Query<E> query2, Query<E> ... additionalQueries) {
        ArrayList<Query<E>> queries = new ArrayList<Query<E>>(2 + additionalQueries.length);
        queries.add(query1);
        queries.add(query2);
        Collections.addAll(queries, additionalQueries);
        return new And(queries);
    }

    public static <E> And<E> and(Query<E> query1, Query<E> query2, Collection<Query<E>> additionalQueries) {
        ArrayList<Query<E>> queries = new ArrayList<Query<E>>(2 + additionalQueries.size());
        queries.add(query1);
        queries.add(query2);
        queries.addAll(additionalQueries);
        return new And(queries);
    }

    public static <O> Or<O> or(Query<O> query1, Query<O> query2) {
        List<Query> queries = Arrays.asList(query1, query2);
        return new Or(queries);
    }

    public static <O> Or<O> or(Query<O> query1, Query<O> query2, Query<O> ... additionalQueries) {
        ArrayList<Query<O>> queries = new ArrayList<Query<O>>(2 + additionalQueries.length);
        queries.add(query1);
        queries.add(query2);
        Collections.addAll(queries, additionalQueries);
        return new Or(queries);
    }

    public static <O> Or<O> or(Query<O> query1, Query<O> query2, Collection<Query<O>> additionalQueries) {
        ArrayList<Query<O>> queries = new ArrayList<Query<O>>(2 + additionalQueries.size());
        queries.add(query1);
        queries.add(query2);
        queries.addAll(additionalQueries);
        return new Or(queries);
    }

    public static <O> Not<O> not(Query<O> query) {
        return new Not(query);
    }

    public static <O> Has<O> has(String fieldName) {
        return new Has(fieldName);
    }

    public static <O> IsNull<O> isNull(String fieldName) {
        return new IsNull(fieldName);
    }

    public static <O> RawQuery<O> raw(String querySql, Object ... params) {
        return new RawQuery(querySql, Tuple.wrap(params));
    }

    public static <O> RawQuery<O> raw(String querySql) {
        return new RawQuery(querySql);
    }

    public static <O> Order<O> ascending(String fieldName) {
        return new Order(fieldName);
    }

    public static <O> Order<O> descending(String fieldName) {
        return new Order(fieldName, true);
    }

    public static <O, A> Query<O> in(String attribute, A ... attributeValues) {
        return QueryFactory.in(attribute, Arrays.asList(attributeValues));
    }

    public static <O, A> Query<O> in(String attribute, List<A> attributeValues) {
        int n = attributeValues.size();
        switch (n) {
            case 0: {
                return QueryFactory.none();
            }
            case 1: {
                A singleValue = attributeValues.iterator().next();
                return QueryFactory.equal(attribute, singleValue);
            }
        }
        return new In(attribute, attributeValues);
    }

    public static <O> Query<O> none() {
        return QueryFactory.raw("FALSE");
    }

    public static <O> Query<O> all() {
        return QueryFactory.raw("TRUE");
    }

    public static <O> Like<O> startsWith(String fieldName, String value) {
        return new Like(fieldName, "%" + value);
    }

    public static <O> Like<O> endsWith(String fieldName, String value) {
        return new Like(fieldName, value + "%");
    }

    public static <O> Like<O> contains(String fieldName, String value) {
        return new Like(fieldName, "%" + value + "%");
    }

    public static <O> Like<O> like(String fieldName, String value) {
        return new Like(fieldName, value);
    }

    public static <O> ILike<O> ilike(String fieldName, String value) {
        return new ILike(fieldName, value);
    }

    public static <O> Query<O> isContainedIn(String fieldName, String value) {
        return QueryFactory.raw("?  LIKE '%' || `" + fieldName + "` || '%'", value);
    }

    public static <O, A extends Comparable<A>> Between<O, A> between(String fieldName, A lowerValue, A upperValue) {
        return new Between(fieldName, lowerValue, upperValue);
    }

    public static Tuple emptyParams() {
        return EMPTY_PARAMS;
    }

    public static <E> Query<E> emptyQuery() {
        return new RawQuery(null);
    }
}

