/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.cronparser.domain;

import java.util.Arrays;
import uk.co.mruoc.cronparser.domain.ParserException;

public class ArgumentsSanitizer {
    private static final int REQUIRED_ARGUMENTS = 6;
    private static final String USAGE_MESSAGE = "usage: please provide a valid cron expression";

    public String[] sanitize(String[] args) {
        if (args.length < 6) {
            throw new ParserException(ArgumentsSanitizer.toErrorMessage(args));
        }
        return ArgumentsSanitizer.toRequiredArgs(args);
    }

    private static String toErrorMessage(String[] args) {
        if (args.length == 0) {
            return USAGE_MESSAGE;
        }
        return ArgumentsSanitizer.toInvalidExpressionMessage(args);
    }

    private static String toInvalidExpressionMessage(String[] args) {
        String expression = String.join((CharSequence)" ", args);
        return String.format("%s, invalid cron expression provided %s", USAGE_MESSAGE, expression);
    }

    private static String[] toRequiredArgs(String[] args) {
        return Arrays.copyOfRange(args, args.length - 6, args.length);
    }
}

