/*
 * Decompiled with CFR 0.152.
 */
package uk.co.mruoc.cronparser.domain.notation;

import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import uk.co.mruoc.cronparser.domain.TimeUnit;
import uk.co.mruoc.cronparser.domain.notation.InvalidNotationException;
import uk.co.mruoc.cronparser.domain.notation.NotationParser;
import uk.co.mruoc.cronparser.domain.notation.RangeNotationParser;
import uk.co.mruoc.cronparser.domain.notation.SimpleNotationParser;
import uk.co.mruoc.cronparser.domain.notation.StringUtil;

public class IntervalNotationParser
implements NotationParser {
    private static final String WILDCARD = "*";
    private final RangeNotationParser rangeParser;
    private final SimpleNotationParser simpleParser;

    public IntervalNotationParser() {
        this(new RangeNotationParser(), new SimpleNotationParser());
    }

    @Override
    public boolean appliesTo(String value) {
        String[] parts = IntervalNotationParser.split(value);
        if (parts.length == 2) {
            return this.isIntWildcardRangeOrIntegers(parts[0]) && StringUtil.isInt(parts[1]);
        }
        return false;
    }

    @Override
    public int[] toValues(String input, TimeUnit unit) {
        try {
            String[] parts = IntervalNotationParser.split(input);
            String first = parts[0];
            int start = this.toStart(first, unit);
            int end = this.toEnd(first, unit);
            unit.validate(start);
            unit.validate(end);
            int interval = Integer.parseInt(parts[1]);
            return IntervalNotationParser.calculateIntervalsArray(start, end, interval);
        }
        catch (ArrayIndexOutOfBoundsException | InvalidNotationException e) {
            throw new InvalidNotationException(input, e);
        }
    }

    private static String[] split(String value) {
        return StringUtils.split((String)value, (String)"/");
    }

    private int toStart(String value, TimeUnit unit) {
        if (WILDCARD.equals(value)) {
            return unit.getLowerBound();
        }
        if (this.rangeParser.appliesTo(value)) {
            return this.rangeParser.toFirstValue(value, unit);
        }
        return this.simpleParser.toFirstValue(value, unit);
    }

    private int toEnd(String value, TimeUnit unit) {
        if (this.rangeParser.appliesTo(value)) {
            int[] values = this.rangeParser.toValues(value, unit);
            return values[values.length - 1];
        }
        return unit.getUpperBound();
    }

    private static int[] calculateIntervalsArray(int start, int end, int interval) {
        return IntervalNotationParser.calculateIntervals(start, end, interval).distinct().sorted().toArray();
    }

    private static IntStream calculateIntervals(int start, int end, int interval) {
        return IntStream.iterate(start, IntervalNotationParser.lessThan(end), IntervalNotationParser.incrementBy(interval));
    }

    private static IntPredicate lessThan(int max) {
        return i -> i <= max;
    }

    private static IntUnaryOperator incrementBy(int interval) {
        return i -> i + interval;
    }

    private boolean isIntWildcardRangeOrIntegers(String value) {
        return WILDCARD.equals(value) || this.rangeParser.appliesTo(value) || this.simpleParser.appliesTo(value);
    }

    @Generated
    public IntervalNotationParser(RangeNotationParser rangeParser, SimpleNotationParser simpleParser) {
        this.rangeParser = rangeParser;
        this.simpleParser = simpleParser;
    }
}

