/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.client;

import com.mpush.api.Client;
import com.mpush.api.Logger;
import com.mpush.api.connection.SessionContext;
import com.mpush.api.connection.SessionStorage;
import com.mpush.api.http.HttpRequest;
import com.mpush.api.http.HttpResponse;
import com.mpush.api.protocol.Command;
import com.mpush.api.protocol.Packet;
import com.mpush.client.ClientConfig;
import com.mpush.client.HttpRequestQueue;
import com.mpush.client.MessageDispatcher;
import com.mpush.client.TcpConnection;
import com.mpush.handler.HttpProxyHandler;
import com.mpush.message.BindUserMessage;
import com.mpush.message.FastConnectMessage;
import com.mpush.message.HandshakeMessage;
import com.mpush.message.HttpRequestMessage;
import com.mpush.security.AesCipher;
import com.mpush.security.CipherBox;
import com.mpush.session.PersistentSession;
import com.mpush.util.Strings;
import com.mpush.util.thread.ExecutorManager;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;

public final class MPushClient
implements Client {
    private final AtomicReference<State> clientState = new AtomicReference<State>(State.Shutdown);
    private final MessageDispatcher receiver;
    private final TcpConnection connection;
    private final ClientConfig config;
    private final Logger logger;
    private int hbTimeoutTimes;
    private HttpRequestQueue requestQueue;

    MPushClient(ClientConfig config) {
        this.config = config;
        this.logger = config.getLogger();
        this.receiver = new MessageDispatcher();
        this.connection = new TcpConnection(this, this.receiver);
        if (config.isEnableHttpProxy()) {
            this.requestQueue = new HttpRequestQueue();
            this.receiver.register(Command.HTTP_PROXY, new HttpProxyHandler(this.requestQueue));
        }
    }

    @Override
    public void start() {
        if (this.clientState.compareAndSet(State.Shutdown, State.Started)) {
            this.connection.setAutoConnect(true);
            this.connection.connect();
            this.logger.w("do start client ...", new Object[0]);
        }
    }

    @Override
    public void stop() {
        this.logger.w("client shutdown !!!, state=%s", new Object[]{this.clientState.get()});
        if (this.clientState.compareAndSet(State.Started, State.Shutdown)) {
            this.connection.setAutoConnect(false);
            this.connection.close();
        }
    }

    @Override
    public void destroy() {
        if (this.clientState.get() != State.Destroyed) {
            this.stop();
            this.logger.w("client destroy !!!", new Object[0]);
            ExecutorManager.INSTANCE.shutdown();
            ClientConfig.I.destroy();
            this.clientState.set(State.Destroyed);
        }
    }

    @Override
    public boolean isRunning() {
        return this.clientState.get() == State.Started && this.connection.isConnected();
    }

    @Override
    public boolean healthCheck() {
        if (this.connection.isReadTimeout()) {
            ++this.hbTimeoutTimes;
            this.logger.w("heartbeat timeout times=%s", this.hbTimeoutTimes);
        } else {
            this.hbTimeoutTimes = 0;
        }
        if (this.hbTimeoutTimes >= 2) {
            this.logger.w("heartbeat timeout times=%d over limit=%d, client restart", this.hbTimeoutTimes, 2);
            this.hbTimeoutTimes = 0;
            this.connection.reconnect();
            return false;
        }
        if (this.connection.isWriteTimeout()) {
            this.logger.d("<<< send heartbeat ping...", new Object[0]);
            this.connection.send(Packet.HB_PACKET);
        }
        return true;
    }

    @Override
    public void fastConnect() {
        SessionStorage storage = this.config.getSessionStorage();
        if (storage == null) {
            this.handshake();
            return;
        }
        String ss = storage.getSession();
        if (Strings.isBlank(ss)) {
            this.handshake();
            return;
        }
        PersistentSession session = PersistentSession.decode(ss);
        if (session == null || session.isExpired()) {
            storage.clearSession();
            this.logger.w("fast connect failure session expired, session=%s", session);
            this.handshake();
            return;
        }
        FastConnectMessage message = new FastConnectMessage(this.connection);
        message.deviceId = this.config.getDeviceId();
        message.sessionId = session.sessionId;
        message.maxHeartbeat = this.config.getMaxHeartbeat();
        message.minHeartbeat = this.config.getMinHeartbeat();
        message.sendRaw();
        this.connection.getSessionContext().changeCipher(session.cipher);
        this.logger.w("<<< do fast connect, message=%s", message);
    }

    @Override
    public void handshake() {
        SessionContext context = this.connection.getSessionContext();
        context.changeCipher(CipherBox.INSTANCE.getRsaCipher());
        HandshakeMessage message = new HandshakeMessage(this.connection);
        message.clientKey = CipherBox.INSTANCE.randomAESKey();
        message.iv = CipherBox.INSTANCE.randomAESIV();
        message.deviceId = this.config.getDeviceId();
        message.osName = this.config.getOsName();
        message.osVersion = this.config.getOsVersion();
        message.clientVersion = this.config.getClientVersion();
        message.maxHeartbeat = this.config.getMaxHeartbeat();
        message.minHeartbeat = this.config.getMinHeartbeat();
        message.send();
        context.changeCipher(new AesCipher(message.clientKey, message.iv));
        this.logger.w("<<< do handshake, message=%s", message);
    }

    @Override
    public void bindUser(String userId) {
        if (Strings.isBlank(userId)) {
            this.logger.w("bind user is null", new Object[0]);
            return;
        }
        SessionContext context = this.connection.getSessionContext();
        if (userId.equals(context.bindUser)) {
            return;
        }
        context.setBindUser(userId);
        this.config.setUserId(userId);
        BindUserMessage.buildBind(this.connection).setUserId(userId).send();
        this.logger.w("<<< do bind user, userId=%s", userId);
    }

    @Override
    public void unbindUser() {
        String userId = this.config.getUserId();
        if (Strings.isBlank(userId)) {
            this.logger.w("unbind user is null", new Object[0]);
            return;
        }
        this.config.setUserId(null);
        this.connection.getSessionContext().setBindUser(null);
        BindUserMessage.buildUnbind(this.connection).setUserId(userId).send();
        this.logger.w("<<< do unbind user, userId=%s", userId);
    }

    @Override
    public Future<HttpResponse> sendHttp(HttpRequest request) {
        if (this.connection.getSessionContext().handshakeOk()) {
            HttpRequestMessage message = new HttpRequestMessage(this.connection);
            message.method = request.getMethod();
            message.uri = request.getUri();
            message.headers = request.getHeaders();
            message.body = request.getBody();
            message.send();
            this.logger.d("<<< send http proxy, request=%s", request);
            return this.requestQueue.add(message.getSessionId(), request);
        }
        return null;
    }

    public static enum State {
        Started,
        Shutdown,
        Destroyed;

    }
}

