/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.client;

import com.mpush.api.Client;
import com.mpush.api.ClientListener;
import com.mpush.api.Logger;
import com.mpush.api.connection.SessionStorage;
import com.mpush.client.DefaultClientListener;
import com.mpush.client.MPushClient;
import com.mpush.session.FileSessionStorage;
import com.mpush.util.DefaultLogger;

public final class ClientConfig {
    private final DefaultClientListener clientListener = new DefaultClientListener();
    public static ClientConfig I = new ClientConfig();
    private String allotServer;
    private String serverHost;
    private int serverPort;
    private String publicKey;
    private String deviceId;
    private String osName = "android";
    private String osVersion;
    private String clientVersion;
    private String userId;
    private int maxHeartbeat = 240000;
    private int minHeartbeat = 240000;
    private int aesKeyLength = 16;
    private int compressLimit = 1024;
    private SessionStorage sessionStorage;
    private String sessionStorageDir;
    private Logger logger;
    private boolean logEnabled;
    private boolean enableHttpProxy = true;
    private boolean enableClientPush = true;

    public static ClientConfig build() {
        I = new ClientConfig();
        return I;
    }

    public Client create() {
        return new MPushClient(this);
    }

    void destroy() {
        this.clientListener.setListener(null);
        I = new ClientConfig();
    }

    public SessionStorage getSessionStorage() {
        if (this.sessionStorage == null) {
            this.sessionStorage = new FileSessionStorage(this.sessionStorageDir);
        }
        return this.sessionStorage;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = new DefaultLogger();
        }
        return this.logger;
    }

    public ClientConfig setLogger(Logger logger) {
        this.logger = logger;
        this.getLogger().enable(this.logEnabled);
        return this;
    }

    public String getSessionStorageDir() {
        return this.sessionStorageDir;
    }

    public ClientConfig setSessionStorage(SessionStorage sessionStorage) {
        this.sessionStorage = sessionStorage;
        return this;
    }

    public ClientConfig setSessionStorageDir(String sessionStorageDir) {
        this.sessionStorageDir = sessionStorageDir;
        return this;
    }

    public String getAllotServer() {
        return this.allotServer;
    }

    public ClientConfig setAllotServer(String allotServer) {
        this.allotServer = allotServer;
        return this;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public ClientConfig setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public String getOsName() {
        return this.osName;
    }

    public ClientConfig setOsName(String osName) {
        this.osName = osName;
        return this;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public ClientConfig setOsVersion(String osVersion) {
        this.osVersion = osVersion;
        return this;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public ClientConfig setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
        return this;
    }

    public int getMaxHeartbeat() {
        return this.maxHeartbeat;
    }

    public ClientConfig setMaxHeartbeat(int maxHeartbeat) {
        this.maxHeartbeat = maxHeartbeat;
        return this;
    }

    public int getMinHeartbeat() {
        return this.minHeartbeat;
    }

    public ClientConfig setMinHeartbeat(int minHeartbeat) {
        this.minHeartbeat = minHeartbeat;
        return this;
    }

    public int getAesKeyLength() {
        return this.aesKeyLength;
    }

    public ClientConfig setAesKeyLength(int aesKeyLength) {
        this.aesKeyLength = aesKeyLength;
        return this;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public ClientConfig setPublicKey(String publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public int getCompressLimit() {
        return this.compressLimit;
    }

    public ClientConfig setCompressLimit(int compressLimit) {
        this.compressLimit = compressLimit;
        return this;
    }

    public ClientListener getClientListener() {
        return this.clientListener;
    }

    public ClientConfig setClientListener(ClientListener clientListener) {
        this.clientListener.setListener(clientListener);
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public ClientConfig setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public ClientConfig setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
        this.logger.enable(logEnabled);
        return this;
    }

    public boolean isEnableHttpProxy() {
        return this.enableHttpProxy;
    }

    public ClientConfig setEnableHttpProxy(boolean enableHttpProxy) {
        this.enableHttpProxy = enableHttpProxy;
        return this;
    }

    public String getServerHost() {
        return this.serverHost;
    }

    public ClientConfig setServerHost(String serverHost) {
        this.serverHost = serverHost;
        return this;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public ClientConfig setServerPort(int serverPort) {
        this.serverPort = serverPort;
        return this;
    }

    public boolean isEnableClientPush() {
        return this.enableClientPush;
    }

    public ClientConfig setEnableClientPush(boolean enableClientPush) {
        this.enableClientPush = enableClientPush;
        return this;
    }
}

