/*
 * Decompiled with CFR 0.152.
 */
package com.mwt.explorers;

import com.mwt.explorers.Explorer;
import com.mwt.misc.DecisionTuple;
import com.mwt.recorders.Recorder;
import com.mwt.utilities.MurMurHash3;

public class MwtExplorer<T> {
    private long appId;
    private Recorder<T> recorder;

    public MwtExplorer(String appId, Recorder<T> recorder) {
        this.appId = MurMurHash3.computeIdHash(appId);
        this.recorder = recorder;
    }

    public int chooseAction(Explorer<T> explorer, String uniqueKey, T context) {
        long seed = MurMurHash3.computeIdHash(uniqueKey);
        DecisionTuple decisionTuple = explorer.chooseAction(seed + this.appId, context);
        if (decisionTuple.shouldRecord()) {
            this.recorder.record(context, decisionTuple.getAction(), decisionTuple.getProbability(), uniqueKey);
        }
        return decisionTuple.getAction();
    }
}

