/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.com.github.javaparser.printer.lexicalpreservation;

import internal.nbbrd.service.com.github.javaparser.JavaToken;
import internal.nbbrd.service.com.github.javaparser.TokenTypes;
import internal.nbbrd.service.com.github.javaparser.ast.Node;
import internal.nbbrd.service.com.github.javaparser.ast.NodeList;
import internal.nbbrd.service.com.github.javaparser.ast.comments.Comment;
import internal.nbbrd.service.com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import internal.nbbrd.service.com.github.javaparser.ast.type.ArrayType;
import internal.nbbrd.service.com.github.javaparser.ast.type.ClassOrInterfaceType;
import internal.nbbrd.service.com.github.javaparser.ast.type.Type;
import internal.nbbrd.service.com.github.javaparser.printer.concretesyntaxmodel.CsmElement;
import internal.nbbrd.service.com.github.javaparser.printer.concretesyntaxmodel.CsmIndent;
import internal.nbbrd.service.com.github.javaparser.printer.concretesyntaxmodel.CsmUnindent;
import internal.nbbrd.service.com.github.javaparser.printer.lexicalpreservation.Added;
import internal.nbbrd.service.com.github.javaparser.printer.lexicalpreservation.ChildTextElement;
import internal.nbbrd.service.com.github.javaparser.printer.lexicalpreservation.DifferenceElement;
import internal.nbbrd.service.com.github.javaparser.printer.lexicalpreservation.Kept;
import internal.nbbrd.service.com.github.javaparser.printer.lexicalpreservation.LexicalDifferenceCalculator;
import internal.nbbrd.service.com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import internal.nbbrd.service.com.github.javaparser.printer.lexicalpreservation.NodeText;
import internal.nbbrd.service.com.github.javaparser.printer.lexicalpreservation.Removed;
import internal.nbbrd.service.com.github.javaparser.printer.lexicalpreservation.RemovedGroup;
import internal.nbbrd.service.com.github.javaparser.printer.lexicalpreservation.ReshuffledDiffElementExtractor;
import internal.nbbrd.service.com.github.javaparser.printer.lexicalpreservation.TextElement;
import internal.nbbrd.service.com.github.javaparser.printer.lexicalpreservation.TokenTextElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;

public class Difference {
    public static final int STANDARD_INDENTATION_SIZE = 4;
    private final NodeText nodeText;
    private final Node node;
    private final List<DifferenceElement> diffElements;
    private final List<TextElement> originalElements;
    private int originalIndex = 0;
    private int diffIndex = 0;
    private final List<TextElement> indentation;
    private boolean addedIndentation = false;

    Difference(List<DifferenceElement> diffElements, NodeText nodeText, Node node) {
        if (nodeText == null) {
            throw new NullPointerException("nodeText can not be null");
        }
        this.nodeText = nodeText;
        this.node = node;
        this.diffElements = diffElements;
        this.originalElements = nodeText.getElements();
        this.indentation = LexicalPreservingPrinter.findIndentation(node);
    }

    List<TextElement> processIndentation(List<TextElement> indentation, List<TextElement> prevElements) {
        int eolIndex = this.lastIndexOfEol(prevElements);
        if (eolIndex < 0) {
            return indentation;
        }
        indentation = this.takeWhile(prevElements.subList(eolIndex + 1, prevElements.size()), element -> element.isWhiteSpace());
        return indentation;
    }

    List<TextElement> takeWhile(List<TextElement> prevElements, Predicate<TextElement> predicate) {
        ArrayList<TextElement> spaces = new ArrayList<TextElement>();
        for (TextElement element : prevElements) {
            if (!predicate.test(element)) break;
            spaces.add(element);
        }
        return spaces;
    }

    int lastIndexOfEol(List<TextElement> source) {
        return IntStream.range(0, source.size()).map(i -> source.size() - i - 1).filter(i -> ((TextElement)source.get(i)).isNewline()).findFirst().orElse(-1);
    }

    private int posOfNextComment(int fromIndex, List<TextElement> elements) {
        if (!this.isValidIndex(fromIndex, elements)) {
            return -1;
        }
        ArrayIterator<TextElement> iterator = new ArrayIterator<TextElement>(elements, fromIndex);
        while (iterator.hasNext()) {
            TextElement element = iterator.next();
            if (element.isSpaceOrTab()) continue;
            if (!element.isComment()) break;
            return iterator.index();
        }
        return -1;
    }

    private boolean isFollowedByComment(int fromIndex, List<TextElement> elements) {
        return this.posOfNextComment(fromIndex, elements) != -1;
    }

    private void removeElements(int fromIndex, int toIndex, List<TextElement> elements) {
        if (!this.isValidIndex(fromIndex, elements) || !this.isValidIndex(toIndex, elements) || fromIndex > toIndex) {
            return;
        }
        ListIterator<TextElement> iterator = elements.listIterator(fromIndex);
        for (int count = fromIndex; iterator.hasNext() && count <= toIndex; ++count) {
            iterator.next();
            iterator.remove();
        }
    }

    private boolean isValidIndex(int index, List<?> elements) {
        return index >= 0 && index <= elements.size();
    }

    int lastIndexOfEolWithoutGPT(List<TextElement> source) {
        ListIterator<TextElement> listIterator = source.listIterator(source.size());
        int lastIndex = source.size() - 1;
        while (listIterator.hasPrevious()) {
            TextElement elem = listIterator.previous();
            if (elem.isNewline()) {
                return lastIndex;
            }
            --lastIndex;
        }
        return -1;
    }

    private List<TextElement> indentationBlock() {
        LinkedList<TextElement> res = new LinkedList<TextElement>();
        res.add(new TokenTextElement(1));
        res.add(new TokenTextElement(1));
        res.add(new TokenTextElement(1));
        res.add(new TokenTextElement(1));
        return res;
    }

    private boolean isAfterLBrace(NodeText nodeText, int nodeTextIndex) {
        if (nodeTextIndex > 0 && nodeText.getTextElement(nodeTextIndex - 1).isToken(102)) {
            return true;
        }
        if (nodeTextIndex > 0 && nodeText.getTextElement(nodeTextIndex - 1).isSpaceOrTab()) {
            return this.isAfterLBrace(nodeText, nodeTextIndex - 1);
        }
        return false;
    }

    int considerEnforcingIndentation(NodeText nodeText, int nodeTextIndex) {
        return this.considerIndentation(nodeText, nodeTextIndex, this.indentation.size());
    }

    private int considerRemovingIndentation(NodeText nodeText, int nodeTextIndex) {
        return this.considerIndentation(nodeText, nodeTextIndex, 0);
    }

    private int considerIndentation(NodeText nodeText, int nodeTextIndex, int numberOfCharactersToPreserve) {
        EnforcingIndentationContext enforcingIndentationContext = this.defineEnforcingIndentationContext(nodeText, nodeTextIndex);
        int res = nodeTextIndex;
        if (enforcingIndentationContext.extraCharacters > 0) {
            int extraCharacters = enforcingIndentationContext.extraCharacters > numberOfCharactersToPreserve ? enforcingIndentationContext.extraCharacters - numberOfCharactersToPreserve : 0;
            res = this.removeExtraCharacters(nodeText, enforcingIndentationContext.start, extraCharacters);
            int n = res = extraCharacters > 0 ? res + numberOfCharactersToPreserve : res;
        }
        if (res < 0) {
            throw new IllegalStateException();
        }
        return res;
    }

    private boolean isEnforcingIndentationActivable(RemovedGroup removedGroup) {
        return (this.isLastElement(this.diffElements, this.diffIndex) || !this.nextDiffElement(this.diffElements, this.diffIndex).isAdded()) && this.originalIndex < this.originalElements.size() && !removedGroup.isACompleteLine();
    }

    private boolean isRemovingIndentationActivable(RemovedGroup removedGroup) {
        return (this.isLastElement(this.diffElements, this.diffIndex) || !this.nextDiffElement(this.diffElements, this.diffIndex).isAdded()) && this.originalIndex < this.originalElements.size() && removedGroup.isACompleteLine();
    }

    private boolean isLastElement(List<?> list, int index) {
        return index + 1 >= list.size();
    }

    private DifferenceElement nextDiffElement(List<DifferenceElement> list, int index) {
        return list.get(index + 1);
    }

    private int removeExtraCharacters(NodeText nodeText, int nodeTextIndex, int extraCharacters) {
        for (int count = 0; nodeTextIndex >= 0 && nodeTextIndex < nodeText.numberOfElements() && count < extraCharacters; ++count) {
            nodeText.removeElement(nodeTextIndex);
        }
        return nodeTextIndex;
    }

    private EnforcingIndentationContext defineEnforcingIndentationContext(NodeText nodeText, int startIndex) {
        int i;
        EnforcingIndentationContext ctx = new EnforcingIndentationContext(startIndex);
        if (startIndex < nodeText.numberOfElements() && startIndex > 0) {
            i = startIndex - 1;
            while (i >= 0 && i < nodeText.numberOfElements() && !nodeText.getTextElement(i).isNewline()) {
                if (!this.isSpaceOrTabElement(nodeText, i)) {
                    ctx = new EnforcingIndentationContext(startIndex);
                    break;
                }
                ctx.start = i--;
                ++ctx.extraCharacters;
            }
        }
        if (startIndex < nodeText.numberOfElements() && this.isSpaceOrTabElement(nodeText, startIndex)) {
            for (i = startIndex; i >= 0 && i < nodeText.numberOfElements() && !nodeText.getTextElement(i).isNewline() && this.isSpaceOrTabElement(nodeText, i); ++i) {
                ++ctx.extraCharacters;
            }
        }
        return ctx;
    }

    private boolean isSpaceOrTabElement(NodeText nodeText, int i) {
        return nodeText.getTextElement(i).isSpaceOrTab();
    }

    void apply() {
        ReshuffledDiffElementExtractor.of(this.nodeText).extract(this.diffElements);
        Map<Removed, RemovedGroup> removedGroups = this.combineRemovedElementsToRemovedGroups();
        do {
            boolean isLeftOverDiffElement = this.applyLeftOverDiffElements();
            boolean isLeftOverOriginalElement = this.applyLeftOverOriginalElements();
            if (isLeftOverDiffElement || isLeftOverOriginalElement) continue;
            DifferenceElement diffElement = this.diffElements.get(this.diffIndex);
            if (diffElement.isAdded()) {
                this.applyAddedDiffElement((Added)diffElement);
                continue;
            }
            TextElement originalElement = this.originalElements.get(this.originalIndex);
            boolean originalElementIsChild = originalElement instanceof ChildTextElement;
            boolean originalElementIsToken = originalElement instanceof TokenTextElement;
            if (diffElement.isKept()) {
                this.applyKeptDiffElement((Kept)diffElement, originalElement, originalElementIsChild, originalElementIsToken);
                continue;
            }
            if (diffElement.isRemoved()) {
                Removed removed = (Removed)diffElement;
                this.applyRemovedDiffElement(removedGroups.get(removed), removed, originalElement, originalElementIsChild, originalElementIsToken);
                continue;
            }
            throw new UnsupportedOperationException("Unable to apply operations from " + diffElement.getClass().getSimpleName() + " to " + originalElement.getClass().getSimpleName());
        } while (this.diffIndex < this.diffElements.size() || this.originalIndex < this.originalElements.size());
    }

    private boolean applyLeftOverOriginalElements() {
        boolean isLeftOverElement = false;
        if (this.diffIndex >= this.diffElements.size() && this.originalIndex < this.originalElements.size()) {
            TextElement originalElement = this.originalElements.get(this.originalIndex);
            if (originalElement.isWhiteSpaceOrComment()) {
                ++this.originalIndex;
            } else {
                throw new UnsupportedOperationException("NodeText: " + this.nodeText + ". Difference: " + this + " " + originalElement);
            }
            isLeftOverElement = true;
        }
        return isLeftOverElement;
    }

    private boolean applyLeftOverDiffElements() {
        boolean isLeftOverElement = false;
        if (this.diffIndex < this.diffElements.size() && this.originalIndex >= this.originalElements.size()) {
            DifferenceElement diffElement = this.diffElements.get(this.diffIndex);
            if (diffElement.isKept()) {
                ++this.diffIndex;
            } else if (diffElement.isAdded()) {
                Added addedElement = (Added)diffElement;
                this.nodeText.addElement(this.originalIndex, addedElement.toTextElement());
                ++this.originalIndex;
                ++this.diffIndex;
            } else {
                ++this.diffIndex;
            }
            isLeftOverElement = true;
        }
        return isLeftOverElement;
    }

    private Map<Removed, RemovedGroup> combineRemovedElementsToRemovedGroups() {
        Map<Integer, List<Removed>> removedElementsMap = this.groupConsecutiveRemovedElements();
        ArrayList<RemovedGroup> removedGroups = new ArrayList<RemovedGroup>();
        for (Map.Entry<Integer, List<Removed>> entry : removedElementsMap.entrySet()) {
            removedGroups.add(RemovedGroup.of(entry.getKey(), entry.getValue()));
        }
        HashMap<Removed, RemovedGroup> map = new HashMap<Removed, RemovedGroup>();
        for (RemovedGroup removedGroup : removedGroups) {
            for (Removed index : removedGroup) {
                map.put(index, removedGroup);
            }
        }
        return map;
    }

    private Map<Integer, List<Removed>> groupConsecutiveRemovedElements() {
        HashMap<Integer, List<Removed>> removedElementsMap = new HashMap<Integer, List<Removed>>();
        Integer firstElement = null;
        for (int i = 0; i < this.diffElements.size(); ++i) {
            DifferenceElement diffElement = this.diffElements.get(i);
            if (diffElement.isRemoved()) {
                if (firstElement == null) {
                    firstElement = i;
                }
                removedElementsMap.computeIfAbsent(firstElement, key -> new ArrayList()).add((Removed)diffElement);
                continue;
            }
            firstElement = null;
        }
        return removedElementsMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyRemovedDiffElement(RemovedGroup removedGroup, Removed removed, TextElement originalElement, boolean originalElementIsChild, boolean originalElementIsToken) {
        if (removed.isChild() && originalElementIsChild) {
            ChildTextElement originalElementChild = (ChildTextElement)originalElement;
            if (originalElementChild.isComment()) {
                Comment comment = (Comment)originalElementChild.getChild();
                if (!comment.isOrphan() && comment.getCommentedNode().isPresent() && comment.getCommentedNode().get().equals(removed.getChild())) {
                    this.nodeText.removeElement(this.originalIndex);
                } else {
                    ++this.originalIndex;
                }
            } else {
                this.nodeText.removeElement(this.originalIndex);
                if (this.isEnforcingIndentationActivable(removedGroup)) {
                    this.originalIndex = this.considerEnforcingIndentation(this.nodeText, this.originalIndex);
                }
                if (this.originalElements.size() > this.originalIndex && this.originalIndex > 0 && this.originalElements.get(this.originalIndex).isWhiteSpace() && this.originalElements.get(this.originalIndex - 1).isWhiteSpace() && (this.diffIndex + 1 == this.diffElements.size() || this.diffElements.get(this.diffIndex + 1).isKept())) {
                    this.originalElements.remove(this.originalIndex--);
                }
                if (this.isFollowedByComment(this.originalIndex, this.originalElements)) {
                    int indexOfNextComment = this.posOfNextComment(this.originalIndex, this.originalElements);
                    this.removeElements(this.originalIndex, indexOfNextComment, this.originalElements);
                }
                if (this.isRemovingIndentationActivable(removedGroup)) {
                    this.originalIndex = this.considerRemovingIndentation(this.nodeText, this.originalIndex);
                }
                ++this.diffIndex;
            }
        } else if (removed.isChild() && originalElement.isComment()) {
            this.nodeText.removeElement(this.originalIndex);
            if (this.isRemovingIndentationActivable(removedGroup)) {
                this.originalIndex = this.considerRemovingIndentation(this.nodeText, this.originalIndex);
            }
        } else if (removed.isToken() && originalElementIsToken && (removed.getTokenType() == ((TokenTextElement)originalElement).getTokenKind() || ((TokenTextElement)originalElement).getToken().getCategory().isEndOfLine() && removed.isNewLine())) {
            this.nodeText.removeElement(this.originalIndex);
            ++this.diffIndex;
        } else if ((removed.isWhiteSpaceNotEol() || removed.getElement() instanceof CsmIndent || removed.getElement() instanceof CsmUnindent) && originalElement.isSpaceOrTab()) {
            this.nodeText.removeElement(this.originalIndex);
        } else if (originalElementIsToken && originalElement.isWhiteSpaceOrComment()) {
            ++this.originalIndex;
            if (removed.isNewLine()) {
                ++this.diffIndex;
            }
        } else if (originalElement.isLiteral()) {
            this.nodeText.removeElement(this.originalIndex);
            ++this.diffIndex;
        } else if (removed.isPrimitiveType()) {
            if (!originalElement.isPrimitive()) throw new UnsupportedOperationException("removed " + removed.getElement() + " vs " + originalElement);
            this.nodeText.removeElement(this.originalIndex);
            ++this.diffIndex;
        } else if (removed.isWhiteSpace() || removed.getElement() instanceof CsmIndent || removed.getElement() instanceof CsmUnindent) {
            ++this.diffIndex;
        } else if (originalElement.isWhiteSpace()) {
            ++this.originalIndex;
        } else {
            if (!removed.isChild()) throw new UnsupportedOperationException("removed " + removed.getElement() + " vs " + originalElement);
            this.nodeText.removeElement(this.originalIndex);
            ++this.diffIndex;
        }
        this.cleanTheLineOfLeftOverSpace(removedGroup, removed);
    }

    private void cleanTheLineOfLeftOverSpace(RemovedGroup removedGroup, Removed removed) {
        if (this.originalIndex >= this.originalElements.size()) {
            return;
        }
        if (!removedGroup.isProcessed() && removedGroup.isLastElement(removed) && removedGroup.isACompleteLine() && !removed.isNewLine()) {
            Integer lastElementIndex = removedGroup.getLastElementIndex();
            Optional<Integer> indentation = removedGroup.getIndentation();
            if (indentation.isPresent() && !this.isReplaced(lastElementIndex)) {
                for (int i = 0; i < indentation.get(); ++i) {
                    int n;
                    if (this.originalElements.get(this.originalIndex).isSpaceOrTab()) {
                        this.nodeText.removeElement(this.originalIndex);
                    } else if (this.originalIndex >= 1 && this.originalElements.get(this.originalIndex - 1).isSpaceOrTab()) {
                        this.nodeText.removeElement(this.originalIndex - 1);
                        --this.originalIndex;
                    }
                    if (!this.nodeText.getTextElement(this.originalIndex).isNewline()) continue;
                    this.nodeText.removeElement(this.originalIndex);
                    if (this.originalIndex > 0) {
                        int n2 = this.originalIndex;
                        n = n2;
                        this.originalIndex = n2 - 1;
                    } else {
                        n = 0;
                    }
                    this.originalIndex = n;
                }
            }
            removedGroup.processed();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void applyKeptDiffElement(Kept kept, TextElement originalElement, boolean originalElementIsChild, boolean originalElementIsToken) {
        if (originalElement.isComment()) {
            ++this.originalIndex;
            return;
        } else if (kept.isChild() && ((LexicalDifferenceCalculator.CsmChild)kept.getElement()).getChild() instanceof Comment) {
            ++this.diffIndex;
            return;
        } else if (kept.isChild() && originalElementIsChild) {
            ++this.diffIndex;
            ++this.originalIndex;
            return;
        } else if (kept.isChild() && originalElementIsToken) {
            if (originalElement.isWhiteSpaceOrComment()) {
                ++this.originalIndex;
                return;
            } else if (originalElement.isIdentifier() && this.isNodeWithTypeArguments(kept)) {
                ++this.diffIndex;
                int step = this.getIndexToNextTokenElement((TokenTextElement)originalElement, 0);
                this.originalIndex += step;
                ++this.originalIndex;
                return;
            } else if (originalElement.isIdentifier() && this.isTypeWithFullyQualifiedName(kept)) {
                ++this.diffIndex;
                int step = this.getIndexToNextTokenElement((TokenTextElement)originalElement, kept);
                this.originalIndex += step;
                ++this.originalIndex;
                return;
            } else if ((originalElement.isIdentifier() || originalElement.isKeyword()) && this.isArrayType(kept)) {
                int tokenToSkip = this.getIndexToNextTokenElementInArrayType((TokenTextElement)originalElement, this.getArrayLevel(kept));
                ++this.diffIndex;
                this.originalIndex += tokenToSkip;
                ++this.originalIndex;
                return;
            } else if (originalElement.isIdentifier()) {
                ++this.originalIndex;
                ++this.diffIndex;
                return;
            } else {
                if (!kept.isPrimitiveType()) throw new UnsupportedOperationException("kept " + kept.getElement() + " vs " + originalElement);
                ++this.originalIndex;
                ++this.diffIndex;
            }
            return;
        } else if (kept.isToken() && originalElementIsToken) {
            TokenTextElement originalTextToken = (TokenTextElement)originalElement;
            if (kept.getTokenType() == originalTextToken.getTokenKind()) {
                ++this.originalIndex;
                ++this.diffIndex;
                return;
            } else if (kept.isNewLine() && originalTextToken.isNewline()) {
                ++this.originalIndex;
                ++this.diffIndex;
                return;
            } else if (kept.isNewLine() && originalTextToken.isSpaceOrTab()) {
                ++this.originalIndex;
                return;
            } else if (kept.isWhiteSpaceOrComment()) {
                ++this.diffIndex;
                return;
            } else if (originalTextToken.isWhiteSpaceOrComment()) {
                ++this.originalIndex;
                return;
            } else {
                if (kept.isNewLine() || !originalTextToken.isSeparator()) throw new UnsupportedOperationException("Csm token " + kept.getElement() + " NodeText TOKEN " + originalTextToken);
                ++this.originalIndex;
            }
            return;
        } else if (kept.isToken() && originalElementIsChild) {
            ++this.diffIndex;
            return;
        } else if (kept.isWhiteSpace()) {
            ++this.diffIndex;
            return;
        } else if (kept.isIndent()) {
            ++this.diffIndex;
            return;
        } else {
            if (!kept.isUnindent()) throw new UnsupportedOperationException("kept " + kept.getElement() + " vs " + originalElement);
            ++this.diffIndex;
        }
    }

    private int getArrayLevel(DifferenceElement element) {
        CsmElement csmElem = element.getElement();
        if (this.isArrayType(element)) {
            Node child = ((LexicalDifferenceCalculator.CsmChild)csmElem).getChild();
            return ((ArrayType)child).getArrayLevel();
        }
        return 0;
    }

    private boolean isArrayType(DifferenceElement element) {
        CsmElement csmElem = element.getElement();
        return csmElem instanceof LexicalDifferenceCalculator.CsmChild && ((LexicalDifferenceCalculator.CsmChild)csmElem).getChild() instanceof ArrayType;
    }

    private boolean isTypeWithFullyQualifiedName(DifferenceElement element) {
        if (!element.isChild()) {
            return false;
        }
        LexicalDifferenceCalculator.CsmChild child = (LexicalDifferenceCalculator.CsmChild)element.getElement();
        if (!ClassOrInterfaceType.class.isAssignableFrom(child.getChild().getClass())) {
            return false;
        }
        return ((ClassOrInterfaceType)child.getChild()).getScope().isPresent();
    }

    private boolean isNodeWithTypeArguments(DifferenceElement element) {
        if (!element.isChild()) {
            return false;
        }
        LexicalDifferenceCalculator.CsmChild child = (LexicalDifferenceCalculator.CsmChild)element.getElement();
        if (!NodeWithTypeArguments.class.isAssignableFrom(child.getChild().getClass())) {
            return false;
        }
        Optional<NodeList<Type>> typeArgs = ((NodeWithTypeArguments)((Object)child.getChild())).getTypeArguments();
        return typeArgs.isPresent() && typeArgs.get().size() > 0;
    }

    private int getIndexToNextTokenElement(TokenTextElement element, DifferenceElement kept) {
        int step = 0;
        if (!this.isTypeWithFullyQualifiedName(kept)) {
            return 0;
        }
        LexicalDifferenceCalculator.CsmChild child = (LexicalDifferenceCalculator.CsmChild)kept.getElement();
        String[] parts = ((ClassOrInterfaceType)child.getChild()).getNameWithScope().split("\\.");
        JavaToken token = element.getToken();
        for (String part : parts) {
            if (part.equals(token.asString())) {
                if (!(token = token.getNextToken().get()).asString().equals(".")) break;
                token = token.getNextToken().get();
                step += 2;
                continue;
            }
            step = 0;
            break;
        }
        return step;
    }

    private int getIndexToNextTokenElement(TokenTextElement element, int nestedDiamondOperator) {
        int step = 0;
        Optional<JavaToken> next = element.getToken().getNextToken();
        if (!next.isPresent()) {
            return step;
        }
        ++step;
        JavaToken nextToken = next.get();
        JavaToken.Kind kind = JavaToken.Kind.valueOf(nextToken.getKind());
        if (this.isDiamondOperator(kind)) {
            nestedDiamondOperator = JavaToken.Kind.GT.equals((Object)kind) ? --nestedDiamondOperator : ++nestedDiamondOperator;
        }
        if (nestedDiamondOperator == 0 && !nextToken.getCategory().isWhitespace()) {
            return step;
        }
        return step += this.getIndexToNextTokenElement(new TokenTextElement(nextToken), nestedDiamondOperator);
    }

    private int getIndexToNextTokenElementInArrayType(TokenTextElement element, int arrayLevel) {
        int step = 0;
        Optional<JavaToken> next = element.getToken().getNextToken();
        if (!next.isPresent()) {
            return step;
        }
        ++step;
        JavaToken nextToken = next.get();
        JavaToken.Kind kind = JavaToken.Kind.valueOf(nextToken.getKind());
        if (this.isBracket(kind) && JavaToken.Kind.RBRACKET.equals((Object)kind)) {
            --arrayLevel;
        }
        if (arrayLevel == 0 && !nextToken.getCategory().isWhitespace()) {
            return step;
        }
        return step += this.getIndexToNextTokenElementInArrayType(new TokenTextElement(nextToken), arrayLevel);
    }

    private boolean isDiamondOperator(JavaToken.Kind kind) {
        return JavaToken.Kind.GT.equals((Object)kind) || JavaToken.Kind.LT.equals((Object)kind);
    }

    private boolean isBracket(JavaToken.Kind kind) {
        return JavaToken.Kind.LBRACKET.equals((Object)kind) || JavaToken.Kind.RBRACKET.equals((Object)kind);
    }

    private boolean nextIsRightBrace(int index) {
        List<TextElement> elements = this.originalElements.subList(index, this.originalElements.size());
        for (TextElement element : elements) {
            if (element.isSpaceOrTab()) continue;
            return element.isToken(103);
        }
        return false;
    }

    private void applyAddedDiffElement(Added added) {
        boolean nextIsRightBrace;
        boolean isPreviousElementNewline;
        if (added.isIndent()) {
            for (int i = 0; i < 4; ++i) {
                this.indentation.add(new TokenTextElement(1));
            }
            this.addedIndentation = true;
            ++this.diffIndex;
            return;
        }
        if (added.isUnindent()) {
            for (int i = 0; i < 4 && !this.indentation.isEmpty(); ++i) {
                this.indentation.remove(this.indentation.size() - 1);
            }
            this.addedIndentation = false;
            ++this.diffIndex;
            return;
        }
        TextElement addedTextElement = added.toTextElement();
        boolean used = false;
        boolean bl = isPreviousElementNewline = this.originalIndex > 0 && this.originalElements.get(this.originalIndex - 1).isNewline();
        if (isPreviousElementNewline) {
            Iterator<TextElement> elements = this.processIndentation(this.indentation, this.originalElements.subList(0, this.originalIndex - 1));
            nextIsRightBrace = this.nextIsRightBrace(this.originalIndex);
            Iterator<TextElement> iterator = elements.iterator();
            while (iterator.hasNext()) {
                TextElement e = iterator.next();
                if (!nextIsRightBrace && e instanceof TokenTextElement && this.originalElements.get(this.originalIndex).isToken(((TokenTextElement)e).getTokenKind())) {
                    ++this.originalIndex;
                    continue;
                }
                this.nodeText.addElement(this.originalIndex++, e);
            }
        } else if (this.isAfterLBrace(this.nodeText, this.originalIndex) && !this.isAReplacement(this.diffIndex)) {
            if (addedTextElement.isNewline()) {
                used = true;
            }
            this.nodeText.addElement(this.originalIndex++, new TokenTextElement(TokenTypes.eolTokenKind()));
            while (this.originalIndex >= 2 && this.originalElements.get(this.originalIndex - 2).isSpaceOrTab()) {
                this.originalElements.remove(this.originalIndex - 2);
                --this.originalIndex;
            }
            for (TextElement e : this.processIndentation(this.indentation, this.originalElements.subList(0, this.originalIndex - 1))) {
                this.nodeText.addElement(this.originalIndex++, e);
            }
            if (!this.addedIndentation) {
                for (TextElement e : this.indentationBlock()) {
                    this.nodeText.addElement(this.originalIndex++, e);
                }
            }
        }
        if (!used) {
            boolean commentIsBeforeAddedElement;
            boolean sufficientTokensRemainToSkip = this.nodeText.numberOfElements() > this.originalIndex + 2;
            boolean currentIsAComment = this.nodeText.getTextElement(this.originalIndex).isComment();
            boolean previousIsAComment = this.originalIndex > 0 && this.nodeText.getTextElement(this.originalIndex - 1).isComment();
            boolean currentIsNewline = this.nodeText.getTextElement(this.originalIndex).isNewline();
            boolean isFirstElement = this.originalIndex == 0;
            boolean previousIsWhiteSpace = this.originalIndex > 0 && this.nodeText.getTextElement(this.originalIndex - 1).isWhiteSpace();
            boolean bl2 = commentIsBeforeAddedElement = currentIsAComment && addedTextElement.getRange().isPresent() && this.nodeText.getTextElement(this.originalIndex).getRange().map(range -> range.isBefore(addedTextElement.getRange().get())).orElse(false) != false;
            if (sufficientTokensRemainToSkip && currentIsAComment && commentIsBeforeAddedElement) {
                this.originalIndex += 2;
                this.nodeText.addElement(this.originalIndex, addedTextElement);
                this.originalIndex = this.adjustIndentation(this.indentation, this.nodeText, this.originalIndex, false);
                ++this.originalIndex;
            } else if (currentIsNewline && previousIsAComment) {
                ++this.originalIndex;
                this.originalIndex = this.adjustIndentation(this.indentation, this.nodeText, this.originalIndex, false);
                this.nodeText.addElement(this.originalIndex, addedTextElement);
                ++this.originalIndex;
            } else if (currentIsNewline && addedTextElement.isChild()) {
                if (!(isPreviousElementNewline || isFirstElement || previousIsWhiteSpace)) {
                    ++this.originalIndex;
                    this.originalIndex = this.adjustIndentation(this.indentation, this.nodeText, this.originalIndex, false);
                }
                this.nodeText.addElement(this.originalIndex, addedTextElement);
                ++this.originalIndex;
            } else {
                this.nodeText.addElement(this.originalIndex, addedTextElement);
                ++this.originalIndex;
            }
        }
        if (addedTextElement.isNewline()) {
            boolean followedByUnindent = this.isFollowedByUnindent(this.diffElements, this.diffIndex);
            nextIsRightBrace = this.nextIsRightBrace(this.originalIndex);
            boolean nextIsNewLine = this.originalElements.get(this.originalIndex).isNewline();
            if (!nextIsNewLine && !nextIsRightBrace || followedByUnindent) {
                this.originalIndex = this.adjustIndentation(this.indentation, this.nodeText, this.originalIndex, followedByUnindent);
            }
        }
        ++this.diffIndex;
    }

    private boolean isFollowedByUnindent(List<DifferenceElement> diffElements, int diffIndex) {
        int nextIndexValue = diffIndex + 1;
        return nextIndexValue < diffElements.size() && diffElements.get(nextIndexValue).isAdded() && diffElements.get(nextIndexValue).getElement() instanceof CsmUnindent;
    }

    private int adjustIndentation(List<TextElement> indentation, NodeText nodeText, int nodeTextIndex, boolean followedByUnindent) {
        List<TextElement> indentationAdj = this.processIndentation(indentation, nodeText.getElements().subList(0, nodeTextIndex - 1));
        if (nodeTextIndex < nodeText.numberOfElements() && nodeText.getTextElement(nodeTextIndex).isToken(103)) {
            indentationAdj = indentationAdj.subList(0, indentationAdj.size() - Math.min(4, indentationAdj.size()));
        } else if (followedByUnindent) {
            indentationAdj = indentationAdj.subList(0, Math.max(0, indentationAdj.size() - 4));
        }
        for (TextElement e : indentationAdj) {
            if (nodeTextIndex < nodeText.numberOfElements() && nodeText.getTextElement(nodeTextIndex).isSpaceOrTab()) {
                ++nodeTextIndex;
                continue;
            }
            nodeText.getElements().add(nodeTextIndex++, e);
        }
        if (nodeTextIndex < 0) {
            throw new IllegalStateException();
        }
        return nodeTextIndex;
    }

    private boolean isAReplacement(int diffIndex) {
        return diffIndex > 0 && this.diffElements.get(diffIndex).isAdded() && this.diffElements.get(diffIndex - 1).isRemoved();
    }

    private boolean isReplaced(int diffIndex) {
        return diffIndex < this.diffElements.size() - 1 && this.diffElements.get(diffIndex + 1).isAdded() && this.diffElements.get(diffIndex).isRemoved();
    }

    public String toString() {
        return "Difference{" + this.diffElements + '}';
    }

    public static class ArrayIterator<T>
    implements ListIterator<T> {
        ListIterator<T> iterator;

        public ArrayIterator(List<T> elements) {
            this(elements, 0);
        }

        public ArrayIterator(List<T> elements, int index) {
            this.iterator = elements.listIterator(index);
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public T previous() {
            return this.iterator.previous();
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        public int index() {
            return this.iterator.nextIndex() - 1;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public void set(T e) {
            this.iterator.set(e);
        }

        @Override
        public void add(T e) {
            this.iterator.add(e);
        }
    }

    private class EnforcingIndentationContext {
        int start;
        int extraCharacters;

        public EnforcingIndentationContext(int start) {
            this(start, 0);
        }

        public EnforcingIndentationContext(int start, int extraCharacters) {
            this.start = start;
            this.extraCharacters = extraCharacters;
        }
    }
}

