/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.definition;

import internal.nbbrd.service.ExtEnvironment;
import internal.nbbrd.service.com.github.mustachejava.DefaultMustacheFactory;
import internal.nbbrd.service.com.squareup.javapoet.ClassName;
import internal.nbbrd.service.definition.Lifecycle;
import internal.nbbrd.service.definition.TypeInstantiator;
import internal.nbbrd.service.definition.TypeWrapper;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.service.Quantifier;

final class LoadDefinition {
    @NonNull
    private final Quantifier quantifier;
    @NonNull
    private final Lifecycle lifecycle;
    @NonNull
    private final ClassName serviceType;
    @NonNull
    private final Optional<TypeInstantiator> fallback;
    private final boolean noFallback;
    @NonNull
    private final Optional<TypeWrapper> wrapper;
    @NonNull
    private final Optional<TypeInstantiator> preprocessor;
    @NonNull
    private final String loaderName;
    @NonNull
    private final Optional<TypeInstantiator> backend;
    @NonNull
    private final Optional<TypeInstantiator> cleaner;
    private final boolean batch;
    @NonNull
    private final String batchName;
    @NonNull
    private final Optional<TypeMirror> batchType;
    public static final String NO_NAME = "";

    public @org.checkerframework.checker.nullness.qual.NonNull ClassName resolveLoaderName() {
        return LoadDefinition.resolveName(this.loaderName, this.serviceType, "Loader");
    }

    public @org.checkerframework.checker.nullness.qual.NonNull ClassName resolveBatchName() {
        return LoadDefinition.resolveName(this.batchName, this.serviceType, "Batch");
    }

    static ClassName resolveName(String classNameString, ClassName serviceType, String defaultSuffix) {
        return NO_NAME.equals(classNameString) ? LoadDefinition.generateName(serviceType, defaultSuffix) : LoadDefinition.parseName(classNameString, serviceType);
    }

    private static ClassName parseName(String classNameString, ClassName serviceType) {
        StringWriter writer = new StringWriter();
        new DefaultMustacheFactory().compile(new StringReader(classNameString), NO_NAME).execute((Writer)writer, serviceType);
        return ClassName.bestGuess(writer.toString());
    }

    private static ClassName generateName(ClassName serviceType, String defaultSuffix) {
        ClassName top = serviceType.topLevelClassName();
        ClassName topLoader = ClassName.get(top.packageName(), top.simpleName() + defaultSuffix, new String[0]);
        if (top.equals(serviceType)) {
            return topLoader;
        }
        return topLoader.nestedClass(serviceType.simpleName());
    }

    static @org.checkerframework.checker.nullness.qual.NonNull TypeMirror getPreprocessorType(@org.checkerframework.checker.nullness.qual.NonNull ExtEnvironment env, @org.checkerframework.checker.nullness.qual.NonNull TypeMirror service) {
        Types types = env.getTypeUtils();
        DeclaredType streamOf = types.getDeclaredType(env.asTypeElement(Stream.class), service);
        return types.getDeclaredType(env.asTypeElement(UnaryOperator.class), streamOf);
    }

    static @org.checkerframework.checker.nullness.qual.NonNull TypeMirror getBackendType(@org.checkerframework.checker.nullness.qual.NonNull ExtEnvironment env, @org.checkerframework.checker.nullness.qual.NonNull TypeMirror service) {
        Types types = env.getTypeUtils();
        DeclaredType classOf = types.getDeclaredType(env.asTypeElement(Class.class), new TypeMirror[0]);
        DeclaredType iterableOf = types.getDeclaredType(env.asTypeElement(Iterable.class), new TypeMirror[0]);
        WildcardType extendsIterableOf = types.getWildcardType(iterableOf, null);
        return types.getDeclaredType(env.asTypeElement(Function.class), classOf, extendsIterableOf);
    }

    static @org.checkerframework.checker.nullness.qual.NonNull TypeMirror getCleanerType(@org.checkerframework.checker.nullness.qual.NonNull ExtEnvironment env, @org.checkerframework.checker.nullness.qual.NonNull TypeMirror service) {
        Types types = env.getTypeUtils();
        DeclaredType iterableOf = types.getDeclaredType(env.asTypeElement(Iterable.class), new TypeMirror[0]);
        WildcardType extendsIterableOf = types.getWildcardType(iterableOf, null);
        return types.getDeclaredType(env.asTypeElement(Consumer.class), extendsIterableOf);
    }

    @Generated
    LoadDefinition(@NonNull Quantifier quantifier, @NonNull Lifecycle lifecycle, @NonNull ClassName serviceType, @NonNull Optional<TypeInstantiator> fallback, boolean noFallback, @NonNull Optional<TypeWrapper> wrapper, @NonNull Optional<TypeInstantiator> preprocessor, @NonNull String loaderName, @NonNull Optional<TypeInstantiator> backend, @NonNull Optional<TypeInstantiator> cleaner, boolean batch, @NonNull String batchName, @NonNull Optional<TypeMirror> batchType) {
        if (quantifier == null) {
            throw new NullPointerException("quantifier is marked non-null but is null");
        }
        if (lifecycle == null) {
            throw new NullPointerException("lifecycle is marked non-null but is null");
        }
        if (serviceType == null) {
            throw new NullPointerException("serviceType is marked non-null but is null");
        }
        if (fallback == null) {
            throw new NullPointerException("fallback is marked non-null but is null");
        }
        if (wrapper == null) {
            throw new NullPointerException("wrapper is marked non-null but is null");
        }
        if (preprocessor == null) {
            throw new NullPointerException("preprocessor is marked non-null but is null");
        }
        if (loaderName == null) {
            throw new NullPointerException("loaderName is marked non-null but is null");
        }
        if (backend == null) {
            throw new NullPointerException("backend is marked non-null but is null");
        }
        if (cleaner == null) {
            throw new NullPointerException("cleaner is marked non-null but is null");
        }
        if (batchName == null) {
            throw new NullPointerException("batchName is marked non-null but is null");
        }
        if (batchType == null) {
            throw new NullPointerException("batchType is marked non-null but is null");
        }
        this.quantifier = quantifier;
        this.lifecycle = lifecycle;
        this.serviceType = serviceType;
        this.fallback = fallback;
        this.noFallback = noFallback;
        this.wrapper = wrapper;
        this.preprocessor = preprocessor;
        this.loaderName = loaderName;
        this.backend = backend;
        this.cleaner = cleaner;
        this.batch = batch;
        this.batchName = batchName;
        this.batchType = batchType;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    @Generated
    public Quantifier getQuantifier() {
        return this.quantifier;
    }

    @NonNull
    @Generated
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @NonNull
    @Generated
    public ClassName getServiceType() {
        return this.serviceType;
    }

    @NonNull
    @Generated
    public Optional<TypeInstantiator> getFallback() {
        return this.fallback;
    }

    @Generated
    public boolean isNoFallback() {
        return this.noFallback;
    }

    @NonNull
    @Generated
    public Optional<TypeWrapper> getWrapper() {
        return this.wrapper;
    }

    @NonNull
    @Generated
    public Optional<TypeInstantiator> getPreprocessor() {
        return this.preprocessor;
    }

    @NonNull
    @Generated
    public String getLoaderName() {
        return this.loaderName;
    }

    @NonNull
    @Generated
    public Optional<TypeInstantiator> getBackend() {
        return this.backend;
    }

    @NonNull
    @Generated
    public Optional<TypeInstantiator> getCleaner() {
        return this.cleaner;
    }

    @Generated
    public boolean isBatch() {
        return this.batch;
    }

    @NonNull
    @Generated
    public String getBatchName() {
        return this.batchName;
    }

    @NonNull
    @Generated
    public Optional<TypeMirror> getBatchType() {
        return this.batchType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoadDefinition)) {
            return false;
        }
        LoadDefinition other = (LoadDefinition)o;
        if (this.isNoFallback() != other.isNoFallback()) {
            return false;
        }
        if (this.isBatch() != other.isBatch()) {
            return false;
        }
        Quantifier this$quantifier = this.getQuantifier();
        Quantifier other$quantifier = other.getQuantifier();
        if (this$quantifier == null ? other$quantifier != null : !this$quantifier.equals(other$quantifier)) {
            return false;
        }
        Lifecycle this$lifecycle = this.getLifecycle();
        Lifecycle other$lifecycle = other.getLifecycle();
        if (this$lifecycle == null ? other$lifecycle != null : !((Object)((Object)this$lifecycle)).equals((Object)other$lifecycle)) {
            return false;
        }
        ClassName this$serviceType = this.getServiceType();
        ClassName other$serviceType = other.getServiceType();
        if (this$serviceType == null ? other$serviceType != null : !((Object)this$serviceType).equals(other$serviceType)) {
            return false;
        }
        Optional<TypeInstantiator> this$fallback = this.getFallback();
        Optional<TypeInstantiator> other$fallback = other.getFallback();
        if (this$fallback == null ? other$fallback != null : !((Object)this$fallback).equals(other$fallback)) {
            return false;
        }
        Optional<TypeWrapper> this$wrapper = this.getWrapper();
        Optional<TypeWrapper> other$wrapper = other.getWrapper();
        if (this$wrapper == null ? other$wrapper != null : !((Object)this$wrapper).equals(other$wrapper)) {
            return false;
        }
        Optional<TypeInstantiator> this$preprocessor = this.getPreprocessor();
        Optional<TypeInstantiator> other$preprocessor = other.getPreprocessor();
        if (this$preprocessor == null ? other$preprocessor != null : !((Object)this$preprocessor).equals(other$preprocessor)) {
            return false;
        }
        String this$loaderName = this.getLoaderName();
        String other$loaderName = other.getLoaderName();
        if (this$loaderName == null ? other$loaderName != null : !this$loaderName.equals(other$loaderName)) {
            return false;
        }
        Optional<TypeInstantiator> this$backend = this.getBackend();
        Optional<TypeInstantiator> other$backend = other.getBackend();
        if (this$backend == null ? other$backend != null : !((Object)this$backend).equals(other$backend)) {
            return false;
        }
        Optional<TypeInstantiator> this$cleaner = this.getCleaner();
        Optional<TypeInstantiator> other$cleaner = other.getCleaner();
        if (this$cleaner == null ? other$cleaner != null : !((Object)this$cleaner).equals(other$cleaner)) {
            return false;
        }
        String this$batchName = this.getBatchName();
        String other$batchName = other.getBatchName();
        if (this$batchName == null ? other$batchName != null : !this$batchName.equals(other$batchName)) {
            return false;
        }
        Optional<TypeMirror> this$batchType = this.getBatchType();
        Optional<TypeMirror> other$batchType = other.getBatchType();
        return !(this$batchType == null ? other$batchType != null : !((Object)this$batchType).equals(other$batchType));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNoFallback() ? 79 : 97);
        result = result * 59 + (this.isBatch() ? 79 : 97);
        Quantifier $quantifier = this.getQuantifier();
        result = result * 59 + ($quantifier == null ? 43 : $quantifier.hashCode());
        Lifecycle $lifecycle = this.getLifecycle();
        result = result * 59 + ($lifecycle == null ? 43 : ((Object)((Object)$lifecycle)).hashCode());
        ClassName $serviceType = this.getServiceType();
        result = result * 59 + ($serviceType == null ? 43 : ((Object)$serviceType).hashCode());
        Optional<TypeInstantiator> $fallback = this.getFallback();
        result = result * 59 + ($fallback == null ? 43 : ((Object)$fallback).hashCode());
        Optional<TypeWrapper> $wrapper = this.getWrapper();
        result = result * 59 + ($wrapper == null ? 43 : ((Object)$wrapper).hashCode());
        Optional<TypeInstantiator> $preprocessor = this.getPreprocessor();
        result = result * 59 + ($preprocessor == null ? 43 : ((Object)$preprocessor).hashCode());
        String $loaderName = this.getLoaderName();
        result = result * 59 + ($loaderName == null ? 43 : $loaderName.hashCode());
        Optional<TypeInstantiator> $backend = this.getBackend();
        result = result * 59 + ($backend == null ? 43 : ((Object)$backend).hashCode());
        Optional<TypeInstantiator> $cleaner = this.getCleaner();
        result = result * 59 + ($cleaner == null ? 43 : ((Object)$cleaner).hashCode());
        String $batchName = this.getBatchName();
        result = result * 59 + ($batchName == null ? 43 : $batchName.hashCode());
        Optional<TypeMirror> $batchType = this.getBatchType();
        result = result * 59 + ($batchType == null ? 43 : ((Object)$batchType).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LoadDefinition(quantifier=" + this.getQuantifier() + ", lifecycle=" + (Object)((Object)this.getLifecycle()) + ", serviceType=" + this.getServiceType() + ", fallback=" + this.getFallback() + ", noFallback=" + this.isNoFallback() + ", wrapper=" + this.getWrapper() + ", preprocessor=" + this.getPreprocessor() + ", loaderName=" + this.getLoaderName() + ", backend=" + this.getBackend() + ", cleaner=" + this.getCleaner() + ", batch=" + this.isBatch() + ", batchName=" + this.getBatchName() + ", batchType=" + this.getBatchType() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private Quantifier quantifier;
        @Generated
        private Lifecycle lifecycle;
        @Generated
        private ClassName serviceType;
        @Generated
        private Optional<TypeInstantiator> fallback;
        @Generated
        private boolean noFallback;
        @Generated
        private Optional<TypeWrapper> wrapper;
        @Generated
        private Optional<TypeInstantiator> preprocessor;
        @Generated
        private String loaderName;
        @Generated
        private Optional<TypeInstantiator> backend;
        @Generated
        private Optional<TypeInstantiator> cleaner;
        @Generated
        private boolean batch;
        @Generated
        private String batchName;
        @Generated
        private Optional<TypeMirror> batchType;

        @Generated
        Builder() {
        }

        @Generated
        public Builder quantifier(@NonNull Quantifier quantifier) {
            if (quantifier == null) {
                throw new NullPointerException("quantifier is marked non-null but is null");
            }
            this.quantifier = quantifier;
            return this;
        }

        @Generated
        public Builder lifecycle(@NonNull Lifecycle lifecycle) {
            if (lifecycle == null) {
                throw new NullPointerException("lifecycle is marked non-null but is null");
            }
            this.lifecycle = lifecycle;
            return this;
        }

        @Generated
        public Builder serviceType(@NonNull ClassName serviceType) {
            if (serviceType == null) {
                throw new NullPointerException("serviceType is marked non-null but is null");
            }
            this.serviceType = serviceType;
            return this;
        }

        @Generated
        public Builder fallback(@NonNull Optional<TypeInstantiator> fallback) {
            if (fallback == null) {
                throw new NullPointerException("fallback is marked non-null but is null");
            }
            this.fallback = fallback;
            return this;
        }

        @Generated
        public Builder noFallback(boolean noFallback) {
            this.noFallback = noFallback;
            return this;
        }

        @Generated
        public Builder wrapper(@NonNull Optional<TypeWrapper> wrapper) {
            if (wrapper == null) {
                throw new NullPointerException("wrapper is marked non-null but is null");
            }
            this.wrapper = wrapper;
            return this;
        }

        @Generated
        public Builder preprocessor(@NonNull Optional<TypeInstantiator> preprocessor) {
            if (preprocessor == null) {
                throw new NullPointerException("preprocessor is marked non-null but is null");
            }
            this.preprocessor = preprocessor;
            return this;
        }

        @Generated
        public Builder loaderName(@NonNull String loaderName) {
            if (loaderName == null) {
                throw new NullPointerException("loaderName is marked non-null but is null");
            }
            this.loaderName = loaderName;
            return this;
        }

        @Generated
        public Builder backend(@NonNull Optional<TypeInstantiator> backend) {
            if (backend == null) {
                throw new NullPointerException("backend is marked non-null but is null");
            }
            this.backend = backend;
            return this;
        }

        @Generated
        public Builder cleaner(@NonNull Optional<TypeInstantiator> cleaner) {
            if (cleaner == null) {
                throw new NullPointerException("cleaner is marked non-null but is null");
            }
            this.cleaner = cleaner;
            return this;
        }

        @Generated
        public Builder batch(boolean batch) {
            this.batch = batch;
            return this;
        }

        @Generated
        public Builder batchName(@NonNull String batchName) {
            if (batchName == null) {
                throw new NullPointerException("batchName is marked non-null but is null");
            }
            this.batchName = batchName;
            return this;
        }

        @Generated
        public Builder batchType(@NonNull Optional<TypeMirror> batchType) {
            if (batchType == null) {
                throw new NullPointerException("batchType is marked non-null but is null");
            }
            this.batchType = batchType;
            return this;
        }

        @Generated
        public LoadDefinition build() {
            return new LoadDefinition(this.quantifier, this.lifecycle, this.serviceType, this.fallback, this.noFallback, this.wrapper, this.preprocessor, this.loaderName, this.backend, this.cleaner, this.batch, this.batchName, this.batchType);
        }

        @Generated
        public String toString() {
            return "LoadDefinition.Builder(quantifier=" + this.quantifier + ", lifecycle=" + (Object)((Object)this.lifecycle) + ", serviceType=" + this.serviceType + ", fallback=" + this.fallback + ", noFallback=" + this.noFallback + ", wrapper=" + this.wrapper + ", preprocessor=" + this.preprocessor + ", loaderName=" + this.loaderName + ", backend=" + this.backend + ", cleaner=" + this.cleaner + ", batch=" + this.batch + ", batchName=" + this.batchName + ", batchType=" + this.batchType + ")";
        }
    }
}

