/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.service.definition;

import internal.nbbrd.service.ProcessorUtil;
import internal.nbbrd.service.Unreachable;
import internal.nbbrd.service.com.squareup.javapoet.ClassName;
import internal.nbbrd.service.com.squareup.javapoet.JavaFile;
import internal.nbbrd.service.com.squareup.javapoet.TypeSpec;
import internal.nbbrd.service.definition.LoadData;
import internal.nbbrd.service.definition.LoadDefinition;
import internal.nbbrd.service.definition.LoadFilter;
import internal.nbbrd.service.definition.LoadId;
import internal.nbbrd.service.definition.LoadSorter;
import internal.nbbrd.service.definition.ServiceDefinitionChecker;
import internal.nbbrd.service.definition.ServiceDefinitionCollector;
import internal.nbbrd.service.definition.ServiceDefinitionGenerator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"nbbrd.service.ServiceDefinition", "nbbrd.service.ServiceFilter", "nbbrd.service.ServiceSorter", "nbbrd.service.ServiceId"})
public final class ServiceDefinitionProcessor
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ServiceDefinitionCollector collector = new ServiceDefinitionCollector(this.processingEnv);
        ServiceDefinitionChecker checker = new ServiceDefinitionChecker(this.processingEnv);
        LoadData data = collector.collect(annotations, roundEnv);
        if (!data.getDefinitions().isEmpty()) {
            checker.checkModuleInfo(data.getDefinitions());
        }
        Map<ClassName, List<LoadDefinition>> definitionsByTopLevel = data.getDefinitions().stream().filter(checker::checkDefinition).collect(Collectors.groupingBy(definition -> definition.getServiceType().topLevelClassName()));
        Map<ClassName, List<LoadFilter>> filtersByService = data.getFilters().stream().filter(checker::checkFilter).collect(Collectors.groupingBy(filter -> filter.getServiceType().map(ClassName::get).orElseThrow(Unreachable::new)));
        Map<ClassName, List<LoadSorter>> sortersByService = data.getSorters().stream().filter(checker::checkSorter).collect(Collectors.groupingBy(sorter -> sorter.getServiceType().map(ClassName::get).orElseThrow(Unreachable::new)));
        Map<ClassName, List<LoadId>> idsByService = data.getIds().stream().filter(checker::checkId).collect(Collectors.groupingBy(sorter -> sorter.getServiceType().map(ClassName::get).orElseThrow(Unreachable::new)));
        checker.checkIds(idsByService);
        definitionsByTopLevel.forEach((topLevel, definitions) -> this.generate((ClassName)topLevel, ServiceDefinitionGenerator.allOf(definitions, filtersByService, sortersByService, idsByService)));
        return true;
    }

    private void generate(ClassName topLevel, List<ServiceDefinitionGenerator> generators) {
        if (this.isNotNested(topLevel, generators)) {
            this.generateNotNested(generators.get(0));
        } else {
            this.generateNested(topLevel, generators);
        }
    }

    private boolean isNotNested(ClassName topLevel, List<ServiceDefinitionGenerator> generators) {
        return generators.size() == 1 && topLevel.equals(generators.get(0).getDefinition().getServiceType());
    }

    private void generateNotNested(ServiceDefinitionGenerator generator) {
        this.generateNotNestedLoader(generator);
        this.generateNotNestedBatch(generator);
    }

    private void generateNotNestedLoader(ServiceDefinitionGenerator generator) {
        String loaderPackage = generator.getDefinition().resolveLoaderName().packageName();
        TypeSpec loaderClass = generator.generateLoader(false);
        this.writeFile(loaderPackage, loaderClass);
    }

    private void generateNotNestedBatch(ServiceDefinitionGenerator generator) {
        String batchPackage = generator.getDefinition().resolveBatchName().packageName();
        Optional<TypeSpec> batchClass = generator.generateBatch(false);
        batchClass.ifPresent(batchSpec -> this.writeFile(batchPackage, (TypeSpec)batchSpec));
    }

    private void generateNested(ClassName topLevel, List<ServiceDefinitionGenerator> generators) {
        this.generateNestedLoaders(topLevel, generators.stream().collect(Collectors.partitioningBy(ServiceDefinitionGenerator::hasCustomLoaderName)));
        this.generateNestedBatches(topLevel, generators.stream().collect(Collectors.partitioningBy(ServiceDefinitionGenerator::hasCustomBatchName)));
    }

    private void generateNestedLoaders(ClassName topLevel, Map<Boolean, List<ServiceDefinitionGenerator>> loadersByHasCustomName) {
        loadersByHasCustomName.get(true).forEach(this::generateNotNestedLoader);
        List<TypeSpec> nestedLoaders = loadersByHasCustomName.get(false).stream().map(o -> o.generateLoader(true)).collect(Collectors.toList());
        if (!nestedLoaders.isEmpty()) {
            TypeSpec loaderClass = TypeSpec.classBuilder(ClassName.bestGuess(topLevel.canonicalName() + "Loader")).addModifiers(Modifier.PUBLIC, Modifier.FINAL).addTypes(nestedLoaders).build();
            this.writeFile(topLevel.packageName(), loaderClass);
        }
    }

    private void generateNestedBatches(ClassName topLevel, Map<Boolean, List<ServiceDefinitionGenerator>> batchesByHasCustomName) {
        batchesByHasCustomName.get(true).forEach(this::generateNotNestedBatch);
        List<TypeSpec> nestedBatches = batchesByHasCustomName.get(false).stream().map(o -> o.generateBatch(true)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (!nestedBatches.isEmpty()) {
            TypeSpec batchClass = TypeSpec.classBuilder(ClassName.bestGuess(topLevel.canonicalName() + "Batch")).addModifiers(Modifier.PUBLIC, Modifier.FINAL).addTypes(nestedBatches).build();
            this.writeFile(topLevel.packageName(), batchClass);
        }
    }

    private void writeFile(String loaderPackage, TypeSpec loaderClass) {
        ProcessorUtil.write(this.processingEnv, JavaFile.builder(loaderPackage, loaderClass).build());
    }
}

