/*
 * Decompiled with CFR 0.152.
 */
package internal.sql.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.sql.DataSource;
import lombok.NonNull;
import nbbrd.sql.jdbc.SqlConnectionSupplier;
import nbbrd.sql.jdbc.SqlFunc;

public final class DataSourceBasedSupplier
implements SqlConnectionSupplier {
    @NonNull
    private final SqlFunc<String, DataSource> toDataSource;

    @Override
    public Connection getConnection(String connectionString) throws SQLException {
        Objects.requireNonNull(connectionString);
        return this.toDataSource.andThen(DataSource::getConnection).applyWithSql(connectionString);
    }

    public DataSourceBasedSupplier(@NonNull SqlFunc<String, DataSource> toDataSource) {
        if (toDataSource == null) {
            throw new NullPointerException("toDataSource is marked non-null but is null");
        }
        this.toDataSource = toDataSource;
    }
}

