/*
 * Decompiled with CFR 0.152.
 */
package internal.sql.lhod;

import internal.sql.lhod.LhodConnection;
import internal.sql.lhod.LhodResultSet;
import internal.sql.lhod.TabDataQuery;
import internal.sql.lhod.TabDataRemoteError;
import internal.sql.lhod._DatabaseMetaData;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class LhodDatabaseMetaData
extends _DatabaseMetaData {
    @NonNull
    private final LhodConnection conn;

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        this.conn.checkState();
        try {
            return this.getIdentifierCaseType() == IdentifierCaseType.UPPER;
        }
        catch (IOException ex) {
            throw ex instanceof TabDataRemoteError ? new SQLException(ex.getMessage(), "", ((TabDataRemoteError)ex).getNumber()) : new SQLException(String.format("Failed to get identifier case type of '%s'", this.conn.getConnectionString()), ex);
        }
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        this.conn.checkState();
        try {
            return this.getIdentifierCaseType() == IdentifierCaseType.LOWER;
        }
        catch (IOException ex) {
            throw ex instanceof TabDataRemoteError ? new SQLException(ex.getMessage(), "", ((TabDataRemoteError)ex).getNumber()) : new SQLException(String.format("Failed to get identifier case type of '%s'", this.conn.getConnectionString()), ex);
        }
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        this.conn.checkState();
        try {
            return this.getIdentifierCaseType() == IdentifierCaseType.MIXED;
        }
        catch (IOException ex) {
            throw ex instanceof TabDataRemoteError ? new SQLException(ex.getMessage(), "", ((TabDataRemoteError)ex).getNumber()) : new SQLException(String.format("Failed to get identifier case type of '%s'", this.conn.getConnectionString()), ex);
        }
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        this.conn.checkState();
        return null;
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        this.conn.checkState();
        return "";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        this.conn.checkState();
        try {
            return this.getStringFunctionStream().map(o -> o.getLabel()).sorted().collect(Collectors.joining(","));
        }
        catch (IOException ex) {
            throw ex instanceof TabDataRemoteError ? new SQLException(ex.getMessage(), "", ((TabDataRemoteError)ex).getNumber()) : new SQLException(String.format("Failed to get string functions of '%s'", this.conn.getConnectionString()), ex);
        }
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        this.conn.checkState();
        try {
            return this.conn.getProperty(LhodConnection.DynamicProperty.SPECIAL_CHARACTERS);
        }
        catch (IOException ex) {
            throw ex instanceof TabDataRemoteError ? new SQLException(ex.getMessage(), "", ((TabDataRemoteError)ex).getNumber()) : new SQLException(String.format("Failed to get extra name chars of '%s'", this.conn.getConnectionString()), ex);
        }
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        this.conn.checkState();
        TabDataQuery query = TabDataQuery.builder().procedure("OpenSchema").parameter(this.conn.getConnectionString()).parameter(catalog != null ? catalog : "\"\"").parameter(schemaPattern != null && !schemaPattern.equals("%") ? schemaPattern : "\"\"").parameter(tableNamePattern != null && !tableNamePattern.equals("%") ? tableNamePattern : "\"\"").parameters(types != null ? Arrays.asList(types) : Collections.emptyList()).build();
        try {
            return LhodResultSet.of(this.conn.exec(query));
        }
        catch (IOException ex) {
            throw ex instanceof TabDataRemoteError ? new SQLException(ex.getMessage(), "", ((TabDataRemoteError)ex).getNumber()) : new SQLException(String.format("Failed to list tables with catalog='%s', schemaPattern='%s', tableNamePattern='%s', types='%s' of '%s'", catalog, schemaPattern, tableNamePattern, types != null ? Arrays.toString(types) : null, this.conn.getConnectionString()), ex);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.conn.checkState();
        return this.conn;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.conn.checkState();
        return this.conn.isReadOnly();
    }

    private @Nullable IdentifierCaseType getIdentifierCaseType() throws IOException {
        String property = this.conn.getProperty(LhodConnection.DynamicProperty.IDENTIFIER_CASE_SENSITIVITY);
        if (property != null) {
            try {
                int value = Integer.parseInt(property);
                return LhodDatabaseMetaData.getIdentifierCaseTypeOrNull(value);
            }
            catch (NumberFormatException ex) {
                throw new IOException("Cannot parse identifier case type", ex);
            }
        }
        return null;
    }

    private static IdentifierCaseType getIdentifierCaseTypeOrNull(int value) {
        return Arrays.stream(IdentifierCaseType.values()).filter(type -> type.getValue() == value).findFirst().orElse(null);
    }

    private @org.checkerframework.checker.nullness.qual.NonNull Stream<SqlStringFunction> getStringFunctionStream() throws IOException {
        String property = this.conn.getProperty(LhodConnection.DynamicProperty.STRING_FUNCTIONS);
        if (property != null) {
            try {
                int value = Integer.parseInt(property);
                return LhodDatabaseMetaData.getStringFunctionStream(value);
            }
            catch (NumberFormatException ex) {
                throw new IOException("Cannot parse string functions bitmask", ex);
            }
        }
        return Stream.empty();
    }

    private static Stream<SqlStringFunction> getStringFunctionStream(int value) {
        return Arrays.stream(SqlStringFunction.values()).filter(func -> LhodDatabaseMetaData.hasBitmask(value, func.getBitmask()));
    }

    private static boolean hasBitmask(int value, int bitmask) {
        return (value & bitmask) == bitmask;
    }

    private LhodDatabaseMetaData(@NonNull LhodConnection conn) {
        if (conn == null) {
            throw new NullPointerException("conn is marked non-null but is null");
        }
        this.conn = conn;
    }

    public static LhodDatabaseMetaData of(@NonNull LhodConnection conn) {
        return new LhodDatabaseMetaData(conn);
    }

    private static enum SqlStringFunction {
        SQL_FN_STR_CONCAT(1, "CONCAT"),
        SQL_FN_STR_INSERT(2, "INSERT"),
        SQL_FN_STR_LEFT(4, "LEFT"),
        SQL_FN_STR_LTRIM(8, "LTRIM"),
        SQL_FN_STR_LENGTH(16, "LENGTH"),
        SQL_FN_STR_LOCATE(32, "LOCATE"),
        SQL_FN_STR_LCASE(64, "LCASE"),
        SQL_FN_STR_REPEAT(128, "REPEAT"),
        SQL_FN_STR_REPLACE(256, "REPLACE"),
        SQL_FN_STR_RIGHT(512, "RIGHT"),
        SQL_FN_STR_RTRIM(1024, "RTRIM"),
        SQL_FN_STR_SUBSTRING(2048, "SUBSTRING"),
        SQL_FN_STR_UCASE(4096, "UCASE"),
        SQL_FN_STR_ASCII(8192, "ASCII"),
        SQL_FN_STR_CHAR(16384, "CHAR"),
        SQL_FN_STR_DIFFERENCE(32768, "DIFFERENCE"),
        SQL_FN_STR_LOCATE_2(65536, "LOCATE_2"),
        SQL_FN_STR_SOUNDEX(131072, "SOUNDEX"),
        SQL_FN_STR_SPACE(262144, "SPACE"),
        SQL_FN_STR_BIT_LENGTH(524288, "BIT_LENGTH"),
        SQL_FN_STR_CHAR_LENGTH(0x100000, "CHAR_LENGTH"),
        SQL_FN_STR_CHARACTER_LENGTH(0x200000, "CHARACTER_LENGTH"),
        SQL_FN_STR_OCTET_LENGTH(0x400000, "OCTET_LENGTH"),
        SQL_FN_STR_POSITION(0x800000, "POSITION");

        private final int bitmask;
        private final String label;

        private SqlStringFunction(int bitmask, String label) {
            this.bitmask = bitmask;
            this.label = label;
        }

        public int getBitmask() {
            return this.bitmask;
        }

        public String getLabel() {
            return this.label;
        }
    }

    private static enum IdentifierCaseType {
        LOWER(2),
        MIXED(8),
        SENSITIVE(4),
        UPPER(1);

        private final int value;

        private IdentifierCaseType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

