/*
 * Decompiled with CFR 0.152.
 */
package internal.sql.lhod;

import internal.sql.lhod.LhodResultSetMetaData;
import internal.sql.lhod.TabDataReader;
import internal.sql.lhod.TabDataRemoteError;
import internal.sql.lhod._ResultSet;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import lombok.NonNull;

final class LhodResultSet
extends _ResultSet {
    @NonNull
    private final TabDataReader reader;
    private final DateFormat dateFormat = LhodResultSet.newDateFormat();
    private final NumberFormat numberFormat = LhodResultSet.newNumberFormat();
    private static final Locale EN_US = new Locale("en", "us");

    @Override
    public boolean next() throws SQLException {
        this.checkState();
        try {
            return this.reader.readNextRow();
        }
        catch (IOException ex) {
            throw ex instanceof TabDataRemoteError ? new SQLException(ex.getMessage(), "", ((TabDataRemoteError)ex).getNumber()) : new SQLException("While reading next row", ex);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.reader.isClosed();
        }
        catch (IOException ex) {
            throw new SQLException("Failed to check reader state", ex);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.reader.close();
        }
        catch (IOException ex) {
            throw new SQLException("While closing reader", ex);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkState();
        return LhodResultSetMetaData.of(this.reader.getColumns());
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.get(columnIndex);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.get(columnIndex);
    }

    @Override
    public java.sql.Date getDate(int columnIndex) throws SQLException {
        return new java.sql.Date(this.parseDate(columnIndex).getTime());
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return new Timestamp(this.parseDate(columnIndex).getTime());
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.parseNumber(columnIndex).doubleValue();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.parseNumber(columnIndex).floatValue();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.parseNumber(columnIndex).longValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.parseNumber(columnIndex).intValue();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.parseNumber(columnIndex).shortValue();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return new BigDecimal(this.get(columnIndex));
    }

    private Date parseDate(int columnIndex) throws SQLException {
        try {
            return this.dateFormat.parse(this.get(columnIndex));
        }
        catch (ParseException ex) {
            throw new SQLException("While parsing date", ex);
        }
    }

    private Number parseNumber(int columnIndex) throws SQLException {
        try {
            return this.numberFormat.parse(this.get(columnIndex));
        }
        catch (ParseException ex) {
            throw new SQLException("While parsing number", ex);
        }
    }

    private String get(int columnIndex) {
        return this.reader.get(columnIndex - 1);
    }

    private void checkState() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet closed");
        }
    }

    private static DateFormat newDateFormat() {
        SimpleDateFormat result = new SimpleDateFormat("MM/dd/yyyy", EN_US);
        result.setLenient(false);
        return result;
    }

    private static NumberFormat newNumberFormat() {
        return NumberFormat.getInstance(EN_US);
    }

    private LhodResultSet(@NonNull TabDataReader reader) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        this.reader = reader;
    }

    public static LhodResultSet of(@NonNull TabDataReader reader) {
        return new LhodResultSet(reader);
    }
}

