/*
 * Decompiled with CFR 0.152.
 */
package internal.sql.lhod;

import internal.sql.lhod.LhodDriver;
import java.sql.Connection;
import java.sql.SQLException;
import lombok.NonNull;
import nbbrd.io.sys.OS;
import nbbrd.sql.odbc.OdbcConnectionSupplierSpi;

public final class LhodConnectionSupplier
implements OdbcConnectionSupplierSpi {
    private final LhodDriver driver = new LhodDriver();

    @NonNull
    public String getName() {
        return this.driver.getClass().getName();
    }

    public boolean isAvailable() {
        return OS.NAME == OS.Name.WINDOWS;
    }

    public int getCost() {
        return 1000;
    }

    @NonNull
    public Connection getConnection(@NonNull String connectionString) throws SQLException {
        if (connectionString == null) {
            throw new NullPointerException("connectionString is marked non-null but is null");
        }
        Connection result = this.driver.connect("jdbc:lhod:" + connectionString, null);
        if (result == null) {
            throw new SQLException("Null connection. Wrong kind of driver ?");
        }
        return result;
    }
}

