/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.picocsv;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;

public final class Csv {
    public static final int DEFAULT_CHAR_BUFFER_SIZE = 8192;

    private Csv() {
    }

    private static void requireArgument(boolean condition, String format, Object arg) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, format, arg));
        }
    }

    public static final class Writer
    implements LineWriter,
    Flushable,
    Closeable {
        private final java.io.Writer charWriter;
        private final char[] buffer;
        private final char[] fieldChars;
        private final char quote;
        private final char delimiter;
        private final char comment;
        private final char eol0;
        private final char eol1;
        private int bufferLength = 0;
        private int fieldLength = 0;
        private int state = 0;
        private static final int STATE_0_NO_FIELD = 0;
        private static final int STATE_1_SINGLE_EMPTY_FIELD = 1;
        private static final int STATE_2_MULTI_FIELD = 2;
        private static final char NO_SECOND_EOL = '\u0000';

        public static Writer of(Format format, WriterOptions options, java.io.Writer charWriter) throws IllegalArgumentException, IOException {
            return Writer.of(format, options, charWriter, 8192);
        }

        public static Writer of(Format format, WriterOptions options, java.io.Writer charWriter, int charBufferSize) throws IllegalArgumentException, IOException {
            Objects.requireNonNull(format, "format");
            Objects.requireNonNull(options, "options");
            Objects.requireNonNull(charWriter, "charWriter");
            Csv.requireArgument(charBufferSize > 0, "Invalid charBufferSize: %s", charBufferSize);
            Csv.requireArgument(format.isValid(), "Invalid format: %s", format);
            return new Writer(charWriter, new char[charBufferSize], new char[options.getMaxCharsPerField()], format.getQuote(), format.getDelimiter(), format.getComment(), format.getSeparator().charAt(0), format.getSeparator().length() == 1 ? (char)'\u0000' : format.getSeparator().charAt(1));
        }

        private Writer(java.io.Writer charWriter, char[] buffer, char[] fieldChars, char quote, char delimiter, char comment, char eol0, char eol1) {
            this.charWriter = charWriter;
            this.buffer = buffer;
            this.fieldChars = fieldChars;
            this.quote = quote;
            this.delimiter = delimiter;
            this.comment = comment;
            this.eol0 = eol0;
            this.eol1 = eol1;
        }

        @Override
        public void writeComment(CharSequence comment) throws IOException {
            boolean notEmpty = comment != null && comment.length() != 0;
            switch (this.state) {
                case 0: {
                    if (notEmpty) {
                        this.prepareField(comment);
                        this.formatComment();
                        break;
                    }
                    this.formatEmptyComment();
                    break;
                }
                case 1: {
                    this.state = 0;
                    if (notEmpty) {
                        this.formatSingleEmptyField();
                        this.formatEndOfLine();
                        this.prepareField(comment);
                        this.formatComment();
                        break;
                    }
                    this.formatSingleEmptyField();
                    this.formatEndOfLine();
                    this.formatEmptyComment();
                    break;
                }
                case 2: {
                    this.state = 0;
                    if (notEmpty) {
                        this.formatEndOfLine();
                        this.prepareField(comment);
                        this.formatComment();
                        break;
                    }
                    this.formatEndOfLine();
                    this.formatEmptyComment();
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unreachable");
                }
            }
        }

        @Override
        public void writeField(CharSequence field) throws IOException {
            boolean notEmpty = field != null && field.length() != 0;
            switch (this.state) {
                case 0: {
                    int n = this.state = notEmpty ? 2 : 1;
                    if (!notEmpty) break;
                    if (field.charAt(0) == this.comment) {
                        this.prepareField(field);
                        this.formatQuotedField(true);
                        break;
                    }
                    this.prepareField(field);
                    this.formatField(true);
                    break;
                }
                case 1: {
                    this.state = 2;
                    if (notEmpty) {
                        this.prepareField(field);
                        this.formatField(false);
                        break;
                    }
                    this.formatEmptyField();
                    break;
                }
                case 2: {
                    if (notEmpty) {
                        this.prepareField(field);
                        this.formatField(false);
                        break;
                    }
                    this.formatEmptyField();
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unreachable");
                }
            }
        }

        @Override
        public void writeQuotedField(CharSequence field) throws IOException {
            boolean notEmpty = field != null && field.length() != 0;
            switch (this.state) {
                case 0: {
                    this.state = 2;
                    if (notEmpty) {
                        this.prepareField(field);
                        this.formatQuotedField(true);
                        break;
                    }
                    this.formatSingleEmptyField();
                    break;
                }
                case 1: {
                    this.state = 2;
                    if (notEmpty) {
                        this.prepareField(field);
                        this.formatQuotedField(false);
                        break;
                    }
                    this.formatEmptyQuotedField();
                    break;
                }
                case 2: {
                    if (notEmpty) {
                        this.prepareField(field);
                        this.formatQuotedField(false);
                        break;
                    }
                    this.formatEmptyQuotedField();
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unreachable");
                }
            }
        }

        public void writeEndOfLine() throws IOException {
            if (this.state == 1) {
                this.formatSingleEmptyField();
                this.formatEndOfLine();
            } else {
                this.formatEndOfLine();
            }
            this.state = 0;
        }

        @Override
        public void flush() throws IOException {
            if (this.bufferLength > 0) {
                this.charWriter.write(this.buffer, 0, this.bufferLength);
                this.bufferLength = 0;
            }
            this.charWriter.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.state == 1) {
                this.formatSingleEmptyField();
            }
            this.state = 0;
            this.flush();
            this.charWriter.close();
        }

        private void prepareField(CharSequence field) throws IOException {
            int fieldLength = field.length();
            try {
                field.toString().getChars(0, fieldLength, this.fieldChars, 0);
            }
            catch (StringIndexOutOfBoundsException ex) {
                throw new IOException("Field overflow");
            }
            this.fieldLength = fieldLength;
        }

        private void formatEmptyComment() throws IOException {
            int l = this.bufferLength;
            try {
                int n;
                int n2;
                char[] b = this.buffer;
                if (l == b.length) {
                    l = Writer.write(this.charWriter, b);
                    n2 = l - 1;
                } else {
                    n2 = l++;
                }
                b[n2] = this.comment;
                if (l == b.length) {
                    l = Writer.write(this.charWriter, b);
                    n = l - 1;
                } else {
                    n = l++;
                }
                b[n] = this.eol0;
                if (this.eol1 != '\u0000') {
                    int n3;
                    if (l == b.length) {
                        l = Writer.write(this.charWriter, b);
                        n3 = l - 1;
                    } else {
                        n3 = l++;
                    }
                    b[n3] = this.eol1;
                }
            }
            finally {
                this.bufferLength = l;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void formatComment() throws IOException {
            int l = this.bufferLength;
            try {
                char comment = this.comment;
                char[] b = this.buffer;
                char[] chars = this.fieldChars;
                int limit = this.fieldLength;
                char eol0 = this.eol0;
                char eol1 = this.eol1;
                java.io.Writer t = this.charWriter;
                if (eol1 != '\u0000') {
                    int n;
                    int n2;
                    int n3;
                    if (l == b.length) {
                        l = Writer.write(t, b);
                        n3 = l - 1;
                    } else {
                        n3 = l++;
                    }
                    b[n3] = comment;
                    for (int i = 0; i < limit; ++i) {
                        int n4;
                        char character = chars[i];
                        if (character == eol0 || character == eol1) {
                            int n5;
                            int n6;
                            int n7;
                            if (l == b.length) {
                                l = Writer.write(t, b);
                                n7 = l - 1;
                            } else {
                                n7 = l++;
                            }
                            b[n7] = eol0;
                            if (l == b.length) {
                                l = Writer.write(t, b);
                                n6 = l - 1;
                            } else {
                                n6 = l++;
                            }
                            b[n6] = eol1;
                            if (l == b.length) {
                                l = Writer.write(t, b);
                                n5 = l - 1;
                            } else {
                                n5 = l++;
                            }
                            b[n5] = comment;
                            if (i + 1 >= limit || chars[i + 1] != eol1) continue;
                            ++i;
                            continue;
                        }
                        if (l == b.length) {
                            l = Writer.write(t, b);
                            n4 = l - 1;
                        } else {
                            n4 = l++;
                        }
                        b[n4] = character;
                    }
                    if (l == b.length) {
                        l = Writer.write(t, b);
                        n2 = l - 1;
                    } else {
                        n2 = l++;
                    }
                    b[n2] = eol0;
                    if (l == b.length) {
                        l = Writer.write(t, b);
                        n = l - 1;
                    } else {
                        n = l++;
                    }
                    b[n] = eol1;
                } else {
                    int n;
                    int n8;
                    if (l == b.length) {
                        l = Writer.write(t, b);
                        n8 = l - 1;
                    } else {
                        n8 = l++;
                    }
                    b[n8] = comment;
                    for (int p = 0; p < limit; ++p) {
                        int n9;
                        char character = chars[p];
                        if (character == eol0) {
                            int n10;
                            int n11;
                            if (l == b.length) {
                                l = Writer.write(t, b);
                                n11 = l - 1;
                            } else {
                                n11 = l++;
                            }
                            b[n11] = eol0;
                            if (l == b.length) {
                                l = Writer.write(t, b);
                                n10 = l - 1;
                            } else {
                                n10 = l++;
                            }
                            b[n10] = comment;
                            continue;
                        }
                        if (l == b.length) {
                            l = Writer.write(t, b);
                            n9 = l - 1;
                        } else {
                            n9 = l++;
                        }
                        b[n9] = character;
                    }
                    if (l == b.length) {
                        l = Writer.write(t, b);
                        n = l - 1;
                    } else {
                        n = l++;
                    }
                    b[n] = eol0;
                }
            }
            finally {
                this.bufferLength = l;
            }
        }

        private void formatSingleEmptyField() throws IOException {
            int l = this.bufferLength;
            try {
                int n;
                int n2;
                char[] b = this.buffer;
                if (l == b.length) {
                    l = Writer.write(this.charWriter, b);
                    n2 = l - 1;
                } else {
                    n2 = l++;
                }
                b[n2] = this.quote;
                if (l == b.length) {
                    l = Writer.write(this.charWriter, b);
                    n = l - 1;
                } else {
                    n = l++;
                }
                b[n] = this.quote;
            }
            finally {
                this.bufferLength = l;
            }
        }

        private void formatEmptyField() throws IOException {
            int l = this.bufferLength;
            try {
                int n;
                char[] b = this.buffer;
                if (l == b.length) {
                    l = Writer.write(this.charWriter, b);
                    n = l - 1;
                } else {
                    n = l++;
                }
                b[n] = this.delimiter;
            }
            finally {
                this.bufferLength = l;
            }
        }

        private void formatEmptyQuotedField() throws IOException {
            int l = this.bufferLength;
            try {
                int n;
                int n2;
                int n3;
                char[] b = this.buffer;
                if (l == b.length) {
                    l = Writer.write(this.charWriter, b);
                    n3 = l - 1;
                } else {
                    n3 = l++;
                }
                b[n3] = this.delimiter;
                if (l == b.length) {
                    l = Writer.write(this.charWriter, b);
                    n2 = l - 1;
                } else {
                    n2 = l++;
                }
                b[n2] = this.quote;
                if (l == b.length) {
                    l = Writer.write(this.charWriter, b);
                    n = l - 1;
                } else {
                    n = l++;
                }
                b[n] = this.quote;
            }
            finally {
                this.bufferLength = l;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void formatQuotedField(boolean firstField) throws IOException {
            int l = this.bufferLength;
            try {
                int n;
                int n2;
                char quote = this.quote;
                char delimiter = this.delimiter;
                char[] b = this.buffer;
                char[] chars = this.fieldChars;
                int limit = this.fieldLength;
                java.io.Writer t = this.charWriter;
                if (!firstField) {
                    int n3;
                    if (l == b.length) {
                        l = Writer.write(t, b);
                        n3 = l - 1;
                    } else {
                        n3 = l++;
                    }
                    b[n3] = delimiter;
                }
                if (l == b.length) {
                    l = Writer.write(t, b);
                    n2 = l - 1;
                } else {
                    n2 = l++;
                }
                b[n2] = quote;
                for (int i = 0; i < limit; ++i) {
                    int n4;
                    int n5;
                    if (l == b.length) {
                        l = Writer.write(t, b);
                        n5 = l - 1;
                    } else {
                        n5 = l++;
                    }
                    if ((b[n5] = chars[i]) != quote) continue;
                    if (l == b.length) {
                        l = Writer.write(t, b);
                        n4 = l - 1;
                    } else {
                        n4 = l++;
                    }
                    b[n4] = quote;
                }
                if (l == b.length) {
                    l = Writer.write(t, b);
                    n = l - 1;
                } else {
                    n = l++;
                }
                b[n] = quote;
            }
            finally {
                this.bufferLength = l;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void formatField(boolean firstField) throws IOException {
            int l = this.bufferLength;
            try {
                char quote = this.quote;
                char delimiter = this.delimiter;
                char[] b = this.buffer;
                char[] chars = this.fieldChars;
                int limit = this.fieldLength;
                char eol0 = this.eol0;
                char eol1 = this.eol1;
                java.io.Writer t = this.charWriter;
                if (!firstField) {
                    int n;
                    if (l == b.length) {
                        l = Writer.write(t, b);
                        n = l - 1;
                    } else {
                        n = l++;
                    }
                    b[n] = delimiter;
                }
                for (int i = 0; i < limit; ++i) {
                    int n;
                    int n2;
                    int n3;
                    char character = chars[i];
                    if (character == quote) {
                        int n4;
                        int n5;
                        int n6;
                        int n7;
                        if (l == b.length) {
                            l = Writer.write(t, b);
                            n7 = l - 1;
                        } else {
                            n7 = l++;
                        }
                        b[n7] = quote;
                        if (l + i <= b.length) {
                            System.arraycopy(chars, 0, b, l, i);
                            l += i;
                        } else {
                            for (int p = 0; p < i; ++p) {
                                int n8;
                                if (l == b.length) {
                                    l = Writer.write(t, b);
                                    n8 = l - 1;
                                } else {
                                    n8 = l++;
                                }
                                b[n8] = chars[p];
                            }
                        }
                        if (l == b.length) {
                            l = Writer.write(t, b);
                            n6 = l - 1;
                        } else {
                            n6 = l++;
                        }
                        b[n6] = quote;
                        if (l == b.length) {
                            l = Writer.write(t, b);
                            n5 = l - 1;
                        } else {
                            n5 = l++;
                        }
                        b[n5] = character;
                        while (++i < limit) {
                            int n9;
                            int n10;
                            if (l == b.length) {
                                l = Writer.write(t, b);
                                n10 = l - 1;
                            } else {
                                n10 = l++;
                            }
                            if ((b[n10] = chars[i]) != quote) continue;
                            if (l == b.length) {
                                l = Writer.write(t, b);
                                n9 = l - 1;
                            } else {
                                n9 = l++;
                            }
                            b[n9] = quote;
                        }
                        if (l == b.length) {
                            l = Writer.write(t, b);
                            n4 = l - 1;
                        } else {
                            n4 = l++;
                        }
                        b[n4] = quote;
                        return;
                    }
                    if (character != delimiter && character != eol0 && character != eol1) continue;
                    if (l == b.length) {
                        l = Writer.write(t, b);
                        n3 = l - 1;
                    } else {
                        n3 = l++;
                    }
                    b[n3] = quote;
                    if (l + i <= b.length) {
                        System.arraycopy(chars, 0, b, l, i);
                        l += i;
                    } else {
                        for (int p = 0; p < i; ++p) {
                            int n11;
                            if (l == b.length) {
                                l = Writer.write(t, b);
                                n11 = l - 1;
                            } else {
                                n11 = l++;
                            }
                            b[n11] = chars[p];
                        }
                    }
                    if (l == b.length) {
                        l = Writer.write(t, b);
                        n2 = l - 1;
                    } else {
                        n2 = l++;
                    }
                    b[n2] = character;
                    while (++i < limit) {
                        int n12;
                        int n13;
                        if (l == b.length) {
                            l = Writer.write(t, b);
                            n13 = l - 1;
                        } else {
                            n13 = l++;
                        }
                        if ((b[n13] = chars[i]) != quote) continue;
                        if (l == b.length) {
                            l = Writer.write(t, b);
                            n12 = l - 1;
                        } else {
                            n12 = l++;
                        }
                        b[n12] = quote;
                    }
                    if (l == b.length) {
                        l = Writer.write(t, b);
                        n = l - 1;
                    } else {
                        n = l++;
                    }
                    b[n] = quote;
                    return;
                }
                if (l + limit <= b.length) {
                    System.arraycopy(chars, 0, b, l, limit);
                    l += limit;
                } else {
                    for (int p = 0; p < limit; ++p) {
                        int n;
                        if (l == b.length) {
                            l = Writer.write(t, b);
                            n = l - 1;
                        } else {
                            n = l++;
                        }
                        b[n] = chars[p];
                    }
                }
            }
            finally {
                this.bufferLength = l;
            }
        }

        private void formatEndOfLine() throws IOException {
            int l = this.bufferLength;
            try {
                int n;
                char[] b = this.buffer;
                if (l == b.length) {
                    l = Writer.write(this.charWriter, b);
                    n = l - 1;
                } else {
                    n = l++;
                }
                b[n] = this.eol0;
                if (this.eol1 != '\u0000') {
                    int n2;
                    if (l == b.length) {
                        l = Writer.write(this.charWriter, b);
                        n2 = l - 1;
                    } else {
                        n2 = l++;
                    }
                    b[n2] = this.eol1;
                }
            }
            finally {
                this.bufferLength = l;
            }
        }

        private static int write(java.io.Writer charWriter, char[] buffer) throws IOException {
            charWriter.write(buffer);
            return 1;
        }
    }

    public static interface LineWriter {
        public void writeComment(CharSequence var1) throws IOException;

        public void writeField(CharSequence var1) throws IOException;

        public void writeQuotedField(CharSequence var1) throws IOException;
    }

    public static final class WriterOptions {
        private static final int DEFAULT_MAX_CHARS_PER_FIELD = 4096;
        public static final WriterOptions DEFAULT = new WriterOptions(4096);
        private final int maxCharsPerField;

        private WriterOptions(int maxCharsPerField) {
            this.maxCharsPerField = maxCharsPerField;
        }

        public int getMaxCharsPerField() {
            return this.maxCharsPerField;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + this.maxCharsPerField;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WriterOptions other = (WriterOptions)obj;
            return this.maxCharsPerField == other.maxCharsPerField;
        }

        public String toString() {
            return "WriterOptions(maxCharsPerField=" + this.maxCharsPerField + ')';
        }

        public Builder toBuilder() {
            return new Builder().maxCharsPerField(this.maxCharsPerField);
        }

        public static Builder builder() {
            return DEFAULT.toBuilder();
        }

        public static final class Builder {
            private int maxCharsPerField;

            private Builder() {
            }

            public Builder maxCharsPerField(int maxCharsPerField) {
                this.maxCharsPerField = maxCharsPerField;
                return this;
            }

            public WriterOptions build() {
                return new WriterOptions(this.maxCharsPerField);
            }
        }
    }

    public static final class Reader
    implements LineReader,
    Closeable {
        private final java.io.Reader charReader;
        private final char[] buffer;
        private final int quoteCode;
        private final int delimiterCode;
        private final int commentCode;
        private final byte emptyLineState;
        private final char[] fieldChars;
        private final byte eolType;
        private final int eolCode0;
        private final int eolCode1;
        private int bufferLength = 0;
        private int bufferIndex = 0;
        private int fieldLength = 0;
        private byte fieldType = (byte)10;
        private byte state = 0;
        private static final byte STATE_0_READY = 0;
        private static final byte STATE_1_FIRST = 1;
        private static final byte STATE_2_NOT_LAST = 2;
        private static final byte STATE_3_LAST = 3;
        private static final byte STATE_4_SINGLE = 4;
        private static final byte STATE_5_MISSING = 5;
        private static final byte STATE_6_DONE = 6;
        private static final byte FIELD_TYPE_NORMAL = 10;
        private static final byte FIELD_TYPE_QUOTED = 11;
        private static final byte FIELD_TYPE_COMMENTED = 12;
        private static final byte EOL_TYPE_SINGLE = 20;
        private static final byte EOL_TYPE_DUAL_STRICT = 21;
        private static final byte EOL_TYPE_DUAL_LENIENT = 22;
        private static final int EOF_CODE = -1;

        public static Reader of(Format format, ReaderOptions options, java.io.Reader charReader) throws IllegalArgumentException, IOException {
            return Reader.of(format, options, charReader, 8192);
        }

        public static Reader of(Format format, ReaderOptions options, java.io.Reader charReader, int charBufferSize) throws IllegalArgumentException, IOException {
            int eolCode1;
            char eolCode0;
            byte eolType;
            Objects.requireNonNull(format, "format");
            Objects.requireNonNull(options, "options");
            Objects.requireNonNull(charReader, "charReader");
            Csv.requireArgument(charBufferSize > 0, "Invalid charBufferSize: %s", charBufferSize);
            Csv.requireArgument(format.isValid(), "Invalid format: %s", format);
            Csv.requireArgument(options.isValid(), "Invalid options: %s", options);
            char[] charBuffer = new char[charBufferSize];
            if (format.getSeparator().length() == 1) {
                eolType = 20;
                eolCode0 = format.getSeparator().charAt(0);
                eolCode1 = -1;
            } else {
                eolType = options.isLenientSeparator() ? (byte)22 : 21;
                eolCode0 = format.getSeparator().charAt(0);
                eolCode1 = format.getSeparator().charAt(1);
            }
            return new Reader(charReader, charBuffer, format.getQuote(), format.getDelimiter(), format.getComment(), format.isAcceptMissingField() ? (byte)5 : 4, new char[options.getMaxCharsPerField()], eolType, eolCode0, eolCode1);
        }

        private Reader(java.io.Reader charReader, char[] buffer, int quoteCode, int delimiterCode, int commentCode, byte emptyLineState, char[] fieldChars, byte eolType, int eolCode0, int eolCode1) {
            this.charReader = charReader;
            this.buffer = buffer;
            this.quoteCode = quoteCode;
            this.delimiterCode = delimiterCode;
            this.commentCode = commentCode;
            this.emptyLineState = emptyLineState;
            this.fieldChars = fieldChars;
            this.eolType = eolType;
            this.eolCode0 = eolCode0;
            this.eolCode1 = eolCode1;
        }

        public boolean readLine() throws IOException {
            switch (this.state) {
                case 0: {
                    this.relocateBuffer();
                    this.parseNextField(true);
                    return this.state != 6;
                }
                case 1: {
                    this.skipRemainingFields();
                    this.relocateBuffer();
                    this.parseNextField(true);
                    return this.state != 6;
                }
                case 2: {
                    this.skipRemainingFields();
                    this.relocateBuffer();
                    this.parseNextField(true);
                    return this.state != 6;
                }
                case 3: {
                    this.relocateBuffer();
                    this.parseNextField(true);
                    return this.state != 6;
                }
                case 4: {
                    this.relocateBuffer();
                    this.parseNextField(true);
                    return this.state != 6;
                }
                case 5: {
                    this.relocateBuffer();
                    this.parseNextField(true);
                    return this.state != 6;
                }
                case 6: {
                    return false;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    return false;
                }
            }
            throw new RuntimeException("Unreachable");
        }

        @Override
        public boolean readField() throws IOException {
            switch (this.state) {
                case 0: {
                    throw new IllegalStateException();
                }
                case 1: {
                    this.state = (byte)2;
                    return true;
                }
                case 2: {
                    this.parseNextField(false);
                    return true;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    this.state = (byte)3;
                    return true;
                }
                case 5: {
                    return false;
                }
                case 6: {
                    return false;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    return false;
                }
            }
            throw new RuntimeException("Unreachable");
        }

        @Override
        public boolean isComment() {
            return this.fieldType == 12;
        }

        @Override
        public boolean isQuoted() {
            return this.fieldType == 11;
        }

        @Override
        public void close() throws IOException {
            this.charReader.close();
        }

        private void skipRemainingFields() throws IOException {
            do {
                this.parseNextField(false);
            } while (this.state == 2);
        }

        private void relocateBuffer() throws IOException {
            if (this.bufferLength != -1 && this.bufferIndex > this.buffer.length / 2) {
                int remainingChars = this.bufferLength - this.bufferIndex;
                System.arraycopy(this.buffer, this.bufferIndex, this.buffer, 0, remainingChars);
                int newChars = this.charReader.read(this.buffer, remainingChars, this.bufferIndex);
                this.bufferIndex = 0;
                this.bufferLength = remainingChars + newChars;
            }
        }

        private void parseNextField(boolean firstField) throws IOException {
            int fieldLength = this.fieldLength;
            int i = this.bufferIndex;
            int l = this.bufferLength;
            try {
                int firstCode;
                int n;
                int quoteCode = this.quoteCode;
                int delimiterCode = this.delimiterCode;
                char[] fieldChars = this.fieldChars;
                java.io.Reader s = this.charReader;
                char[] b = this.buffer;
                byte eolType = this.eolType;
                int eolCode0 = this.eolCode0;
                int eolCode1 = this.eolCode1;
                fieldLength = 0;
                if (i < l) {
                    n = b[i++];
                } else {
                    l = s.read(b);
                    if (l == -1) {
                        n = -1;
                    } else {
                        i = 1;
                        n = firstCode = b[1 - 1];
                    }
                }
                if (n != -1) {
                    if (firstCode == quoteCode) {
                        this.fieldType = (byte)11;
                        boolean escaped = false;
                        while (true) {
                            int subCode;
                            int n2;
                            if (i < l) {
                                n2 = b[i++];
                            } else {
                                l = s.read(b);
                                if (l == -1) {
                                    n2 = -1;
                                } else {
                                    i = 1;
                                    n2 = subCode = b[1 - 1];
                                }
                            }
                            if (n2 == -1) break;
                            if (subCode == quoteCode) {
                                if (!escaped) {
                                    escaped = true;
                                    continue;
                                }
                                escaped = false;
                                fieldChars[fieldLength++] = (char)subCode;
                                continue;
                            }
                            if (escaped) {
                                if (subCode == delimiterCode) {
                                    this.state = (byte)(firstField ? 1 : 2);
                                    return;
                                }
                                if (subCode == eolCode0) {
                                    switch (eolType) {
                                        case 20: {
                                            this.state = (byte)(firstField ? 4 : 3);
                                            return;
                                        }
                                        case 21: {
                                            int n3;
                                            if (i < l) {
                                                n3 = b[i++];
                                            } else {
                                                l = s.read(b);
                                                if (l == -1) {
                                                    n3 = -1;
                                                } else {
                                                    i = 1;
                                                    n3 = b[1 - 1];
                                                }
                                            }
                                            if (n3 != eolCode1) {
                                                --i;
                                                break;
                                            }
                                            this.state = (byte)(firstField ? 4 : 3);
                                            return;
                                        }
                                        case 22: {
                                            int n4;
                                            if (i < l) {
                                                n4 = b[i++];
                                            } else {
                                                l = s.read(b);
                                                if (l == -1) {
                                                    n4 = -1;
                                                } else {
                                                    i = 1;
                                                    n4 = b[1 - 1];
                                                }
                                            }
                                            if (n4 != eolCode1) {
                                                --i;
                                            }
                                            this.state = (byte)(firstField ? 4 : 3);
                                            return;
                                        }
                                    }
                                } else if (eolType == 22 && subCode == eolCode1) {
                                    this.state = (byte)(firstField ? 4 : 3);
                                    return;
                                }
                            }
                            fieldChars[fieldLength++] = (char)subCode;
                        }
                        this.state = (byte)(firstField ? 4 : 3);
                        return;
                    }
                    if (firstField && firstCode == this.commentCode) {
                        this.fieldType = (byte)12;
                        while (true) {
                            int subCode;
                            int n5;
                            if (i < l) {
                                n5 = b[i++];
                            } else {
                                l = s.read(b);
                                if (l == -1) {
                                    n5 = -1;
                                } else {
                                    i = 1;
                                    n5 = subCode = b[1 - 1];
                                }
                            }
                            if (n5 == -1) break;
                            if (subCode == eolCode0) {
                                switch (eolType) {
                                    case 20: {
                                        this.state = (byte)4;
                                        return;
                                    }
                                    case 21: {
                                        int n6;
                                        if (i < l) {
                                            n6 = b[i++];
                                        } else {
                                            l = s.read(b);
                                            if (l == -1) {
                                                n6 = -1;
                                            } else {
                                                i = 1;
                                                n6 = b[1 - 1];
                                            }
                                        }
                                        if (n6 != eolCode1) {
                                            --i;
                                            break;
                                        }
                                        this.state = (byte)4;
                                        return;
                                    }
                                    case 22: {
                                        int n7;
                                        if (i < l) {
                                            n7 = b[i++];
                                        } else {
                                            l = s.read(b);
                                            if (l == -1) {
                                                n7 = -1;
                                            } else {
                                                i = 1;
                                                n7 = b[1 - 1];
                                            }
                                        }
                                        if (n7 != eolCode1) {
                                            --i;
                                        }
                                        this.state = (byte)4;
                                        return;
                                    }
                                }
                            } else if (eolType == 22 && subCode == eolCode1) {
                                this.state = (byte)4;
                                return;
                            }
                            fieldChars[fieldLength++] = (char)subCode;
                        }
                        this.state = (byte)4;
                        return;
                    }
                    this.fieldType = (byte)10;
                    if (firstCode == delimiterCode) {
                        this.state = (byte)(firstField ? 1 : 2);
                        return;
                    }
                    if (firstCode == eolCode0) {
                        switch (eolType) {
                            case 20: {
                                this.state = (byte)(firstField ? (int)this.emptyLineState : 3);
                                return;
                            }
                            case 21: {
                                int n8;
                                if (i < l) {
                                    n8 = b[i++];
                                } else {
                                    l = s.read(b);
                                    if (l == -1) {
                                        n8 = -1;
                                    } else {
                                        i = 1;
                                        n8 = b[1 - 1];
                                    }
                                }
                                if (n8 != eolCode1) {
                                    --i;
                                    break;
                                }
                                this.state = (byte)(firstField ? (int)this.emptyLineState : 3);
                                return;
                            }
                            case 22: {
                                int n9;
                                if (i < l) {
                                    n9 = b[i++];
                                } else {
                                    l = s.read(b);
                                    if (l == -1) {
                                        n9 = -1;
                                    } else {
                                        i = 1;
                                        n9 = b[1 - 1];
                                    }
                                }
                                if (n9 != eolCode1) {
                                    --i;
                                }
                                this.state = (byte)(firstField ? (int)this.emptyLineState : 3);
                                return;
                            }
                        }
                    } else if (eolType == 22 && firstCode == eolCode1) {
                        this.state = (byte)(firstField ? (int)this.emptyLineState : 3);
                        return;
                    }
                    fieldChars[fieldLength++] = (char)firstCode;
                    while (true) {
                        int subCode;
                        int n10;
                        if (i < l) {
                            n10 = b[i++];
                        } else {
                            l = s.read(b);
                            if (l == -1) {
                                n10 = -1;
                            } else {
                                i = 1;
                                n10 = subCode = b[1 - 1];
                            }
                        }
                        if (n10 == -1) break;
                        if (subCode == delimiterCode) {
                            this.state = (byte)(firstField ? 1 : 2);
                            return;
                        }
                        if (subCode == eolCode0) {
                            switch (eolType) {
                                case 20: {
                                    this.state = (byte)(firstField ? 4 : 3);
                                    return;
                                }
                                case 21: {
                                    int n11;
                                    if (i < l) {
                                        n11 = b[i++];
                                    } else {
                                        l = s.read(b);
                                        if (l == -1) {
                                            n11 = -1;
                                        } else {
                                            i = 1;
                                            n11 = b[1 - 1];
                                        }
                                    }
                                    if (n11 != eolCode1) {
                                        --i;
                                        break;
                                    }
                                    this.state = (byte)(firstField ? 4 : 3);
                                    return;
                                }
                                case 22: {
                                    int n12;
                                    if (i < l) {
                                        n12 = b[i++];
                                    } else {
                                        l = s.read(b);
                                        if (l == -1) {
                                            n12 = -1;
                                        } else {
                                            i = 1;
                                            n12 = b[1 - 1];
                                        }
                                    }
                                    if (n12 != eolCode1) {
                                        --i;
                                    }
                                    this.state = (byte)(firstField ? 4 : 3);
                                    return;
                                }
                            }
                        } else if (eolType == 22 && subCode == eolCode1) {
                            this.state = (byte)(firstField ? 4 : 3);
                            return;
                        }
                        fieldChars[fieldLength++] = (char)subCode;
                    }
                    this.state = (byte)(fieldLength > 0 ? (firstField ? 4 : 3) : 6);
                    return;
                }
                this.state = (byte)6;
                return;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new IOException("Field overflow", ex);
            }
            finally {
                this.fieldLength = fieldLength;
                this.bufferLength = l;
                this.bufferIndex = i;
            }
        }

        @Override
        public String toString() {
            return this.fieldLength == 0 ? "" : new String(this.fieldChars, 0, this.fieldLength);
        }

        @Override
        public int length() {
            return this.fieldLength;
        }

        @Override
        public char charAt(int index) {
            if (index >= this.fieldLength) {
                throw new IndexOutOfBoundsException(String.valueOf(index));
            }
            return this.fieldChars[index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (end > this.fieldLength) {
                throw new IndexOutOfBoundsException(String.valueOf(end));
            }
            return new String(this.fieldChars, start, end - start);
        }
    }

    public static interface LineReader
    extends CharSequence {
        public boolean readField() throws IOException;

        public boolean isComment();

        public boolean isQuoted();
    }

    public static final class ReaderOptions {
        private static final boolean DEFAULT_LENIENT_SEPARATOR = false;
        private static final int DEFAULT_MAX_CHARS_PER_FIELD = 4096;
        public static final ReaderOptions DEFAULT = new ReaderOptions(false, 4096);
        private final boolean lenientSeparator;
        private final int maxCharsPerField;

        private ReaderOptions(boolean lenientSeparator, int maxCharsPerField) {
            this.lenientSeparator = lenientSeparator;
            this.maxCharsPerField = maxCharsPerField;
        }

        public boolean isLenientSeparator() {
            return this.lenientSeparator;
        }

        public int getMaxCharsPerField() {
            return this.maxCharsPerField;
        }

        public boolean isValid() {
            return this.maxCharsPerField > 0;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + Boolean.hashCode(this.lenientSeparator);
            hash = 37 * hash + this.maxCharsPerField;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReaderOptions other = (ReaderOptions)obj;
            if (this.lenientSeparator != other.lenientSeparator) {
                return false;
            }
            return this.maxCharsPerField == other.maxCharsPerField;
        }

        public String toString() {
            return "ReaderOptions(lenientSeparator=" + this.lenientSeparator + ", maxCharsPerField=" + this.maxCharsPerField + ')';
        }

        public Builder toBuilder() {
            return new Builder().lenientSeparator(this.lenientSeparator).maxCharsPerField(this.maxCharsPerField);
        }

        public static Builder builder() {
            return DEFAULT.toBuilder();
        }

        public static final class Builder {
            private boolean lenientSeparator;
            private int maxCharsPerField;

            private Builder() {
            }

            public Builder lenientSeparator(boolean lenientSeparator) {
                this.lenientSeparator = lenientSeparator;
                return this;
            }

            public Builder maxCharsPerField(int maxCharsPerField) {
                this.maxCharsPerField = maxCharsPerField;
                return this;
            }

            public ReaderOptions build() {
                return new ReaderOptions(this.lenientSeparator, this.maxCharsPerField);
            }
        }
    }

    public static final class Format {
        public static final String WINDOWS_SEPARATOR = "\r\n";
        public static final String UNIX_SEPARATOR = "\n";
        public static final String MACINTOSH_SEPARATOR = "\r";
        private static final String DEFAULT_SEPARATOR = "\r\n";
        private static final char DEFAULT_DELIMITER = ',';
        private static final char DEFAULT_QUOTE = '\"';
        private static final char DEFAULT_COMMENT = '#';
        private static final boolean DEFAULT_ACCEPT_MISSING_FIELD = true;
        public static final Format RFC4180;
        public static final Format DEFAULT;
        private final String separator;
        private final char delimiter;
        private final char quote;
        private final char comment;
        private final boolean acceptMissingField;

        private Format(String separator, char delimiter, char quote, char comment, boolean acceptMissingField) {
            this.separator = Objects.requireNonNull(separator, "separator");
            this.delimiter = delimiter;
            this.quote = quote;
            this.comment = comment;
            this.acceptMissingField = acceptMissingField;
        }

        public String getSeparator() {
            return this.separator;
        }

        public char getDelimiter() {
            return this.delimiter;
        }

        public char getQuote() {
            return this.quote;
        }

        public char getComment() {
            return this.comment;
        }

        public boolean isAcceptMissingField() {
            return this.acceptMissingField;
        }

        public boolean isValid() {
            return Format.hasValidSize(this.separator) && this.delimiter != this.quote && this.comment != this.delimiter && this.comment != this.quote && Format.doesNotContain(this.separator, this.delimiter) && Format.doesNotContain(this.separator, this.quote) && Format.doesNotContain(this.separator, this.comment);
        }

        private static boolean hasValidSize(String text) {
            int length = text.length();
            return 1 <= length && length < 3;
        }

        private static boolean doesNotContain(String text, char c) {
            return text.indexOf(c) == -1;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + Objects.hashCode(this.separator);
            hash = 37 * hash + this.delimiter;
            hash = 37 * hash + this.quote;
            hash = 37 * hash + this.comment;
            hash = 37 * hash + (this.acceptMissingField ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Format other = (Format)obj;
            if (!this.separator.equals(other.separator)) {
                return false;
            }
            if (this.delimiter != other.delimiter) {
                return false;
            }
            if (this.quote != other.quote) {
                return false;
            }
            if (this.comment != other.comment) {
                return false;
            }
            return this.acceptMissingField == other.acceptMissingField;
        }

        public String toString() {
            return "Format(separator=" + Format.prettyPrint(this.separator) + ", delimiter=" + Format.prettyPrint(this.delimiter) + ", quote=" + Format.prettyPrint(this.quote) + ", comment=" + Format.prettyPrint(this.comment) + ", acceptMissingField=" + this.acceptMissingField + ')';
        }

        private static String prettyPrint(String text) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                result.append(Format.prettyPrint(text.charAt(i)));
            }
            return result.toString();
        }

        private static String prettyPrint(char c) {
            switch (c) {
                case '\t': {
                    return "\\t";
                }
                case '\b': {
                    return "\\b";
                }
                case '\n': {
                    return "\\n";
                }
                case '\r': {
                    return "\\r";
                }
                case '\f': {
                    return "\\f";
                }
                case '\"': {
                    return "\\\"";
                }
                case '\\': {
                    return "\\\\";
                }
            }
            return String.valueOf(c);
        }

        public Builder toBuilder() {
            return new Builder().separator(this.separator).delimiter(this.delimiter).quote(this.quote).comment(this.comment).acceptMissingField(this.acceptMissingField);
        }

        public static Builder builder() {
            return DEFAULT.toBuilder();
        }

        static {
            DEFAULT = RFC4180 = new Format("\r\n", ',', '\"', '#', true);
        }

        public static final class Builder {
            private String separator;
            private char delimiter;
            private char quote;
            private char comment;
            private boolean acceptMissingField;

            private Builder() {
            }

            public Builder separator(String separator) {
                this.separator = separator;
                return this;
            }

            public Builder delimiter(char delimiter) {
                this.delimiter = delimiter;
                return this;
            }

            public Builder quote(char quote) {
                this.quote = quote;
                return this;
            }

            public Builder comment(char comment) {
                this.comment = comment;
                return this;
            }

            public Builder acceptMissingField(boolean acceptMissingField) {
                this.acceptMissingField = acceptMissingField;
                return this;
            }

            public Format build() {
                return new Format(this.separator, this.delimiter, this.quote, this.comment, this.acceptMissingField);
            }
        }
    }
}

