/*
 * Decompiled with CFR 0.152.
 */
package internal.sql.lhod.vbs;

import internal.sql.lhod.TabDataExecutor;
import internal.sql.lhod.TabDataQuery;
import internal.sql.lhod.TabDataReader;
import internal.sys.ResourceExtractor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.sys.ProcessReader;
import nbbrd.io.win.CScriptWrapper;

final class VbsExecutor
implements TabDataExecutor {
    @NonNull
    private final ResourceExtractor scripts;
    private boolean closed = false;

    @Override
    @NonNull
    public TabDataReader exec(@NonNull TabDataQuery query) throws IOException {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (this.closed) {
            throw new IOException("Executor closed");
        }
        return TabDataReader.of(this.exec(query.getProcedure() + ".vbs", query.getParameters().toArray(new String[0])));
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private BufferedReader exec(String scriptName, String[] args) throws IOException {
        File script = this.scripts.getResourceAsFile(scriptName);
        Process process = CScriptWrapper.exec((File)script, (short)-1, (String[])this.encodeArguments(args));
        return ProcessReader.newReader((Charset)Charset.defaultCharset(), (Process)process);
    }

    private String[] encodeArguments(String[] args) {
        return (String[])Stream.of(args).map(VbsExecutor::emptyToDoubleQuotes).toArray(String[]::new);
    }

    private static String emptyToDoubleQuotes(String arg) {
        return arg.isEmpty() ? "\"\"" : arg;
    }

    @Generated
    public VbsExecutor(@NonNull ResourceExtractor scripts) {
        if (scripts == null) {
            throw new NullPointerException("scripts is marked non-null but is null");
        }
        this.scripts = scripts;
    }
}

