/*
 * Decompiled with CFR 0.152.
 */
package internal.sys;

import internal.sys.ResourceExtractor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CachedResourceExtractor
implements ResourceExtractor {
    @lombok.NonNull
    private final ResourceExtractor extractor;
    @lombok.NonNull
    private final ConcurrentMap<String, Entry> index;

    @Override
    @lombok.NonNull
    public File getResourceAsFile(@lombok.NonNull String resourceName) throws IOException {
        Objects.requireNonNull(resourceName);
        Entry result = (Entry)this.index.get(resourceName);
        if (!this.isValid(result)) {
            result = this.newEntry(resourceName);
            this.index.put(resourceName, result);
        }
        return result.getFile();
    }

    private boolean isValid(Entry entry) throws IOException {
        return entry != null && entry.isValidFile();
    }

    private Entry newEntry(String resourceName) throws IOException {
        File file = this.extractor.getResourceAsFile(resourceName);
        return new Entry(file, file.length(), Files.getLastModifiedTime(file.toPath(), new LinkOption[0]));
    }

    public static Builder builder() {
        return new Builder().index(new ConcurrentHashMap<String, Entry>());
    }

    public static CachedResourceExtractor of(ResourceExtractor extractor) {
        return CachedResourceExtractor.builder().extractor(extractor).build();
    }

    @Generated
    public CachedResourceExtractor(@lombok.NonNull ResourceExtractor extractor, @lombok.NonNull ConcurrentMap<String, Entry> index) {
        if (extractor == null) {
            throw new NullPointerException("extractor is marked non-null but is null");
        }
        if (index == null) {
            throw new NullPointerException("index is marked non-null but is null");
        }
        this.extractor = extractor;
        this.index = index;
    }

    public static final class Entry {
        private final File file;
        private final long size;
        private final FileTime lastModified;

        public boolean isValidFile() throws IOException {
            return this.file.exists() && this.file.isFile() && this.file.canRead() && this.size == this.file.length() && this.lastModified.equals(Files.getLastModifiedTime(this.file.toPath(), new LinkOption[0]));
        }

        @Generated
        public Entry(File file, long size, FileTime lastModified) {
            this.file = file;
            this.size = size;
            this.lastModified = lastModified;
        }

        @Generated
        public File getFile() {
            return this.file;
        }

        @Generated
        public long getSize() {
            return this.size;
        }

        @Generated
        public FileTime getLastModified() {
            return this.lastModified;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (this.getSize() != other.getSize()) {
                return false;
            }
            File this$file = this.getFile();
            File other$file = other.getFile();
            if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
                return false;
            }
            FileTime this$lastModified = this.getLastModified();
            FileTime other$lastModified = other.getLastModified();
            return !(this$lastModified == null ? other$lastModified != null : !((Object)this$lastModified).equals(other$lastModified));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $size = this.getSize();
            result = result * 59 + (int)($size >>> 32 ^ $size);
            File $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
            FileTime $lastModified = this.getLastModified();
            result = result * 59 + ($lastModified == null ? 43 : ((Object)$lastModified).hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "CachedResourceExtractor.Entry(file=" + this.getFile() + ", size=" + this.getSize() + ", lastModified=" + this.getLastModified() + ")";
        }
    }

    public static final class Builder {
        @Generated
        private ResourceExtractor extractor;
        @Generated
        private ConcurrentMap<String, Entry> index;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder extractor(@lombok.NonNull ResourceExtractor extractor) {
            if (extractor == null) {
                throw new NullPointerException("extractor is marked non-null but is null");
            }
            this.extractor = extractor;
            return this;
        }

        @Generated
        public @NonNull Builder index(@lombok.NonNull ConcurrentMap<String, Entry> index) {
            if (index == null) {
                throw new NullPointerException("index is marked non-null but is null");
            }
            this.index = index;
            return this;
        }

        @Generated
        public @NonNull CachedResourceExtractor build() {
            return new CachedResourceExtractor(this.extractor, this.index);
        }

        @Generated
        public @NonNull String toString() {
            return "CachedResourceExtractor.Builder(extractor=" + this.extractor + ", index=" + this.index + ")";
        }
    }
}

