/*
 * Decompiled with CFR 0.152.
 */
package internal.sql.odbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.NonNull;
import nbbrd.sql.odbc.OdbcConnectionSupplierSpi;

public final class FailsafeOdbcConnectionSupplier
implements OdbcConnectionSupplierSpi {
    private static final Logger log = Logger.getLogger(FailsafeOdbcConnectionSupplier.class.getName());
    @NonNull
    private final OdbcConnectionSupplierSpi delegate;
    @NonNull
    private final BiConsumer<? super String, ? super RuntimeException> onUnexpectedError;
    @NonNull
    private final Consumer<? super String> onUnexpectedNull;

    public static OdbcConnectionSupplierSpi wrap(OdbcConnectionSupplierSpi delegate) {
        return new FailsafeOdbcConnectionSupplier(delegate, FailsafeOdbcConnectionSupplier::logUnexpectedError, FailsafeOdbcConnectionSupplier::logUnexpectedNull);
    }

    @Override
    public String getName() {
        String result;
        try {
            result = this.delegate.getName();
        }
        catch (RuntimeException unexpected) {
            String msg = this.getUnexpectedErrorMsg("getName");
            this.onUnexpectedError.accept(msg, unexpected);
            return this.getId();
        }
        if (result == null) {
            String msg = this.getUnexpectedNullMsg("getName");
            this.onUnexpectedNull.accept(msg);
            return this.getId();
        }
        return result;
    }

    @Override
    public boolean isAvailable() {
        try {
            return this.delegate.isAvailable();
        }
        catch (RuntimeException unexpected) {
            String msg = this.getUnexpectedErrorMsg("isAvailable");
            this.onUnexpectedError.accept(msg, unexpected);
            return false;
        }
    }

    @Override
    public int getCost() {
        try {
            return this.delegate.getCost();
        }
        catch (RuntimeException unexpected) {
            String msg = this.getUnexpectedErrorMsg("getCost");
            this.onUnexpectedError.accept(msg, unexpected);
            return Integer.MAX_VALUE;
        }
    }

    @Override
    public Connection getConnection(String connectionString) throws SQLException {
        Connection result;
        Objects.requireNonNull(connectionString);
        try {
            result = this.delegate.getConnection(connectionString);
        }
        catch (RuntimeException unexpected) {
            String msg = this.getUnexpectedErrorMsg("getConnection");
            this.onUnexpectedError.accept(msg, unexpected);
            throw new SQLException(msg, unexpected);
        }
        if (result == null) {
            String msg = this.getUnexpectedNullMsg("getConnection");
            this.onUnexpectedNull.accept(msg);
            throw new SQLException(msg);
        }
        return result;
    }

    private String getId() {
        return this.delegate.getClass().getName();
    }

    private String getUnexpectedErrorMsg(String method) {
        return "Unexpected error while calling '" + method + "' on '" + this.getId() + "'";
    }

    private String getUnexpectedNullMsg(String method) {
        return "Unexpected null while calling '" + method + "' on '" + this.getId() + "'";
    }

    private static void logUnexpectedError(String msg, RuntimeException ex) {
        log.log(Level.WARNING, msg, ex);
    }

    private static void logUnexpectedNull(String msg) {
        log.log(Level.WARNING, msg);
    }

    public FailsafeOdbcConnectionSupplier(@NonNull OdbcConnectionSupplierSpi delegate, @NonNull BiConsumer<? super String, ? super RuntimeException> onUnexpectedError, @NonNull Consumer<? super String> onUnexpectedNull) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (onUnexpectedError == null) {
            throw new NullPointerException("onUnexpectedError is marked non-null but is null");
        }
        if (onUnexpectedNull == null) {
            throw new NullPointerException("onUnexpectedNull is marked non-null but is null");
        }
        this.delegate = delegate;
        this.onUnexpectedError = onUnexpectedError;
        this.onUnexpectedNull = onUnexpectedNull;
    }
}

