/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.sql.odbc;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class OdbcConnectionString {
    @lombok.NonNull
    private final Map<String, String> attributes;
    private static final String DRIVER_KEYWORD = "DRIVER";
    private static final Pattern KEY_VALUE = Pattern.compile("(\\w+)=\\{*((?<=\\{)[^\\{\\}]+(?=\\})|[^\\s;]+)\\}*;?");

    private OdbcConnectionString(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public @Nullable String getDriver() {
        return this.get(DRIVER_KEYWORD);
    }

    public @Nullable String get(@NonNull String key) {
        return this.attributes.entrySet().stream().filter(o -> ((String)o.getKey()).equalsIgnoreCase(key)).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<String, String>> iter = this.attributes.entrySet().iterator();
        if (iter.hasNext()) {
            Map.Entry<String, String> o = iter.next();
            OdbcConnectionString.append(result, o);
            while (iter.hasNext()) {
                o = iter.next();
                result.append(";");
                OdbcConnectionString.append(result, o);
            }
        }
        return result.toString();
    }

    private static void append(StringBuilder b, Map.Entry<String, String> o) {
        if (o.getKey().equalsIgnoreCase(DRIVER_KEYWORD)) {
            b.append(o.getKey()).append("={").append(o.getValue()).append("}");
        } else {
            b.append(o.getKey()).append("=").append(o.getValue());
        }
    }

    public static @NonNull OdbcConnectionString parse(@NonNull CharSequence input) {
        Builder result = OdbcConnectionString.builder();
        Matcher m = KEY_VALUE.matcher(input);
        while (m.find()) {
            result.with(m.group(1), m.group(2));
        }
        return result.build();
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    @lombok.NonNull
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OdbcConnectionString)) {
            return false;
        }
        OdbcConnectionString other = (OdbcConnectionString)o;
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public static final class Builder {
        private final LinkedHashSet<String> order = new LinkedHashSet();
        private final TreeMap<String, String> attributes = new TreeMap(String.CASE_INSENSITIVE_ORDER);

        public @NonNull Builder with(@NonNull String key, @NonNull String value) {
            this.order.add(key);
            this.attributes.put(key, value);
            return this;
        }

        public @NonNull OdbcConnectionString build() {
            LinkedHashMap result = new LinkedHashMap();
            this.order.forEach(o -> result.put(o, this.attributes.get(o)));
            return new OdbcConnectionString(Collections.unmodifiableMap(result));
        }

        private Builder() {
        }
    }
}

