/*
 * Decompiled with CFR 0.152.
 */
package com.serverlesshandlers;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.serverlesshandlers.ApiGatewayResponse;
import com.serverlesshandlers.RestHandlers;
import com.serverlesshandlers.annotations.HandlerMapping;
import com.serverlesshandlers.annotations.HttpType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.reflections.Reflections;

public abstract class LambdaHandler
implements RequestHandler<Map<String, Object>, ApiGatewayResponse> {
    private static final Logger LOG = Logger.getLogger(LambdaHandler.class);
    private Map<String, Map<HttpType, RestHandlers>> handlerMap = new HashMap<String, Map<HttpType, RestHandlers>>();

    public LambdaHandler() {
        System.out.println("Init");
        Reflections reflections = new Reflections(new Object[0]);
        Set handlerClasses = reflections.getTypesAnnotatedWith(HandlerMapping.class, true);
        for (Class c : handlerClasses) {
            HandlerMapping mapping = c.getAnnotation(HandlerMapping.class);
            System.out.println("Mappings Availble are :" + (Object)((Object)mapping.httpMethod()));
            System.out.println("Mapping for :" + mapping.path());
            try {
                Map<Object, Object> resourceMap;
                if (!this.handlerMap.containsKey(mapping.path())) {
                    resourceMap = new HashMap<HttpType, RestHandlers>();
                    resourceMap.put((Object)mapping.httpMethod(), (RestHandlers)c.newInstance());
                    this.handlerMap.put(mapping.path(), resourceMap);
                    continue;
                }
                resourceMap = this.handlerMap.get(mapping.path());
                resourceMap.put((Object)mapping.httpMethod(), (RestHandlers)c.newInstance());
                this.handlerMap.put(mapping.path(), resourceMap);
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.error((Object)("Error Instantiating Handler: " + c.getName()));
            }
        }
    }

    public ApiGatewayResponse handleRequest(Map<String, Object> input, Context context) {
        String httpMethod = (String)input.get("httpMethod");
        String httpBody = (String)input.get("body");
        String path = (String)input.get("path");
        Map queryParams = (Map)input.get("queryStringParameters");
        if (null != queryParams) {
            LOG.info((Object)("ProductId: " + (String)queryParams.get("productId")));
        }
        LOG.info((Object)("received: " + path));
        LOG.info((Object)("For : " + httpMethod));
        LOG.info((Object)("Request Body: " + (String)input.get("body")));
        return this.handlerMap.get(path).get((Object)this.getHttpType(httpMethod)).invoke(httpBody, queryParams);
    }

    private HttpType getHttpType(String httpMethod) {
        HttpType httpType = HttpType.GET;
        switch (httpMethod) {
            case "GET": {
                httpType = HttpType.GET;
                break;
            }
            case "POST": {
                httpType = HttpType.POST;
                break;
            }
            case "DELETE": {
                httpType = HttpType.DELETE;
                break;
            }
            case "PATCH": {
                httpType = HttpType.PATCH;
                break;
            }
            default: {
                return HttpType.GET;
            }
        }
        return httpType;
    }

    public static void main(String[] args) {
        Test handler = new Test();
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("httpMethod", "GET");
        Context context = null;
        handler.handleRequest(input, context);
    }

    static class Test
    extends LambdaHandler {
        Test() {
        }
    }
}

