/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.service;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.model.Verifier;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;

public class MailruOAuthServiceImpl
extends OAuth20Service {
    public MailruOAuthServiceImpl(DefaultApi20 api, OAuthConfig config) {
        super(api, config);
    }

    public void signRequest(Token accessToken, AbstractRequest request) {
        request.addQuerystringParameter("session_key", accessToken.getToken());
        request.addQuerystringParameter("app_id", this.getConfig().getApiKey());
        String completeUrl = request.getCompleteUrl();
        try {
            String clientSecret = this.getConfig().getApiSecret();
            int queryIndex = completeUrl.indexOf(63);
            if (queryIndex != -1) {
                String urlPart = completeUrl.substring(queryIndex + 1);
                TreeMap<String, String> map = new TreeMap<String, String>();
                for (String param : urlPart.split("&")) {
                    String[] parts = param.split("=");
                    map.put(parts[0], parts.length == 1 ? "" : parts[1]);
                }
                StringBuilder urlNew = new StringBuilder();
                for (Map.Entry entry : map.entrySet()) {
                    urlNew.append((String)entry.getKey());
                    urlNew.append('=');
                    urlNew.append((String)entry.getValue());
                }
                String sigSource = URLDecoder.decode(urlNew.toString(), "UTF-8") + clientSecret;
                request.addQuerystringParameter("sig", DigestUtils.md5Hex((String)sigSource));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    protected <T extends AbstractRequest> T createAccessTokenRequest(Verifier verifier, T request) {
        super.createAccessTokenRequest(verifier, request);
        if (!this.getConfig().hasGrantType()) {
            request.addParameter("grant_type", "authorization_code");
        }
        return request;
    }
}

